package org.bouncycastle.asn1;

import java.io.*;
import java.util.*;

/**
 * BER TaggedObject - in ASN.1 nottation this is any object proceeded by
 * a [n] where n is some number - these are assume to follow the construction
 * rules (as with sequences).
 */
public class BERTaggedObject
    extends DERTaggedObject
{
    /**
     * This creates an empty tagged object of tagNo (ie. zero length).
     *
     * @param tagNo the tag number for this object.
     */
    public BERTaggedObject(
        int     tagNo)
    {
		super(tagNo);
    }

    /**
     * @param tagNo the tag number for this object.
     * @param obj the tagged object.
     */
    public BERTaggedObject(
        int             tagNo,
        DEREncodable    obj)
    {
		super(tagNo, obj);
    }

    /**
     * @param explicit true if an explicitly tagged object.
     * @param tagNo the tag number for this object.
     * @param obj the tagged object.
     */
    public BERTaggedObject(
        boolean         explicit,
        int             tagNo,
        DEREncodable    obj)
    {
		super(explicit, tagNo, obj);
    }

    void encode(
        DEROutputStream  out)
        throws IOException
    {
		if (out instanceof BEROutputStream)
		{
            out.write(CONSTRUCTED | TAGGED | tagNo);
            out.write(0x80);

			if (!empty)
			{
				ByteArrayOutputStream   bOut = new ByteArrayOutputStream();
				BEROutputStream         dOut = new BEROutputStream(bOut);

                if (!explicit)
                {
                    if (obj instanceof BERConstructedOctetString)
                    {
                        Vector  octs = ((BERConstructedOctetString)obj).getDEROctets();

                        for (int i = 0; i != octs.size(); i++)
                        {
                            dOut.writeObject(octs.elementAt(i));
                        }
                    }
                    else
                    {
                        dOut.writeObject(obj); // hmmm...
                    }
                }
                else
                {
				    dOut.writeObject(obj);
                }

				dOut.close();

                out.write(bOut.toByteArray());
			}

            out.write(0x00);
            out.write(0x00);
		}
		else
		{
			super.encode(out);
		}
    }
}
