package org.bouncycastle.asn1;

import java.io.*;
import java.util.*;

public class BERConstructedSequence
    extends DERConstructedSequence
{
    /*
     */
    void encode(
        DEROutputStream out)
        throws IOException
    {
        if (out instanceof BEROutputStream)
        {
            ByteArrayOutputStream   bOut = new ByteArrayOutputStream();
            BEROutputStream         dOut = new BEROutputStream(bOut);
            Enumeration             e = getObjects();

            while (e.hasMoreElements())
            {
                Object    obj = e.nextElement();

                dOut.writeObject(obj);
            }

            dOut.close();

            byte[]  bytes = bOut.toByteArray();

            out.write(SEQUENCE | CONSTRUCTED);
            out.write(0x80);
            out.write(bytes);
            out.write(0x00);
            out.write(0x00);
        }
        else
        {
            super.encode(out);
        }
    }
}
