package org.bouncycastle.asn1;

import java.io.*;

/**
 * ASN.1 TaggedObject - in ASN.1 nottation this is any object proceeded by
 * a [n] where n is some number - these are assume to follow the construction
 * rules (as with sequences).
 */
public abstract class ASN1TaggedObject
    extends DERObject
{
    int             tagNo;
    boolean         empty = false;
    boolean         explicit = true;
    DEREncodable    obj = null;

    /**
     * This creates an empty tagged object of tagNo (ie. zero length).
     *
     * @param tagNo the tag number for this object.
     */
    public ASN1TaggedObject(
        int     tagNo)
    {
        this.explicit = true;
        this.tagNo = tagNo;
        this.empty = true; 
    }

    /**
     * This creates an empty tagged object of tagNo (ie. zero length).
     *
     * @param tagNo the tag number for this object.
     */
    public ASN1TaggedObject(
        boolean explicit,
        int     tagNo)
    {
        this.explicit = explicit;
        this.tagNo = tagNo;
        this.empty = true; 
    }

    /**
     * @param tagNo the tag number for this object.
     * @param obj the tagged object.
     */
    public ASN1TaggedObject(
        int             tagNo,
        DEREncodable    obj)
    {
        this.explicit = true;
        this.tagNo = tagNo;
        this.obj = obj;
    }

    /**
     * @param explicit true if the object is explicitly tagged.
     * @param tagNo the tag number for this object.
     * @param obj the tagged object.
     */
    public ASN1TaggedObject(
        boolean         explicit,
        int             tagNo,
        DEREncodable    obj)
    {
        this.explicit = explicit;
        this.tagNo = tagNo;
        this.obj = obj;
    }

    public int getTagNo()
    {
        return tagNo;
    }

    public boolean isExplicit()
    {
        return explicit;
    }

    public boolean isEmpty()
    {
        return empty;
    }

    public DERObject getObject()
    {
        if (obj != null)
        {
            return obj.getDERObject();
        }

        return null;
    }

    abstract void encode(DEROutputStream  out)
        throws IOException;
}
