package org.bouncycastle.asn1;

import java.io.*;
import java.util.*;

public abstract class ASN1Sequence
    extends DERObject
{
    private Vector seq = new Vector();

    public static ASN1Sequence getInstance(
        Object  obj)
    {
        if (obj == null || obj instanceof ASN1Sequence)
        {
            return (ASN1Sequence)obj;
        }

        if (obj instanceof ASN1TaggedObject)
        {
            DERObject  o = ((ASN1TaggedObject)obj).getObject();

            if (o instanceof ASN1Sequence)
            {
                return (ASN1Sequence)o;
            }
            else
            {
                //
                // as it's implicitly tagged we can loose the"sequence"
                // if there is only one object.
                //
                DERConstructedSequence s = new DERConstructedSequence();

                s.addObject(o);

                return s;
            }
        }

        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public void addObject(
        DEREncodable obj)
    {
        seq.addElement(obj);
    }

    public Enumeration getObjects()
    {
        return seq.elements();
    }

    /**
     * return the object at the sequence postion indicated by index.
     *
     * @param the sequence number (starting at zero) of the object
     * @return the object at the sequence postion indicated by index.
     */
    public DEREncodable getObjectAt(
        int index)
    {
        return (DEREncodable)seq.elementAt(index);
    }

    /**
     * return the number of objects in this sequence.
     *
     * @return the number of objects in this sequence.
     */
    public int getSize()
    {
        return seq.size();
    }

    abstract void encode(DEROutputStream out)
        throws IOException;
}
