 
package Proxy;           

/***
 * Purpose: Proxy is the main driver class of package Proxy. Proxy 
 * 					contains the init(),doGet(),doPost(), destroy() methods
 * 					that are invoked by the servlet server when the Proxy
 * 					is initially loaded, when messages are received for the
 * 					Proxy and when the servlet server shuts down Proxy.
 ***/

import java.net.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class Proxy extends HttpServlet implements FileManagerConstants{

		FileOutputStream dfos;
		PrintStream dps;
		static Map cacheMap;

  /** Initializes the servlet.**/  
	public void init(ServletConfig config) throws ServletException {

  	super.init(config);
		System.out.println("In init() of Proxy servlet" );

		/***
		 * cacheMap is a TreeMap having FNode objects as its nodes. The
		 * fileId serves as the key for the tree. An FNode object (on 
		 * Proxy) can store blocks of a file. cacheMap is used to 
		 * cache files on Proxy.
		 ***/
		cacheMap = Collections.synchronizedMap(new TreeMap());

		try{
			//log messages.
			System.out.println("Sending Debug Messages to file debug.log");
			dfos = new FileOutputStream("debug.log");
			dps = new PrintStream(dfos);
			System.setOut(dps);
		}catch(Exception e){
			System.out.println("Couldn't set output stream to log file");
		}

    }

    /** Destroys the servlet*/  
    public void destroy() {
			//No need to save any state on Proxy. Simply close the log file.
			dps.close();
    }

    /** Handles the HTTP <code>GET</code> method.
    * @param request servlet request
    * @param response servlet response
    */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, java.io.IOException {

			System.out.println("****************In GET******************");
			System.out.println("...not supported");

    } 

    /** Handles the HTTP <code>POST</code> method.
    * @param request servlet request
    * @param response servlet response
    */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, java.io.IOException {

			System.out.println("\n****************In Post******************\n");
			ServletInputStream sis = request.getInputStream();
			ServletOutputStream sos = response.getOutputStream();

			//Create FM_Owner instance to handle the interaction
			try{

				System.out.println("Instantiating HHProxy...");

				HHProxy hhProxy = new HHProxy(sis,sos,cacheMap); //Thats it!!!


			} catch(Exception e){
				System.out.println(	"Could not instantiate HHProxy..."
														+e.getMessage());	
			}
    }

    /* Returns a short description of the servlet*/
    public String getServletInfo() {
        return "Short description";
    }

} //end of FM class

