
package Proxy;


/***
 * Purpose: The OwnerProtocolP class is used to encode the request for
 * 					file information (file server listing and block sigs) to 
 * 					be sent to FM when HH requests blocks of an uncached file.
 * 					The request is encoded in OwnerProtocol format.
 *
 *          Message(s):		6.  Request for FSListing and Block Sigs
 ***/

import java.io.*;

public class OwnerProtocolP implements FileManagerConstants{

	byte protocol = 4;	/*2 for FM-DT protocol, 3 for FM-HH, 4 for FM-P*/
	byte msgType = 0;
	byte[] fId;					//initialized for file request
	int fIdLen;

	//The following are received from the HH in the request and forwarded 
	//to the FM.
	long timeStamp;
	long randNumb;
	int digLen;
	byte[] pSetDigest;


	//Other messages, say, file request
	public OwnerProtocolP(byte msgType, byte[] fileId, long timeStamp, long randNumb, byte[] pSetDigest){

		System.out.println("In constructor of OwnerProtocolHH");
		this.msgType = msgType;	

		fIdLen = fileId.length;
		this.fId = new byte[fIdLen];
		System.arraycopy(fileId, 0, this.fId, 0, fIdLen);

		this.timeStamp = timeStamp;
		this.randNumb = randNumb; 
	
		this.digLen = pSetDigest.length;

		System.out.println("Digest length: " + digLen);
	
		this.pSetDigest = new byte[digLen];
		System.arraycopy(pSetDigest, 0, this.pSetDigest, 0, digLen);

	}

	//Requesting File Listing, used on HH, not on Proxy
	public OwnerProtocolP(byte msgType){
		this.msgType = msgType;
	}
	
	/***
	 * Precondition: data members are initialized.
	 * Postcondition:	returns byte array encoding of request for file server
	 * 								listing and block sigs of a file to be sent to FM.
	 ***/
	
	public byte[] byteEncode()throws Exception{

    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(buf);

   	System.out.println("Encoding OwnerProtocol as a Byte Array");

		out.writeByte(protocol);
		out.writeByte(msgType);

		/***
		 * 	Write password stuff
		 *	Proxy does not know HH password, so simply forward the password
		 *	digest received from HH to FM.
		 ***/

		System.out.println("Writing password stuff to output stream");
		out.writeLong(this.timeStamp);
		out.writeLong(this.randNumb);
		out.writeInt(this.digLen);
		out.write(this.pSetDigest);

		switch(msgType){

			case 5:	//FSList request for a particular fileId
							//Used on DT, not on Proxy.

							System.out.println(	"Encoding request for FSList ");

							out.writeInt(fIdLen);
							out.write(fId);
							break;

			case 6:	//Request for file server list and block sigs for a particular 
							//fileId
							
							System.out.println("Encoding request for FSList and " + 
															"Block Signatures for file: ");

							out.writeInt(fIdLen);
							out.write(fId);
							break;

			default:

			}

		 out.flush();
     return buf.toByteArray();

		}

}//end of class











