package Proxy;

/***
 * Purpose: The FNode object stores information about a file 
 * 					and also the data blocks of the file. A maximum 
 * 					of five FNode objects are stored in the Proxy 
 * 					cache.
 ***/

import java.util.*;
import java.io.*;
import java.net.*;
import java.security.*;

public class FNode implements FileManagerConstants{

	String fId;		//file Id
	
	//file server IPs where this file is replicated
	String[] FS = new String[5];
	int sigSize;
	int noBlocks;
	long blockUnit;
	
	byte[][] blockSig; 	//Space not yet allocated

	byte[][] block;			//block data
	int[] size;					//parallel array-actual block size

	long timeStamp;			//Explicitly set on creation.
											//Updated on each access.
	
	//Initialize data members from BriefFNode
	public FNode(BriefFNode bfn) throws Exception{

		fId = new String(bfn.fId, DEF_ENCODING);

		for(int fsIndex=0;fsIndex<5;fsIndex++)
			FS[fsIndex] = bfn.FS[fsIndex];
		
		sigSize = bfn.sigSize;
		noBlocks = bfn.noBlocks;
		blockUnit = bfn.blockUnit;

		blockSig = new byte[noBlocks][sigSize];

		for(int bIndex=0; bIndex<noBlocks; bIndex++)
			System.arraycopy(bfn.blockSig[bIndex], 0, blockSig[bIndex], 0, sigSize);


		//Allocate space for block array and size array
		block = new byte[noBlocks][(int)blockUnit];
		size = new int[noBlocks];

	}

	//Needs to be explicitly invoked on every access
	public void updateTimeStamp(){
		
		this.timeStamp = System.currentTimeMillis();

	}
	
	//Initializes data members by reading from input stream
	public void byteDecode(InputStream inS) {

		try{
			DataInputStream dis = new DataInputStream(inS);
			int fsTotLength = dis.readInt();
			byte[] fsListArr = new byte[fsTotLength];
			dis.readFully(fsListArr);
			decodeFSList(fsListArr); 	//Reads and initializes IP addresses 
		
			this.sigSize = dis.readInt();
			this.noBlocks = dis.readInt();
			this.blockUnit = dis.readLong();

			//Allocate space to store block sigs
			this.blockSig = new byte[this.noBlocks][this.sigSize];
			int blockIndex = 0;
			
			for(blockIndex=0; blockIndex < this.noBlocks; blockIndex++){

				byte[] sig = new byte[this.sigSize];	
				dis.readFully(sig);
				System.arraycopy(sig, 0, this.blockSig[blockIndex], 0, this.sigSize);

			}

			System.out.println("Stored sigs of " + blockIndex + " blocks");

			if(blockIndex != this.noBlocks){
			//Couldn't get sigs of all blocks
			System.out.println(	"Couldn't get sigs for all " + this.noBlocks 
													+ " blocks");
			}
			
		}catch(Exception e){
			System.out.println("Unexpected termination of input from FM");
			System.out.println(e.getMessage());
		}

	}

	//Helper function, initializes FS data member from fsListArr 
	//byte array.
	private void decodeFSList(byte[] fsListArr) throws Exception{

		ByteArrayInputStream bais = new ByteArrayInputStream(fsListArr);	
		DataInputStream badis = new DataInputStream(bais);
		
		int len;

		//We know that there are 5 FS address Strings
		for(int fsIndex=0; fsIndex < 5; fsIndex++){

			len = badis.readInt();
			byte[] fsArr = new byte[len];
			badis.readFully(fsArr);
			this.FS[fsIndex] = new String(fsArr, DEF_ENCODING);	
			System.out.println("FS IP Address: " + this.FS[fsIndex] + ".");

		}

	}

}//end of class



