package Proxy;

/***
 * Purpose: Minimal File Description sent by FM to Proxy
 * 					to enable Proxy to retrieve the file on behalf 
 * 					of HH.
 ***/

import java.util.*;
import java.io.*;
import java.net.*;
import java.security.*;

public class BriefFNode implements FileManagerConstants{

	byte[] fId;
	
	//file server IPs where this file is replicated
	String[] FS = new String[5];
	int sigSize;
	int noBlocks;
	long blockUnit;
	
	byte[][] blockSig; 	//Space not yet allocated

	public BriefFNode(byte[] fileId){

		this.fId = new byte[fileId.length];
		System.arraycopy(fileId, 0, this.fId, 0, fileId.length);

	}
	
	//Initializes data members from input stream
	public void byteDecode(InputStream inS) {

		try{
			DataInputStream dis = new DataInputStream(inS);
			int fsTotLength = dis.readInt();
			byte[] fsListArr = new byte[fsTotLength];
			dis.readFully(fsListArr);
			decodeFSList(fsListArr); 	//Reads and initializes IP addresses 
		
			this.sigSize = dis.readInt();
			this.noBlocks = dis.readInt();
			this.blockUnit = dis.readLong();

			//Allocate space to store block sigs
			this.blockSig = new byte[this.noBlocks][this.sigSize];
			int blockIndex = 0;
			
			for(blockIndex=0; blockIndex < this.noBlocks; blockIndex++){

				byte[] sig = new byte[this.sigSize];	
				dis.readFully(sig);
				System.arraycopy(sig, 0, this.blockSig[blockIndex], 0, this.sigSize);

			}

			System.out.println("Stored sigs of " + blockIndex + " blocks");

			if(blockIndex != this.noBlocks){
			//Couldn't get sigs of all blocks
			System.out.println(	"Couldn't get sigs for all " + this.noBlocks 
													+ " blocks");
			}
			
		}catch(Exception e){
			System.out.println("Unexpected termination of input from FM");
			System.out.println(e.getMessage());
		}

	}

	//Helper function, decodes fsListArr sent by the FM and initializes 
	//FS data member.
	private void decodeFSList(byte[] fsListArr) throws Exception{

		ByteArrayInputStream bais = new ByteArrayInputStream(fsListArr);	
		DataInputStream badis = new DataInputStream(bais);
		
		int len;

		//We know that there are 5 FS address Strings
		for(int fsIndex=0; fsIndex < 5; fsIndex++){

			len = badis.readInt();
			byte[] fsArr = new byte[len];
			badis.readFully(fsArr);
			this.FS[fsIndex] = new String(fsArr, DEF_ENCODING);	
			System.out.println("FS IP Address: " + this.FS[fsIndex] + ".");

		}

	}

}//end of class



