
package HH;

import java.io.*;
import java.util.Random;	

/***
 * Purpose: HH uses OwnerProtocolHH to exchange messages with Proxy and 
 * 					FM. 
 *
 * 					Messages: 2. Request file blocks from Proxy.
 * 										3. Request file listing from FM.
 * 										5. Request Proxy to flush cache.
 * 										6. Request FM for file information about 
 * 											 a file.
 ***/


import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class OwnerProtocolHH implements FileManagerConstants{

	byte protocol = 3;	/*2 for FM-DT protocol, 3 for FM-HH*/
	byte msgType = 0;

	String password;
	Random mRandom;

	String fId;					//for file request
	int startIndex;			//for file request
	int numReqBlocks;		//for file request

	FileDescription fDesc;

	byte[] data;
	
	//constructor for submit file, not used on HH  
	public OwnerProtocolHH(String pWord, FileDescription fDesc, byte msgType){

		this.fDesc = fDesc;
		this.msgType = msgType;
		this.password = pWord;	//Will be scrambled in encode()
		this.mRandom = new Random(System.currentTimeMillis());

	}

	//constructor for other messages, say request for file blocks
	public OwnerProtocolHH(String pWord, byte msgType, String fId, int startIndex, int numReqBlocks){

		this.msgType = msgType;	
		
		this.fId = fId;
		this.password = pWord;	//Will be scrambled in encode()
		this.mRandom = new Random(System.currentTimeMillis());

		this.startIndex = startIndex;
		this.numReqBlocks = numReqBlocks;

	}
	//constructor, to send data with message.
	public OwnerProtocolHH(String pWord, byte msgType, byte[] data){
		this.msgType = msgType;	

		this.password = pWord;	//Will be scrambled in encode()
		this.mRandom = new Random(System.currentTimeMillis());

		this.data = data; 			//No space allocated for data
	}

	//constructor for requesting file listing
	public OwnerProtocolHH(String pWord, byte msgType){
		this.msgType = msgType;
		this.password = pWord;	//Will be scrambled in encode()
		this.mRandom = new Random(System.currentTimeMillis());
	}

	//constructor for requesting fileInfo for 1 file from FM, msgType=6
	public OwnerProtocolHH(String pWord, byte msgType, String fId){

		this.msgType = msgType;
		this.password = pWord;	//Will be scrambled in encode()
		this.mRandom = new Random(System.currentTimeMillis());
		this.fId = fId;

	}


	  /***
		 * Precondition:  protocol, msgType, password and pRandom are initialized.
		 *                Depending on the msgType, other data members may
		 *                also be required to be initialized.
		 * Psotcondition: Returns a byte encoded array of the OwnerProtocol message
		 *                that can be sent to FM or Proxy.
		 ***/
	public byte[] byteEncode()throws Exception{

    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(buf);


		out.writeByte(protocol);
		out.writeByte(msgType);

		writePass(out,this.password);

		switch(msgType){

			case 1: //submit file, not used on HH
							//byte [] fDescArr = fDesc.byteEncode();
							//out.writeInt(fDescArr.length);
							//out.write(fDescArr);
							break;

			case 2: {//request file blocks

							if(this.fId==null) {
								System.out.println("ERROR: fId is null in OwnerProtocolHH");
								return null;
							}

							byte[] fIdArr = this.fId.getBytes(DEF_ENCODING);
							out.writeInt(fIdArr.length);
							out.write(fIdArr);
							out.writeInt(startIndex);
							out.writeInt(numReqBlocks);

							//sigs of requested blocks
							BriefFNode bfn = FileDirectory.currBFN;	
							int endIndex = startIndex+numReqBlocks;
							int index;
							for(int sIndex=startIndex; sIndex<endIndex; sIndex++){

								if(sIndex>=bfn.noBlocks) index=(bfn.noBlocks-1);
								else index=sIndex;
								out.write(bfn.blockSig[index]);

							}
							break;
							}
			case 3:	//Request file listing
							//No data to be sent
							break;

			case 5: //flush Proxy cache
							out.writeInt(data.length);
							out.write(data);
							break;
							
			case 6: {//request FM for fileInfo of 1 file

							byte[] fIdArr = this.fId.getBytes(DEF_ENCODING);
							out.writeInt(fIdArr.length);
							out.write(fIdArr);
							break;

							}
							
			default:
			}

		 out.flush();
     return buf.toByteArray();

		}

	/***
	 * Precondition: 	writePass() is passed the current data output stream and 
	 * 								password.
	 * Postcondition:	Writes the current timestamp, a random number
	 * 								and the SHA-1 digest of the timestamp, random number
	 * 								and password to the data output stream. 
	 * 								Does not close the output stream
	 ***/
	public void writePass(DataOutputStream pdos, String pWord) throws Exception{
		
		long timeStamp = System.currentTimeMillis();
		long randomNumber	=	mRandom.nextLong();


		Digest md	= new SHA1Digest();
		
		byte[] tsArr = getBytes(timeStamp);
		byte[] rmArr = getBytes(randomNumber);
		byte[] pArr = pWord.getBytes(DEF_ENCODING);

		md.update(tsArr, 0, tsArr.length);
		md.update(rmArr, 0, rmArr.length);
		md.update(pArr, 0, pArr.length);

		int pSetSize = md.getDigestSize();
		byte[] pSetDigest = new byte[pSetSize];

		md.doFinal(pSetDigest, 0);

		//timestamp
		pdos.writeLong(timeStamp);
		//random number
		pdos.writeLong(randomNumber);
		//the digest of the above two along with the password
		pdos.writeInt(pSetDigest.length);	//digest length, in case we use
																			//another digest later
		pdos.write(pSetDigest);

	}

  /***
	 * The following helper method is from the book Wireless Java:
	 * Developing with Java[tm] 2 Micro Edition, by Jonathan Knudsen
	 * Postcondition: Returns a long data type as a byte array.
	 ***/
	private byte[] getBytes(long x){

		byte[] arr = new byte[8];
		for(int i = 0; i<8; i++){
			arr[i] = (byte)(x >> ((7-i) * 8));
		}
		return arr;

	}

}//end of class











