/***
 *	Purpose: 	This is the primary midlet class and contains the 
 *						startApp(), destroyApp(), commandAction() functions that 
 *						are invoked by the MIDP runtime environment on initialization 
 *						of HH.
 ***/
package HH;

import javax.microedition.lcdui.*;	//Display
import javax.microedition.midlet.*;	
import javax.microedition.io.*;			//For network i/o
import java.io.*;										//For regular i/o
import org.bouncycastle.crypto.*;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class HH extends MIDlet implements CommandListener,FileManagerConstants {

	Display display;
	List 	fileMenu;

	//commands
	static	final	Command	backCommand = new Command("Back", Command.BACK, 0);	
	static	final	Command	mainMenuCommand = new Command("Main", Command.SCREEN, 1);	
	static	final	Command	refreshListCommand = new Command("RefreshList", Command.OK, 3);	
	
	//For display of next and previous blocks
	static	final	Command	nextBlockCommand = new Command("next", Command.OK, 3);	
	static	final	Command	prevBlockCommand = new Command("previous", Command.OK, 3);	

	static	final	Command	exitCommand = new Command("exit", Command.EXIT, 6);	
	String currentMenu;

	TextField fileNameField = null;

		/***GUI for ownerId,password and DES Key***/

    TextField idField = null;
    TextField passwordField = null;
    TextField keyField = null;
    Form sForm;
	
   	String id;
		String pw;
		String key;

    static final Command okCommand = new Command("OK", Command.OK, 2);
    static final Command clearCommand = new Command("clear", Command.STOP, 3);
	
	String currFileName;	//current file viewed
	String currFileId;		//current file viewed

	String[] fileNameList;
	HttpConnection connection;
	HttpConnection pConnection;
	FileDirectory fDir;	//static members can be accessed directly

	int showBlock=0;		//Index of block to be displayed
	byte[][] dBlocks;		//Decrypted Blocks. Row 0 -> Block 0.
											//We cache just 5 blocks of the file.
	int[] size;
	boolean spaceAllocated = false;	//No space allocated for
																	//decrypted blocks
	int totBlocks = 0;
	
	//Constructor
	public HH() throws Exception{
		FMInfo.init();
		fileNameList = new String[100];
		fDir = new FileDirectory();
	}

	//called by MIDP runtime environment when the HH midlet is 
	//started by the user.
	public void startApp() throws MIDletStateChangeException {
		setupMenu();
	}

	/***
	 * Precondition: 	User has entered ownerId, password and DES key.
	 * Postcondition: Calls methods to retrieve file listing from FM.
	 * 								Calls method to send flush cache message to Proxy.
	 ***/
	public void myStartApp(){
		try{
			//Get the fileListing from the FM.
			fileNameList = fileListing();
			refreshProxyCache();
		}catch(Exception e){
			System.out.println("Exception: " + e.getMessage());
		}
		showMenu();	
	}
	
	/***
	 *	Precondition: 	fileNameList already initialized with file names
	 *	Postcondition:	Calls mainMenu() to display file listing on handheld 
	 *									screen.
	 ***/
	public void showMenu(){
		display = Display.getDisplay(this);
		fileMenu = new List("File Listing", Choice.IMPLICIT);
		
		int fileIndex = 0;

		while(fileIndex < 100) {
			String fileName = fileNameList[fileIndex++];
			if ( fileName == null ) break;
			fileMenu.append(fileName, null);
		}

		fileMenu.addCommand(exitCommand);
		fileMenu.addCommand(refreshListCommand);
		fileMenu.setCommandListener(this);
		mainMenu();
	}

	//displays file listing on handheld screen.
	void mainMenu(){
		display.setCurrent(fileMenu);
		currentMenu = "Main";
	}
	//displays GUI objects for user to enter ownerId, password and 
	//DES key.
	public void setupMenu(){

      display = Display.getDisplay(this);
      idField = new TextField("OwnerId:", "", 25, TextField.ANY);
      passwordField = new TextField("Password:", "", 25, TextField.ANY);
      keyField = new TextField("DES Key:", "", 25, TextField.ANY);
      sForm = new Form("Fill Form");

      sForm.append(idField);
      sForm.append(passwordField);
      sForm.append(keyField);
      sForm.addCommand(clearCommand);
      sForm.addCommand(okCommand);
      sForm.setCommandListener(this);
      display.setCurrent(sForm);

	}
	
	//Retrieves file listing over https from FM	
	public String[] fileListing() throws Exception{
					
		fmConnect();	
		fmRequestFileListing();
		return (fmReceiveFileListing());

	}
	
	//Does nothing.
	public void pauseApp(){
	}
	
	//Destroys HH midlet, called by MIDP runtime environment.	
	public void destroyApp(boolean unconditional){
		notifyDestroyed();
	}

	//Retrieve state information about a file from the FM
	public boolean fmRetrieveFileInfo(String fName){

		boolean success = true;
					
		try{
			System.out.println("fmRetrieveFileInfo-Connecting to FM.");
			fmConnect();
			
			fmRequestFileInfo(fName);
			
			success = fmReceiveFileInfo();

		}catch(Exception ee){
			System.out.println("fmRetrieveFileInfo Exception-"+ee.getMessage());
		}

	 	return success;

	}
	
	/***
	 * Precondition: 	file information for the requested file has already 
	 * 								been retrieved from FM by fmRetrieveFileInfo().
	 * Postcondition:	Retrieves encrypted file blocks over http from Proxy
	 ***/
	boolean retrieveFile(String fId, int startIndex, int numReqBlocks) {

		long sTime=0,eTime=0;

		sTime = System.currentTimeMillis();
					
		int attempts = 0;
		boolean success=false;
		while((!success) && ((attempts++) < 5)){
			
			try{	
				proxyConnect();	
			}catch(Exception e){
				System.out.println("1. retrieveFile Exception: " + e.getMessage());
				success = false;
				try{
					if(pConnection != null) pConnection.close();
				}catch(Exception ee){}
				continue;
			}
			try{				
				pRequestFileBlocks(fId, startIndex, numReqBlocks);
			}catch(Exception e){
				System.out.println("2. retrieveFile Exception: " + e.getMessage());
				success=false;
				try{
					if(pConnection != null) pConnection.close();
				}catch(Exception ee){}
				continue;
			}
			try{
				//may give a negative response instead of the encrypted file
				pReceiveFileBlocks(fId, startIndex, numReqBlocks); 
			}catch(Exception e){
				System.out.println("3. retrieveFile Exception: " + e.getMessage());
				success=false;
				try{
					if(pConnection != null) pConnection.close();
				}catch(Exception ee){}
				continue;
			}

			success=true;

		}//end of while()

		if(success) 
			System.out.println("retrieveFile() succeeded in attempt: " + attempts);
		else 
			System.out.println("retrieveFile failed after " + attempts + " attempts.");

		eTime = System.currentTimeMillis();

		System.out.println("Time taken: " + ((eTime-sTime)/1000)+" seconds");
		
		return success;
	
	}//end of retrieveFile()

	/***
	 * Precondition: 	FileDirectory has file listing.
	 * Postcondition: Sends request for file information for file fName to FM.
	 ***/
	public boolean fmRequestFileInfo(String fName){

		String fileId = FileDirectory.getFileId(fName);

		if(fileId == null){
			System.out.println("Could not get fileId.");
			return false;
		}
		
			OutputStream outFMStream;

		try{

			outFMStream = connection.openOutputStream();	
			DataOutputStream ndis = new DataOutputStream(outFMStream);

			ndis.write((byte)OwnerInfo.idLength);
			ndis.write(OwnerInfo.idArr); //the ownerId

			//OwnerProtocolHH contains the passwd
			
			OwnerProtocolHH oProt = new OwnerProtocolHH(OwnerInfo.password,(byte)6, fileId); 	
			byte[] oProtArr = oProt.byteEncode();
			int oLen = oProtArr.length;
			ndis.writeInt(oLen);
			try{
				ndis.flush();
			} catch(Exception ed){
			}
			
			ndis.write(oProtArr);

			ndis.flush();
			ndis.close();
			outFMStream.close();

		}catch (Exception e){
			try{
				if(connection != null) connection.close();
			}catch(Exception ee){}
			System.out.println("9.could not open output stream");
			return false;
		}

	return true;	//all well	

	}//end of fmRequestFileInfo

	/***
	*	Precondition: Request for fileInfo already sent by fmRequestFileInfo()
	*	Postcondition: Enters BriefFileNode object in the FileDirectory
	***/
	public boolean fmReceiveFileInfo(){

		InputStream inFMStream; 
		BriefFNode bfn = new BriefFNode();
		try{
			inFMStream = connection.openInputStream();	
			bfn.byteDecode(inFMStream);
		}catch(Exception e){
			try{
				connection.close();
			}catch(Exception eee){}
			System.out.println("Exception in fmReceiveFileInfo-"+e.getMessage());
			return false;
		}
		FileDirectory.currBFN = bfn;
		try{
			inFMStream.close();
			connection.close();
		}catch(Exception ee){}

		return true;	//all well
	}
	

	//Sends a request to FM for a listing of available files 
	public void fmRequestFileListing(){

			OutputStream outFMStream;
			System.out.println("Going to request File Listing");

		try{

			outFMStream = connection.openOutputStream();	
			DataOutputStream ndis = new DataOutputStream(outFMStream);

			ndis.write((byte)OwnerInfo.idLength);
			ndis.write(OwnerInfo.idArr); //the ownerId

			//OwnerProtocolHH contains the passwd
			
			OwnerProtocolHH oProt = new OwnerProtocolHH(OwnerInfo.password,(byte)3); 	
			byte[] oProtArr = oProt.byteEncode();
			int oLen = oProtArr.length;
			ndis.writeInt(oLen);
			try{
				ndis.flush();
			} catch(Exception ed){
			}
			
			ndis.write(oProtArr);

			ndis.flush();
			ndis.close();
			outFMStream.close();

		}catch (Exception e){
			System.out.println("4.could not open output stream");
		}

	}

	/***
	*	Purpose: 	Receives and displays the listing of files owned by 
	*						the user. 
	*
	*	Precondition: This function is called only when the user 
	*								wants to refresh the file listing. Otherwise, 
	*								the local file listing can be displayed.
	*
	*	Postcondition: Returns listing of user's files.
	***/
	public String[] fmReceiveFileListing(){
		InputStream inFMStream; 

		//Before refreshing FileDirectory, zero out the nIndex
		FileDirectory.nIndex = 0;

		try{

			inFMStream = connection.openInputStream();	

			DataInputStream inDIS = new DataInputStream(inFMStream);
			int FLLen;				//length of File Listing	
			int pURLLen;			//length of Proxy URL array
			try{

				//Receive Proxy URL
				pURLLen = inDIS.readInt();
				byte[] pURLArr = new byte[pURLLen];
				inDIS.readFully(pURLArr);

				String proxyURL = new String(pURLArr, DEF_ENCODING);

				ProxyInfo.init(proxyURL);

				FLLen = inDIS.readInt();
				byte[] fListingArr = new byte[FLLen];
				inDIS.readFully(fListingArr);
				inFMStream.close();	//close input stream from FM
				if(connection != null) connection.close();

				boolean available = true;
			
				ByteArrayInputStream bais = new ByteArrayInputStream(fListingArr);
				DataInputStream badis = new DataInputStream(bais);
				int fNameArrLen = 0;
				int fIdArrLen = 0;
				while(available){
					//decode file names and fIds
					try{
							fNameArrLen = badis.readInt();
							byte[] fNameArr = new byte[fNameArrLen];
							badis.readFully(fNameArr);	
							String fName = new String(fNameArr, DEF_ENCODING);

							fIdArrLen = badis.readInt();
							byte[] fIdArr = new byte[fIdArrLen];
							badis.readFully(fIdArr);	
							String fId = new String(fIdArr, DEF_ENCODING);
							//Now add the fileName and fId to FileDirectory	
							FileDirectory.addFile(fName, fId);
					}
					catch(Exception e){
						available = false;
						System.out.println("No more file names");
					}
					
				}
				return (decodeFileListing());	

			}catch(Exception e){
				try{
					if(inFMStream != null) inFMStream.close();
				}catch(Exception ee){}
				System.out.println("Unable to retrieve file listing");
				return null;
			}
	
		}catch (Exception e){
			try{
				if(connection != null) connection.close();
			}catch(Exception eee){}
			System.out.println("1.Could not open input stream");
			return null;
		}

	}//end of fmReceiveListing()

	/***
	*	Postcondition: 	Returns the file names in the FileDirectory.
	*									Used to display file listing to on handheld screen.
	***/
	public String[] decodeFileListing(){

		//I think this only allocates memory for the pointers to the Strings.
		//The actual Strings will be allocated memory on a as-needed basis.
		//So this is efficient.
		String[] fileNameList = new String[100];
		int numFiles = FileDirectory.nIndex;
		System.out.println(	"\nFileDirectory contains following " 
												+ numFiles + " nodes:");
		for(int fIndex=0; fIndex<numFiles; fIndex++){
			fileNameList[fIndex] = FileDirectory.fileListing[fIndex][0];
			System.out.println(fileNameList[fIndex]);
		}
		return fileNameList;
	}

	/***
	*	Postcondition: 	Decodes byte array, listing, and returns array of 
	*									file name Strings.
	*									NOT USED.
	***/
	public String[] decodeFileListing(byte[] listing){
		ByteArrayInputStream bais = new ByteArrayInputStream(listing);
		DataInputStream badis = new DataInputStream(bais);

		String[] fileList = new String[100];
		int idLen;
		boolean available=true;
		System.out.println("\nFILE LISTING");
		System.out.println("**********");

		int i = 0;
	
		while(available){
			try{

				idLen = badis.readInt();
				byte[] id = new byte[idLen];
				badis.readFully(id);
				String fNameString = new String(id, DEF_ENCODING); 
				if(i<100) {
					try{
						fileList[i++] = fNameString;
					}catch(Exception ee){
						System.out.println("1. Exception: " + ee.getMessage());
					}
				}
				System.out.println(fNameString);
			}catch(Exception e){
				available = false;
			}
		}//end of while

	System.out.println("**********\n");
	return fileList;

	}


	//Purpose: Sends a message to Proxy asking it to clear this users's
	//files from its cache.
	public void refreshProxyCache(){

		System.out.println("Going to refresh Proxy cache.");
		try{
			proxyConnect();
		}catch(Exception e){
				try{
					if(pConnection != null) pConnection.close();
				}catch(Exception ee){}
			System.out.println("1. refreshProxyCache()-"+e.getMessage());
		}
		try{
			pSendRefreshMsg();
		}catch(Exception e){
				try{
					if(pConnection != null) pConnection.close();
				}catch(Exception ee){}
			System.out.println("2. refreshProxyCache()-"+e.getMessage());
		}
			
		try{
			pReceiveConfirm();
		
		}catch(Exception e){
				try{
					if(pConnection != null) pConnection.close();
				}catch(Exception ee){}
			System.out.println("3. refreshProxyCache()-"+e.getMessage());
		}
	}
				
	/***
	 * Precondition: Connection has been established with Proxy.
	 * Postcondition: sends refresh cache message to Proxy.
	 ***/
	public void pSendRefreshMsg(){
		try{	
			OutputStream outPStream;

			outPStream = pConnection.openOutputStream();	

			DataOutputStream ndis = new DataOutputStream(outPStream);
			
    	ByteArrayOutputStream buf = new ByteArrayOutputStream();
    	DataOutputStream out = new DataOutputStream(buf);
	
			//create a data array of fileIds
			try{
			for(int fIndex=0; fIndex<FileDirectory.nIndex; fIndex++){
				byte[] fIdArr = FileDirectory.fileListing[fIndex][1].getBytes(DEF_ENCODING);
				if(fIdArr != null){
					out.writeInt(fIdArr.length);
					out.write(fIdArr);
				}
			}//end of for
			}catch(Exception ee){
	
				System.out.println("1. pSendRefreshMsg()-"+ee.getMessage());

			}
			out.flush();

			byte[] fIdListArr = buf.toByteArray();

			ndis.write((byte)OwnerInfo.idLength);
			ndis.write(OwnerInfo.idArr); //the ownerId


			OwnerProtocolHH oProt = new OwnerProtocolHH(OwnerInfo.password,(byte)5, fIdListArr);
			byte[] oProtArr = oProt.byteEncode();

			int	oProtLen = oProtArr.length;
			ndis.writeInt(oProtLen);
			try{
				ndis.flush();
			} catch(Exception ed){
			}
			ndis.write(oProtArr);

			ndis.flush();
			ndis.close();
			outPStream.close();		//Close output stream to Proxy

		}catch(Exception e){
			System.out.println("2. pSendRefreshMsg()-"+e.getMessage());
		}

	}
	

	//Precondition: Connection has been established with Proxy
	public void pReceiveConfirm(){

	}

	/***
	 *	Precondition: Connection has been established with Proxy.
	 *	Postcondition:Sends request for numReqBlocks blocks to Proxy. 	
	 ***/
	public void pRequestFileBlocks(String fId, int startIndex, int numReqBlocks) throws Exception{
		OutputStream outPStream;

		try{

			outPStream = pConnection.openOutputStream();	

			DataOutputStream ndis = new DataOutputStream(outPStream);

			ndis.write((byte)OwnerInfo.idLength);
			ndis.write(OwnerInfo.idArr); //the ownerId


			OwnerProtocolHH oProt = new OwnerProtocolHH(OwnerInfo.password,(byte)2, fId, startIndex, numReqBlocks); 	
			byte[] oProtArr = oProt.byteEncode();

			int	oProtLen = oProtArr.length;
			ndis.writeInt(oProtLen);
			try{
				ndis.flush();
			} catch(Exception ed){
			}
			ndis.write(oProtArr);

			ndis.flush();
			ndis.close();
			outPStream.close();		//Close output stream to Proxy
		
		}catch (Exception e){
			try{
				pConnection.close();
			}catch(Exception eee){}
			System.out.println("5.could not open output stream");
		}
	}

	/***
	 * Precondition: 	pRequestFileBlocks() has sent request for file blocks 
	 * 								to Proxy.
	 * Postcondition:	Receives requested blocks from Proxy and stores in the 
	 * 								local cache after verifying the block signatures and 
	 * 								decrypting the blocks.
	 ***/
	public void pReceiveFileBlocks(String fId, int startIndex, int numReqBlocks) throws Exception{ 

		//Need info about noBlocks and blockSize and blockSig(s)
		//Just a reference - no more memory used
		BriefFNode bfn = FileDirectory.currBFN;
		boolean failed = false;
		if(bfn == null) {
			System.out.println("Could not get BriefFNode");
			return;
		}
		totBlocks = bfn.noBlocks;

		InputStream inPStream;
		//to decrypt the file blocks.
		Encryptor eTor = new Encryptor((OwnerInfo.DESKey).getBytes());

		try{
			inPStream = pConnection.openInputStream();	


			DataInputStream in = new DataInputStream(inPStream);

				/***
				*	Read the encrypted block
				*	decrypt it
				*	display it
				***/
			try{
				byte[] encBlock = new byte[(int)bfn.blockUnit];
				int numBytes = 0;
				int totBytes = 0;

				if(spaceAllocated){
					//Wipe out previous entries in size array
					for(int i=0; i<numReqBlocks; i++){
						size[i]=-1;
					}
				}
				//to verify block signatures
				Digest md = new SHA1Digest();
		
				int bIndex;
				for(bIndex=0; bIndex<numReqBlocks; bIndex++){	
					numBytes=0;
					totBytes=0;

					numBytes = in.read(encBlock);
					totBytes=numBytes;

					while(totBytes < (int)bfn.blockUnit){
        		if(numBytes == -1){
          		System.out.println("No more bytes");
							if(bIndex==0 && totBytes==0) {
								failed = true;
							}
          		break;		//Will not break out of for
        		}
						numBytes = in.read(encBlock,numBytes,((int)bfn.blockUnit-numBytes));	
						if(numBytes != -1) totBytes += numBytes;
					}

					if(totBytes == -1) break;	//No more blocks

					md.update(encBlock, 0, totBytes);
					int sSize =  md.getDigestSize();

					byte[] newSig = new byte[sSize];
					md.doFinal(newSig,0);

					//Since we download 5 blocks at a time!!!
					int dbIndex = showBlock - (showBlock%5) + bIndex;
					System.out.println("Going to verify sig of block: " + dbIndex); 
					
					//Verify signature of retrieved block
					if(compareSigs(newSig,bfn.blockSig[dbIndex]) !=0) {
						System.out.println("Signature mismatch.");
						throw new Exception();
					}
					
					//decrypt the block.
					byte[] dBlock = eTor.decrypt(encBlock, totBytes);
					
					//Implies that for 1 encrypted block, the decrypted block
					//is of length dBlock.length
					if(!spaceAllocated){
						spaceAllocated = true;
						dBlocks = new byte[numReqBlocks][dBlock.length];
						size = new int[numReqBlocks];
					}

					//buffer blocks		
					System.arraycopy(dBlock, 0, dBlocks[bIndex], 0, dBlock.length);
					//Parallel array to keep track of the size
					size[bIndex] = dBlock.length;
					displayBlock(dBlock);		//displays the block as text in debug screen

				}//end of for

			}catch(Exception e){
				System.out.println(	"Did not receive expected blocks: " 
														+ e.getMessage());
				in.close();
				inPStream.close();	//Close input stream from Proxy
				throw new Exception();
			}
		if(failed) {
			in.close();
			inPStream.close();	//Close input stream from Proxy
			throw new Exception();
		}
		in.close();
		inPStream.close();	//Close input stream from Proxy
		if(pConnection != null) pConnection.close();
		}catch (Exception e){
			try{
				pConnection.close();
			}catch(Exception eee){}
			System.out.println("Did not open input stream-"+e.getMessage());
			throw new Exception();
		}
	}

  	/***
   	* compareSigs() is a helper method that verifies sigs of retrieved blocks 
		* by checking 160 bits of SHA-1 hash.
		*
   	* Postcondition: Returns 0 if sig2 matches sig1, -1 otherwise
 		***/
  public int compareSigs(byte[] sig1, byte[] sig2){

    try{
      for(int sigByte=0; sigByte<20; sigByte++)
          if(sig2[sigByte] != sig1[sigByte]) return -1;

    }catch(Exception e){
      System.out.println("compareSigs Exception-"+e.getMessage());
      return -1;
    }

    return 0;

  }

	
	//Displays a block according to the index showBlock 
	void showFile(){
   	Form form = new Form("Displaying Block");

		//showBlock is between 0 and noBlocks but we have only 5 blocks cached

		int index = showBlock%5;	
		System.out.println("Showing block from local cache. Index: " + index);

		String dString = stringBlock(index);
		TextField blockField = new TextField("Block:",dString, dString.length(), 0);
		form.append(blockField);	
		form.addCommand(nextBlockCommand);
		form.addCommand(prevBlockCommand);
		form.addCommand(exitCommand);
		form.setCommandListener(this);
		display.setCurrent(form);

	}
	
	//Input: index of the block in the buffer(blocks[][])
	//Precondition: blocks has valid data at index
	String stringBlock(int index){

		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		
		if(size[index] == -1){
			System.out.println("size array -1 at index:  " + index);
			return null;
		}
		baos.write(dBlocks[index],0,size[index]);
		String blockString = baos.toString();
		return blockString;

	}

	//Helper method, displays a block in the debugging window in the 
	//wireless emulator.
	void displayBlock(byte[] decBlock){


		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		baos.write(decBlock,0,decBlock.length);
		String blockString = baos.toString();

	}

	//Opens an HTTPS connection to FM.
	public void fmConnect() throws Exception{


		try{
			connection = (HttpConnection)(Connector.open(FMInfo.fmURL, Connector.READ_WRITE));
		}catch (Exception exc){
			System.out.println("3.Could not open connection");
		}
		
		try{
			connection.setRequestMethod(HttpConnection.POST);
		}catch(Exception e){
			System.out.println("Could not POST");
		}
	}
	
	//Opens an HTTP connection to Proxy.	
	public void proxyConnect() throws Exception{


		try{
			pConnection = (HttpConnection)(Connector.open(ProxyInfo.pURL, Connector.READ_WRITE));
		}catch (Exception exc){
			System.out.println("3.Could not open connection");
		}
		
		try{
			pConnection.setRequestMethod(HttpConnection.POST);
		}catch(Exception e){
			System.out.println("Could not POST");
		}
	}

	
	//commandAction() listens for selections made by the handheld user
	//using the soft keys.
	public void commandAction(Command c, Displayable d) {
		String label = c.getLabel();

		if(label.equals("exit")){
			System.out.println("Exit Selected");
			showMenu();
		}
		else if(label.equals("RefreshList")){
			System.out.println("Refreshing File Listing");

			try{
				fileNameList = fileListing();	
				refreshProxyCache();
				showMenu();
			}catch(Exception e){
				System.out.println("Exception: " + e.getMessage());
			}
			
		}

		else if(label.equals("next")){
			if(showBlock < totBlocks-1) showBlock+=1;		//increment block index
			if(((showBlock%5)==0) && (showBlock!=0)) retrieveFile(currFileId,showBlock,5);
			showFile();
		}

		else if(label.equals("previous")){
			if(showBlock > 0)showBlock-=1;		//decrement block index
			if((((showBlock+1)%5)==0) && (showBlock!=0)){
				int sIndex = ((int)(showBlock/5))*5;	
				retrieveFile(currFileId,sIndex,5);
			}
			showFile();	//Display block at overall index showBlock
		}
	
		else if(label.equals("OK")){
			try{
				id = idField.getString();
				pw = passwordField.getString();
				key = keyField.getString();

				OwnerInfo.init(id,pw,key);
				myStartApp();
			}catch(Exception ee){
				System.out.println("Wrong input-"+ee.getMessage());
				destroyApp(true);
			}
		}
		else if(label.equals("clear")){

			destroyApp(true);

		}
		
		else {//implies user has 'clicked' on a file name
			System.out.println("File selected");
			boolean rf,rfi;

			List down = (List)display.getCurrent();
			int fileIndex = down.getSelectedIndex();
			try{

				currFileName=new String(fileNameList[fileIndex]);
				currFileId=FileDirectory.getFileId(currFileName);


				//Retrieve fileInfo from FM
				rfi = fmRetrieveFileInfo(currFileName);

				//startIndex=0,numReqBlocks=5
				spaceAllocated=false;
				showBlock=0;
				rf = retrieveFile(currFileId,0,5);		
				if(rf && rfi) showFile();			//Start by displaying block 0
			}catch(Exception e){
				System.out.println("Exception: " + e.getMessage());
			}
			
		}

	}//end of commandAction()

}//end of class HH

	/***
 	* Purpose: OwnerInfo class stores the ownerId, user's password and
 	*          DES key that the user enters when HH is initialized.
 	***/
  class OwnerInfo implements FileManagerConstants{

     public static String ownerId;
     public static String DESKey;
     public static String password ;

     public static byte[] idArr;
     public static byte idLength; //length of owner id

     public static void init(String id, String pw, String key) throws Exception{

       //read from file and decode
       ownerId = id;
       DESKey = key;
			 password = pw;

       byte[] tempIdArr = ownerId.getBytes(DEF_ENCODING);

        if(tempIdArr.length > MAX_DESC_LEN){
        	System.out.println("ERROR: Owner Id can have maximum " + 
														MAX_DESC_LEN + " bytes");
        	System.exit(1);
      	}
       idLength = (byte)tempIdArr.length;
       idArr = new byte[idLength];

       System.arraycopy(tempIdArr, 0, idArr, 0, idLength);
     }
  }

  /***
	 * Purpose: FMInfo contains data and methods to connect to FM using
	 *          https.
	 ***/
	class FMInfo{
			public static String fmURL;
			public static void init(){
				fmURL = new String("https://ep.netlab.uky.edu:8443/servlet/FM.FM");	//EP 
			}
	}

  /***
	 * Purpose: ProxyInfo contains data and methods to connect to Proxy using
	 *          http.
	 ***/
	class ProxyInfo{
			//initialized by fmReceiveBriefFileListing() 
			public static String pURL;
			public static void init(String proxyURL){
				pURL = new String(proxyURL);
			}
	}

  /***
	 * Purpose: FileManagerConstants is an interface to define constants
	 *          used by Diskster. This interface is implemented by most
	 *          classes in the system.
	 ***/
 interface FileManagerConstants {

			  public static final int MAX_DESC_LEN = 255; //Max length of encrypted
																		                //FileDescription (byte)

        public static final int MAX_DATA_SIZE = 1024;
        public static final int MSPORT  = 6101; //Manager-Server Port
        public static final int MHPORT  = 6102; //Manager-Handheld Port
        public static final int MDPORT  = 6103; //Manager-Desktop Port
        public static final int FSTHREADS = 10; //Max simultaneous file server clients

        public static final String DEF_ENCODING = "UTF-8";
        public static final String L_SEP = System.getProperty("line.separator");

        /*Protocol messages - sent as following integers*/

        public static final int SETUP     =         1;
        public static final int TEARDOWN  =         2;
        public static final int TERMINATE =         3;
        public static final int SPACEOUT  =         4;
        public static final int NEWFILE   =         5;
        public static final int RMFILE    =         6;
        public static final int OTHER     =         7;

        public static final int SETUP_CONF =        8; //This msg may contain new
                                                       //serverId in DiskInfo packet
        public static final int TEARDOWN_CONF    =          9;
        public static final int TERMINATE_CONF   =         10;
        public static final int SPACEOUT_CONF    =         11;
        public static final int NEWFILE_CONF     =         12;
        public static final int RMFILE_CONF      =         13;
        public static final int OTHER_CONF       =         14;

}


