package HH;

/***
 * Purpose: FileDirectory stores the file listing(file name and fileId) 
 * 					of upto 100 files submitted by the user to Diskster (using
 * 					DT). FileDirectory also stores the BriefFNode of the file
 * 					whose blocks have been requested by the user.
 ***/ 					

import java.io.*;					//for regular i/o

public class FileDirectory implements FileManagerConstants{
	static BriefFNode[] bfnList;	//not used.
	static int nIndex;						//file listing index 
	static BriefFNode currBFN;		//currently requested file
	static String[][] fileListing;//fileName-fileId of 100 files
	
	//Needs instantiation, else constructor wont execute
	public FileDirectory(){

		nIndex = 0;												
		fileListing = new String[100][2];
		currBFN = new BriefFNode();

	}
	
	//This method is used to add file name, fileId pairs to fileListing
	//when the HH is initialized or the user explicitly refreshes state
	//from the FM.
	public static void addFile(String fName, String fId){

		if(nIndex>=99){
			System.out.println("Not storing file name and id.");
			System.out.println("File Listing exceeded 100 files.");
		}
					
		fileListing[nIndex][0] = fName;
		fileListing[nIndex++][1] = fId;

	}
	//Returns fileId corresponding to the file name.
	public static String getFileId(String fName){

		int numFiles = nIndex;
		int fIndex = 0;
		for(fIndex=0; fIndex<numFiles; fIndex++){
			if(fName.compareTo(fileListing[fIndex][0])==0){
				return 	fileListing[fIndex][1];
			}
		}

			//No such file name in FileDirectory
			System.out.println("No such file in FileDirectory: " + fName);
			return null;
	}

}//end of class

/***
 * Purpose: BriefFNode stores information about the file whose blocks
 * 					are requested by the user. The information stored includes
 * 					the block signatures of the file blocks.
 ***/


class BriefFNode implements FileManagerConstants{

	String fileId;
	int fIdLen;
	String fileName;		//For display in GUI
	int sigSize;
	int noBlocks;
	long blockUnit;
	long fileSize;
	byte[][] blockSig;	//Need to allocate memory
	String[] FS = new String[5];	//IP addresses of FSs

	//constructor
	public BriefFNode(){
		//Data members will be initialized in decode()
	}

	/***
	 * Precondition: 	bfNodeArr is the byte encoding of BriefFNode object.
	 * Postcondition: byteDecode() initializes data members of BriefFNode
	 * 								from bfNodeArr. 
	 ***/
	
	public void byteDecode(byte[] bfNodeArr) throws Exception{

	ByteArrayInputStream bais = new ByteArrayInputStream(bfNodeArr);
	DataInputStream badis = new DataInputStream(bais);
	
		int fIdLen = badis.readInt();
		byte[] tempArr = new byte[fIdLen];
		badis.readFully(tempArr);
		fileId = new String(tempArr, DEF_ENCODING);

		int nameArrLen = badis.readInt();
		byte[] nameArr = new byte[nameArrLen];
		badis.readFully(nameArr);
		fileName = new String(nameArr,DEF_ENCODING);

		sigSize = badis.readInt();
		noBlocks = badis.readInt();
		blockUnit = badis.readLong();
		fileSize = badis.readLong();

		//important to allocate memory after reading sigSize
		blockSig = new byte[500][sigSize];	//max 500 sigs per file

		byte[] sig = new byte[sigSize];
		//Read block sigs
		for(int bIndex=0; bIndex<noBlocks; bIndex++){
			badis.readFully(sig);
			System.arraycopy(sig, 0, blockSig[bIndex], 0, sigSize);
		}

		badis.close();
	}

	/***
	 * Precondition: 	HH has sent request for file information of file
	 * 								requested by the user, to FM.
	 * Postcondition:	initializes data members of BriefFNode by reading 
	 * 								the input stream, inS, from FM.
	 ***/
  public void byteDecode(InputStream inS) {

    try{
      DataInputStream dis = new DataInputStream(inS);
      int fsTotLength = dis.readInt();
      byte[] fsListArr = new byte[fsTotLength];
      dis.readFully(fsListArr);
      decodeFSList(fsListArr);  //Reads and initializes IP addresses

      this.sigSize = dis.readInt();
      this.noBlocks = dis.readInt();
      this.blockUnit = dis.readLong();

      //Allocate space to store block sigs
      this.blockSig = new byte[this.noBlocks][this.sigSize];
      int blockIndex = 0;

      for(blockIndex=0; blockIndex < this.noBlocks; blockIndex++){

        byte[] sig = new byte[this.sigSize];
        dis.readFully(sig);
        System.arraycopy(sig, 0, this.blockSig[blockIndex], 0, this.sigSize);

      }


      if(blockIndex != this.noBlocks){
      //Couldn't get sigs of all blocks
      System.out.println( "Couldn't get sigs for all " + this.noBlocks
                          + " blocks");
      }

    }catch(Exception e){
      System.out.println("Unexpected termination of input from FM");
      System.out.println(e.getMessage());
    }

  }

  //Helper method, retrieves IP addresses of FSs from the byte array
	//fsListArr
  private void decodeFSList(byte[] fsListArr) throws Exception{

    ByteArrayInputStream bais = new ByteArrayInputStream(fsListArr);
    DataInputStream badis = new DataInputStream(bais);

    int len;

    //We know that there are 5 FS address Strings
    for(int fsIndex=0; fsIndex < 5; fsIndex++){
      len = badis.readInt();
      byte[] fsArr = new byte[len];
      badis.readFully(fsArr);
      this.FS[fsIndex] = new String(fsArr, DEF_ENCODING);
    }
  }

}//end of BriefFNode class


