package HH;

  /***
	 * Purpose:  This class has methods and data members to code/decode
	 *           File Description information sent between the FM and
	 *           DT, HH, Proxy.
	 ***/

import javax.microedition.lcdui.*;	//Display
import javax.microedition.midlet.*;	
import javax.microedition.io.*;			//For network i/o
import java.io.*;										//For regular i/o

  public class FileDescription implements FileManagerConstants{

	String fileId = null;     
  int fIdLength = 0;       
  String fName = null;
  String ownerId = null;
  int idLength;
  int fNameLength;

	long maxEncFileSize = 0; 	//expected size of the file
														//when it is encrypted.
	long blockUnit = 0; 			//size of the encrypted file block

	//Constructor
	public FileDescription(){
	 //Data members are initialized by byteDecode()
	}

  /***
	 * Precondition:  data is a byte array containing byte encoding of
	 *                FileDescription object.
	 * Postcondition: initializes data members from byte array data.
	 ***/
  public void byteDecode(byte[] data) throws Exception{

  	ByteArrayInputStream is = new ByteArrayInputStream(data);
  	DataInputStream dis = new DataInputStream(is);
  	idLength = dis.readInt();
  	byte buf[] = new byte[idLength];

  	dis.readFully(buf);
  	ownerId = new String(buf, DEF_ENCODING);

  	fNameLength = dis.readInt();

  	byte[] tempArr = new byte[fNameLength];
  	dis.readFully(tempArr);
  	fName = new String(tempArr,DEF_ENCODING);

		fIdLength = dis.readInt();
			
		byte[] tempArr2 = new byte[fIdLength];
		dis.readFully(tempArr2);
		fileId = new String(tempArr2,DEF_ENCODING);

		maxEncFileSize = dis.readLong();
		blockUnit = dis.readLong();

  	dis.close();
  }

	//Helper function: returns data members as strings for debugging.
  public String toString(){

    if(fName == null) return null;

    String dInfo = "\n************************************\n";

    dInfo += 	"\n File Name: " + fName;
    dInfo += 	"\n OwnerId: " + ownerId + "\n maxEncFileSize: " + 
							maxEncFileSize ;

    dInfo += 	"\n*************************************\n";

    return dInfo;

  }

}//end of class



