
package HH;

/***
 * Purpose: Encryptor is used by HH to decrypt file	blocks using the DES
 *          implementation of BouncyCastle cryptography.
 *
 * This class has been modified from the article "Data Encryption for
 * J2ME Profiles" by Eric Giguere posted on the Sun website at
 * http://wireless.java.sun.com/midp/ttips/dataencryp/
 ***/

import org.bouncycastle.crypto.*;
import org.bouncycastle.crypto.engines.*;
import org.bouncycastle.crypto.modes.*;
import org.bouncycastle.crypto.params.*;
import org.bouncycastle.crypto.paddings.*;

public class Encryptor implements FileManagerConstants{

    private BufferedBlockCipher cipher;
    private KeyParameter        key;
    public  int 		blockSize;
		public  int     outputSize;

    // Initialize the cryptographic engine.
    // The key array should be at least 8 bytes long.
    public Encryptor( byte[] key ){
        cipher = new PaddedBufferedBlockCipher(
                    new CBCBlockCipher(

        this.key = new KeyParameter( key );
		blockSize = cipher.getBlockSize();
		outputSize = cipher.getOutputSize(blockSize);
    }
    // Initialize the cryptographic engine.
    // The string should be at least 8 chars long.
    public Encryptor( String key ){
        this( key.getBytes() );
    }

    // Private routine that does the gritty work.
    private byte[] callCipher( byte[] data , int len) throws CryptoException,Exception {
				cipher.reset();
        int    size = cipher.getOutputSize( len );
        byte[] result = new byte[ size ];
        int    olen = -1;
				try{
					olen = cipher.processBytes( data, 0, len, result, 0 );
				}catch(Exception e){
					System.out.println("Could not process bytes - " + e.getMessage());

				}
				
				try{
        olen += cipher.doFinal( result, olen );
				}catch(DataLengthException dex){
				System.out.println("1.doFinal: "+dex.getMessage());
				}catch(InvalidCipherTextException cex){
				System.out.println("2.doFinal: " + cex.getMessage());
				}
			
        if( olen < size ){
            byte[] tmp = new byte[ olen ];
            System.arraycopy(result, 0, tmp, 0, olen );
            result = tmp;
        }

        return result;
    }

    // Encrypt arbitrary byte array, returning the
    // encrypted data in a different byte array.

    public synchronized byte[] encrypt( byte[] data, int len )
                  throws CryptoException,Exception {
        if( data == null || data.length == 0 ){
            return new byte[0];
        }
        cipher.init( true, key );
        return callCipher( data, len );
    }

    // Decrypts arbitrary data.
    public synchronized byte[] decrypt( byte[] data, int len )
                  throws CryptoException,Exception {
        if( data == null || data.length == 0 ){
            return new byte[0];
        }

        cipher.init( false, key );
        return callCipher( data,len );
    }
}


