
package FS;

/***
 * Purpose: A block request from DT or Proxy is sent in the form of a 
 * 					RequestArray packet. FSServer uses RequestArray to decode 
 * 					the block requests. 
 ***/

import java.io.*;
import java.net.*;
import java.util.*;

//The request: fileId + blockIndex + blockSig
class RequestArray implements FileManagerConstants{

	FNode myFNode;

	public String fId;
	public int blockIndex;
	public byte[] bSig;	//the block signature in the request
											//No space allocated yet.

	public RequestArray(FNode fileN){
		myFNode = fileN;
	}

	public RequestArray(){
		//Empty constructor. Data members will be filled in by byteDecode
		bSig = new byte[20];    //sigSize is fixed at 20  bytes
	}
	/***
	 * Used on DT and Proxy, not FS
	 * Precondition: 	data members are initialized.
	 * Postcondition: Encodes block request as fileId + bIndex + blockSig
	 ***/
	public byte[] byteEncode(int bIndex) throws Exception{

		ByteArrayOutputStream buf = new ByteArrayOutputStream();
		DataOutputStream out = new DataOutputStream(buf);

		byte[] idArr = myFNode.fileId.getBytes(DEF_ENCODING);
		out.writeInt(idArr.length);
		out.write(idArr);
		out.writeInt(bIndex);
		byte[] sig = new byte[myFNode.sigSize];
		System.arraycopy(myFNode.blockSig[bIndex], 0, sig, 0, myFNode.sigSize);
		out.write(sig);
		out.flush();
		return buf.toByteArray();

		}
	/***
	 * Precondition: 	data is a byte array containing a byte encoding of 
	 * 								of a RequestArray packet.
	 * Postcondition:	Initializes data members by decoding RequestArray packet.
	 ***/
	public void byteDecode(byte[] data) throws Exception{

		ByteArrayInputStream is = new ByteArrayInputStream(data);
		DataInputStream dis = new DataInputStream(is);

		int fIdLen = dis.readInt();
		byte[] idArr = new byte[fIdLen];
		dis.readFully(idArr);
		fId = new String(idArr, DEF_ENCODING);  //fileId
		blockIndex = dis.readInt();             //Block Index
		dis.readFully(bSig);    //block signature

		dis.close();


	}
}//end of class
