
package FS;

/***
 * Purpose: FileServer is the driver class of package FS and has the
 * 					main() method. This class is also responsible for
 * 					saving and retrieving FS state when the file server is 
 * 					started and shutdown. This class primarily does things,
 * 					starts a FileManagerClient to contact the FM with SETUP
 * 					or SHUTDOWN messages and starts FSServer to accept 
 * 					connections from FM, DT and Proxy.
 ***/

import java.io.*;
import java.net.*;
import java.util.*;

public class FileServer implements FileManagerConstants{
        
    static ServerSocket fsSocket;

    public static void main(String args[])throws Exception{

    		FileManagerClient fmClient  = new FileManagerClient();

        /*Setup: Contact the File Manager*/

        fmClient.fmSend(SETUP); /*Also reads in the IPAddress of FM from file*/
        fmClient.fmReceive();   //Check if receive was successful or for timeout 
        
        /***
				 * Start the FSServer (after setup) in a thread to accept 
				 * connections 	from FM/HH/DT
				 *
				 * Well, actually its now a normal server, not HTTP
				 ***/
					
				System.out.println("Starting FSServer on port: "+FSPORT);

				fsSocket = new ServerSocket(FSPORT);
        FSServer fsServer = new FSServer(fsSocket);
        Thread fsThread = new Thread(fsServer);
        fsThread.start(); // spawns new thread and returns immediately
         

				System.out.println("Type \"shutdown\" for graceful shutdown");

				InputStreamReader isr = new InputStreamReader(System.in);
				StreamTokenizer st = new StreamTokenizer(isr);

				String command = "temp";
				int type;
				while(true){
					System.out.println("Type \"shutdown\" for graceful shutdown");
					type = st.nextToken();	
					if(type == st.TT_WORD) command = new String(st.sval);
					if(command.compareTo("shutdown") == 0) break;
				}

				if(command.compareTo("shutdown") == 0){

					System.out.println("Starting graceful shutdown...");
        	fmClient.fmSend(SHUTDOWN); //Send FM shutdown message.
        	fmClient.fmReceive();   
					DiskInfo.writeFileDirectoryToFile();
					DiskInfo.writeToFile();
					System.out.println("Done");
					System.exit(0);

				}
        
    }
}

/***
 * Purpose: FileServer uses FileManagerClient to contact FM during
 * 					setup and shutdown.
 ***/
class FileManagerClient implements FileManagerConstants{
 
    Socket fmClient;
    int fmPort = MSPORT; // Manager-Server Port
    String fmIPAddress;

    InputStream in;      //initialized by fmConnect()
    OutputStream out;    //initialized by fmConnect()
	
	//constructor
	public FileManagerClient() throws Exception{

		DiskInfo.readSetup();	//DiskInfo will create a setup file if it does 
													//not exist.
		System.out.print(DiskInfo.DIToString()); //Debugging
		fmIPAddress = DiskInfo.fileManagerIP; 
	}    

	/***
	 * Precondition: data members fmIPAddress and fmPort are initialized.
	 * Postcondition: connects to FM.
	 ***/
  void fmConnect()throws Exception{
         
  	InetAddress fmAddr = InetAddress.getByName(fmIPAddress.trim());
  	System.out.println("Attempting to connect to File Manager at " + fmAddr +
                          " on port " + fmPort);
  	fmClient = new Socket(fmAddr,fmPort);
  	in = fmClient.getInputStream();
  	out = fmClient.getOutputStream();

  }

  //closes connection to FM 
  void fmClose()throws Exception{
  	fmClient.close();
  }
	
	//sends setup message to FM 
  void sendSETUP()throws Exception{
   FileManagerProtocol fmp = new FileManagerProtocol((byte)SETUP,DiskInfo.byteEncode());   
   byte[] setupInfo = fmp.byteEncode();
   out.write(setupInfo);
  }

	//sends shutdown message to FM.   
  void sendSHUTDOWN()throws Exception{
   FileManagerProtocol fmp = new FileManagerProtocol((byte)SHUTDOWN,DiskInfo.byteEncode());   
   byte[] setupInfo = fmp.byteEncode();
   out.write(setupInfo);
  }
   
   //Needed for load balancing
  void changeFMIPAddress()throws Exception{
		//Not implemented				
	;}

  public void fmSend(final int msg) throws Exception{
    
      switch(msg){

          case SETUP:{/*Setup message*/
              /*Read in IP address of the FM from file *****
               *Connect to file manager
               *Make the packets to send
               *Send
               **/
               System.out.println("Calling fmConnect()");
               fmConnect();
							 System.out.println("Sending out SETUP message to FM.");
               sendSETUP();
          		 }
							 break;
          case SHUTDOWN:{/*Teardown message*/
               System.out.println("Calling fmConnect()");
               fmConnect();
							 System.out.println("Sending out SHUTDOWN message to FM.");
               sendSHUTDOWN();

							 break;
          		 } 

          default:{
          		 }

      }//end of switch
    
    }//end of fmSend

    /***
		 * Postcondition: Receives response from FM to fmSend() messages 
		 ***/
    public void fmReceive() throws Exception{

    	FileManagerProtocol recvFmp = new FileManagerProtocol();

    	//Decode
    	recvFmp.byteDecode(in);
    
    	//Debugging
    	System.out.println("Received following message from FM:");
    	System.out.println(recvFmp);

    	if(recvFmp.protocol != 1){
				System.out.println("Client connecting on port: "+ MSPORT);
				System.out.println("not following manager-server protocol");
				return;
			}

     	System.out.println("Acting on FM response");
     	switch((int)(recvFmp.msgType)){

	  		case SETUP_CONF:{
											System.out.println("SETUP_CONF received from FM.");
											System.out.println("Calling handleSetupConf()");
											handleSetupConf(recvFmp.data);
											break;
											}
				case SHUTDOWN_CONF:{
											System.out.println("Received SHUTDOWN_CONF from FM.");
											break;										 
											} 
				default:{
        	  		}
      }

    }//end of fmReceive
	
	/***
	 * Precondition: 	FM has sent a setup confirmation message.
	 * Postcondition:	If this is the first time, FS has started,
	 * 								this method saves the serverId sent by FM 
	 * 								in DiskInfo	and on file.
	 ***/
  public void handleSetupConf(byte[] diData) throws Exception{
 
    String mOne = new String("-1".getBytes(DEF_ENCODING), DEF_ENCODING);
    System.out.println("Received SETUP_CONF");
    if((DiskInfo.serverId).equals(mOne)){
       System.out.println("Old ServerId was -1");
       DiskInfo.byteDecode(diData);
       DiskInfo.writeToFile();
    }
    else{
       System.out.println("Old ServerId was not -1");
       DiskInfo.byteDecode(diData);
       DiskInfo.writeToFile();
    }

  } //end of handleSetupConf()

}//end of class




