package FS;
  /***
	 * Purpose: FileManagerConstants is an interface to define constants
	 *          used by Diskster. This interface is implemented by most
	 *          classes in the system.
	 ***/

public interface FileManagerConstants{
 
    public static final int MAX_DATA_SIZE = 1024;
    public static final int MSPORT  = 6101; //Manager-Server Port   
    public static final int HTTPPORT = 8101; //File server's HTTP server port
    public static final int FSPORT = 8102; //File server's server port
    
    public static final String DEF_ENCODING = "UTF-8";  
    public static final String L_SEP = System.getProperty("line.separator");
    
    /*Protocol message types - sent as integers*/
    public static final int SETUP     =         1;
    public static final int SHUTDOWN  =         2;
    public static final int TERMINATE =         3;
    public static final int SPACEOUT  =         4;
    public static final int NEWFILE   =         5;
    public static final int RMFILE    =         6;
    public static final int OTHER     =         7;

		//This msg may contain new serverId in DiskInfo packet
		public static final int SETUP_CONF =        8; 

    public static final int SHUTDOWN_CONF   =          9;
    public static final int TERMINATE_CONF  =         10; 
    public static final int SPACEOUT_CONF   =         11;
    public static final int NEWFILE_CONF    =         12;
    public static final int RMFILE_CONF     =         13;
    public static final int OTHER_CONF      =         14;

		//new file from FM to FS
		public static final int NEW_FILE        =         15;
		//old file from FM to FS
		public static final int OLD_FILE        =         16;
		//blockReq msgType in FileManagerProtocol
		public static final int BLOCK_REQ				=					17;

}

