package FS;

/***
 * Purpose: FileDirectory contains the TreeMap of all FNode
 *          objects of a particular user. FileDirectory itself
 *          is stored as a data member of OwnerNode.
 ***/

import java.util.*;
import java.io.*;
import java.net.*;
import java.security.*;

public class FileDirectory{
	
	//static FileDirectory TreeMap
	public static TreeMap fileTree;
	
	public FileDirectory(){
		fileTree = new TreeMap();
	}

	public static boolean addNode(FNode fNode){
		if(fileTree.containsKey(fNode.fileId)) return false;
		fileTree.put(fNode.fileId, fNode);
		return true; 
	}

	public static boolean removeNode(String fId){
		fileTree.remove(fId);
		return true;
	}

  /***
	 *  Precondition:   Called when the fNode is already present in
	 *                  the FileDirectory. Called when a file has
	 *                  been modified by its owner.
	 *  Postcondition:  Replaces an FNode object in the FileDirectory.
	 ***/
public static boolean updateNode(FNode ufNode){
	//redundant based on our precondition
	if(!fileTree.containsKey(ufNode.fileId)) return false;
	fileTree.put(ufNode.fileId, ufNode);
	return true;
	}
	
/***
 * Postcondition: Returns true if fileId is already present,
 *                false otherwise
 ***/
public static boolean contains(String fileId){

	return fileTree.containsKey(fileId);

}

//Retrieves FNode object with fileId from the FileDirectory.
public static FNode getNode(String fileId){
	return (FNode)fileTree.get(fileId);
}

}//end of class







