package FS;

/***
 * Purpose: The FNode object stores information about a file.
 *          The FNode object is stored in the FileDirectory
 *          tree.
 ***/

import java.util.*;
import java.io.*;
import java.net.*;
import java.security.*;

public class FNode implements Serializable{

	public String fileId = null;				// will also be used as the key 
																			// of the (key, FNode) pair of 
																			// FileDirectory TreeMap
	int fIdLength = 0;

	String localFName;
	
	public long fileSize;								// Max Size of file in bytes
	public long blockUnit;    	        // size of one block
	
	//entry 0 corresponds to the signature of block 0 and so on.
	byte[][] blockSig;									//Need to allocate memory

	int sigSize = 20;										//size of signature 
	public int noBlocks;                //Number of encrypted blocks in the file

 	// If more blocks are needed, point to another FNode.
	// Just a provision for future implementation
	FNode nextNode = null; 							//Initialised only if more than 500 
																			//blocks are required for the file  						
//constructor - most data members will be set explicitly
public FNode() {
	blockSig = new byte[500][sigSize]; 	//max 500 file blocks
	noBlocks = 0;												//no file blocks yet
}

//Helper function, for debugging
public String toString(){
	String fNodeInfo;
	fNodeInfo = " File Id: " + fileId; 
	return fNodeInfo;
}

}// end of class


