
package FS;

/***
 * Purpose: This class is used by the FM and FSs to store/transmit setup 
 * 					information about a File Server.
 ***/

import java.net.*;
import java.io.*;
import java.util.*;
import java.security.*;
import java.security.spec.*;

class DiskInfo implements FileManagerConstants{

    static int idLength = 0;    
    static String serverId;     //this variable should have DEF_ENCODING
    static long totSpace = 0;
    static long spaceLeft = 0;
    static String myIP;
    static String fileManagerIP;// IP address 
		
		//files to store state information
    static File setupFile = new File("server_setup.properties"); 
    static File FDFile = new File("file_dir.properties"); 

		//For public key decryption
		static PublicKey pubKey;						//FM's public key
		
		//last FM Msg time stamp - to avoid replay
		static long prevFMTimeStamp=0;

   	//Constructor - Data members are initialized by readSetup() or byteDecode()
    public DiskInfo(){

    }
		
		/***
		 * Precondition: FM has added/deleted/modified a file on FS.
		 * Postcondition: updates amount of space left out of original
		 * 								out of original amount committed by the user
		 ***/
		
		public synchronized static void reduceSpaceLeft(long siz){
			long temp = spaceLeft;
			spaceLeft -= siz;
		}

		/***
		 * Precondition: FM has added/deleted/modified a file on FS.
		 * Postcondition: updates amount of space left out of original
		 * 								out of original amount committed by the user
		 ***/

		public synchronized static void increaseSpaceLeft(long siz){
						
			long temp = spaceLeft;
			spaceLeft += siz;
		}

		/***
		*	Precondition: FS setup file does not exist.
		*
 		*	Postcondition: 	Creates a setup file for FS interactively with the
		*									person offering space to Diskster. 
		***/
    static boolean createSetup() throws Exception{
                FileOutputStream fOut = new FileOutputStream(setupFile);
                DataOutputStream dOut = new DataOutputStream(fOut);

                //Actually store encoded bytes in file
                byte[] encodedByteId = "-1".getBytes(DEF_ENCODING);
                idLength = encodedByteId.length;

                dOut.writeByte(idLength);

                dOut.write(encodedByteId);

                System.out.print( "Please enter the amount of disk space(in bytes) "
																	+ "you intend to offer: ");

                //Read from keyboard
                InputStreamReader isr = new InputStreamReader(System.in);
                StreamTokenizer st = new StreamTokenizer(isr);
                long c = st.nextToken();
                while(c != StreamTokenizer.TT_NUMBER){
                        System.out.print(	"Please enter the amount of disk space " 
																					+ "(in bytes) you intend to offer: ");
                        c = st.nextToken();
                }

								//total space offered by FS
                dOut.writeLong((long)(st.nval));

								//space left out of total space
                dOut.writeLong((long)(st.nval));

								fileManagerIP = "206.240.24.73";         		//SELAB - EP
								
								//fixed length, add trailing blanks
               	while(fileManagerIP.length() < 15)
                 	fileManagerIP += " ";

               	dOut.writeBytes(fileManagerIP);

								prevFMTimeStamp = 0;												//FM timeStamp 
																														//starts out 0
								dOut.writeLong(prevFMTimeStamp);

                dOut.flush();
                dOut.close();
								fOut.close();
                return true;

        }

		/***
     * Postcondition: Reads FS setup file if it exists. If setup file for FS
		 * 								does not exist, this method calls createSetup() to create i
		 * 								the setup file interactively with the user.
		 * 								If file file_dir.properties exists, initializes FileDirectory
		 * 								from saved state in file_dir.properties. 
		 * 								If file_dir.properties does not exist instantiates empty 
		 * 								FileDirectory.
		 ***/
		
    public static void readSetup() throws Exception{

				boolean fDirInstantiated = false;
						
            if(!setupFile.exists()){
            	System.out.println(	"Setup file does not exist.\n " 
																	+ "Interactively creating new setup file");
							System.out.println("Server Id will be issued by FM in the SETUP_CONF "
																	+ "message");
							//create setup file
              if(!createSetup()){
              	System.out.println(" ERROR: Unable to create setup file");
                System.exit(1);
               }

							//Since setup does not exist, create empty FileDirectory.
							System.out.println("Instantiating empty FileDirectory.");
							FileDirectory fd = new FileDirectory();	
							fDirInstantiated = true;
             }

        try {

				FileInputStream fIn = new FileInputStream(setupFile);
				DataInputStream ois = new DataInputStream(fIn);

        System.out.println();
        System.out.println("Reading from setup File:");

        idLength = ois.read();

				//serverId        
        byte[] buf = new byte[idLength];
        ois.readFully(buf);
        serverId = new String(buf,DEF_ENCODING); 
        
        //totSpace
				totSpace = ois.readLong();

				//spaceLeft
				spaceLeft = ois.readLong();
 
     		//myIP
        try{
            InetAddress myAddr = InetAddress.getLocalHost();
            myIP = myAddr.getHostAddress();
            while(myIP.length() < 15) 
							myIP += " ";
        } catch(Exception E){ }

				//fileManagerIP
        byte[] buf2 = new byte[15];
        ois.readFully(buf2);
        fileManagerIP = new String(buf2); 
		
				prevFMTimeStamp = ois.readLong();

				System.out.println(	"Read following prevFMTimeStamp from file: " 
														+ prevFMTimeStamp);
				
				if(!fDirInstantiated){
					
					System.out.println("Going to read FILEDIRECTORY from file: "
															+ FDFile);
					try{
						FileInputStream ffis = new FileInputStream(FDFile);
						ObjectInputStream fois = new ObjectInputStream(ffis);

			  		FileDirectory fd = new FileDirectory();

						fd.fileTree = (TreeMap)fois.readObject();

						fois.close();
					}catch (Exception ee){
						System.out.println("readSetup: Could not read " + FDFile);
						System.out.println(ee.getMessage());
					}
					
				}
        ois.close();
        } catch(Exception E){
					System.out.println("readSetup Exception: " + E.getMessage());
				}
    }

    /***
		 * Postcondition: Writes the FS setup file to disk.
		 ***/
    public static void writeToFile() throws Exception{
   
        FileOutputStream fOut = new FileOutputStream(setupFile);
        DataOutputStream dOut = new DataOutputStream(fOut);

				System.out.println("Writing following DiskInfo to setup file.");

        System.out.println(DiskInfo.DIToString());

				dOut.write(idLength);
				byte[] buf = serverId.getBytes(DEF_ENCODING);
				dOut.write(buf);

        dOut.writeLong(totSpace);
        dOut.writeLong(spaceLeft);
//      dOut.writeBytes("fileManagerIP=128.163.146.112"); //Zonker Should come from the download website
        dOut.writeBytes(fileManagerIP); //Zonker Should come from the download website
				System.out.println(	"Writing following prevFMTimeStamp to file: "
														+ prevFMTimeStamp);
        dOut.writeLong(prevFMTimeStamp); 

        dOut.flush();
        dOut.close();

    }

		/***
		*	Purpose: When the File Server is shut down, this function saves
		*	the FileDirectory (FNodes of all the files) to disk.
		*	
		*	Precondition: file server_setup.properties exists.
		*	Postcondition: FileDirectory is serialized and saved to disk
		***/
		public static boolean writeFileDirectoryToFile(){
						
				System.out.println("Going to write FileDirectory to setup file");

				if(!setupFile.exists()){
					System.out.println("WARNING: setup file does not exist."); 
				}

				try{
        	FileOutputStream fOut = new FileOutputStream(FDFile);
        	ObjectOutputStream dOut = new ObjectOutputStream(fOut);
					dOut.writeObject(FileDirectory.fileTree);
					dOut.flush();
					dOut.close();
					fOut.close();
					System.out.println("Finished writing FileDirectory to file: "
														+	FDFile);
				}catch(Exception ee){
					System.out.println("Could not write FileDirectory to setup file.");
					System.out.println(ee.getMessage());
					return false;

				}
					return true;
		}

    /***
		 * Precondition:  Data members are initialized.
		 * Postcondition: Encodes data members as a byte array fit to be
		 *                transmitted over the network.
		 ***/
    static byte[] byteEncode() throws Exception{

        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf);

        System.out.println("Encoding DiskInfo data as Byte Array");

        out.writeByte(idLength);

				byte[] encBuf = serverId.getBytes(DEF_ENCODING);
				out.write(encBuf);

        out.writeLong(totSpace);
        out.writeLong(spaceLeft);

				out.writeBytes(myIP); 		//15 Chars

        out.writeBytes(fileManagerIP); 	//15 Chars

        out.flush();
        return buf.toByteArray();
    }

    /***
		 * Precondition:  data is a byte-array encoding of a DiskInfo object
		 * Postcondition: DiskInfo data members are initialized with the contents of
		 *                data. Also reads FM's X.509 encoded public key array and 
		 *                generates FM's public key.
		 ***/
    static void byteDecode(byte[] data) throws Exception{

        ByteArrayInputStream is = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(is);

        System.out.println("Decoding byte array data for DiskInfo: ");

        idLength = dis.read();		

 				System.out.println("serverId Length: " + idLength);

				byte buf[] = new byte[idLength];
				dis.readFully(buf);
				serverId = new String(buf,DEF_ENCODING);

        totSpace = dis.readLong();
        spaceLeft = dis.readLong();

        byte tempIP[] = new byte[15]; 	// IP address string is 15 bytes long
        dis.readFully(tempIP);
        myIP = new String(tempIP);     

        dis.readFully(tempIP);
        fileManagerIP = new String(tempIP);

				int keyLen = dis.readInt();
				byte[] keyArr = new byte[keyLen];
				System.out.println(	"Going to read " + keyLen 
														+ " bytes of FM's public key array.");
				dis.readFully(keyArr);
				System.out.println("Done.");	

				System.out.println("Generating FM's public key from X509 encoded key array.");
				X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(keyArr);
				KeyFactory KeyFac = KeyFactory.getInstance("DSA", "SUN");

				pubKey = KeyFac.generatePublic(pubKeySpec);

				System.out.println("Done.");

        dis.close();

    }//end of byteDecode()

    /***
		 * Purpose: Helper function to print data members.
		 ***/
    public static String DIToString(){

        String dInfo = L_SEP + "*******************************************************";
        dInfo += L_SEP + "Disk Info: " + L_SEP;
        dInfo += "idLength: " + idLength + L_SEP;
        dInfo += "serverId: " + serverId + L_SEP;
        dInfo += "totSpace: " + totSpace + " spaceLeft: " + spaceLeft + L_SEP;
        dInfo += "File Server IP: " + myIP + " File Manager IP: " + fileManagerIP + L_SEP;
        dInfo += "*******************************************************" + L_SEP;
        return dInfo;
    }

}//end of DiskInfo class

