/***
 * Purpose: Five RetrieveFS objects are instantiated by the downloadAndSend()
 * 					method of OwnerProtocol for file request. 
 * 					Each RetrieveFS object retrieves blocks in its series(say, 0,5,10...)
 * 					Each RetrieveFS object tries to keep a stock of 5 blocks ready for 
 * 					consumption
 *
 * 					This class is used on the DT and Proxy, not the FM
 ***/

package FM;

import java.io.*;
import java.util.*;
import java.net.*;

public class RetrieveFS extends Thread implements FileManagerConstants{

FNode fn;
int mySeries;		//would be 0,1,2,3 or 4				
								//Also helps in deciding which FS to try first

Socket fsClient;
byte[][] blocks;
boolean[] empty;	//Array parallel to blocks[] - empty implies block 
									//that the block has been consumed

int toRead;				//index of block that must be consumed next
int lastBlockPut; //index of the last block produced

//milliseconds to block on read, before the connection is broken
final int TIMEOUT = 1000;

boolean flagAllOut;	//Flag to indicate the retrieval is finished


	RetrieveFS(String threadName, ThreadGroup tg, FNode fn, int seriesNum){
		super(tg, threadName);
		this.fn = fn;
		mySeries = seriesNum; 
		//At any point, can store max 5 blocks
		blocks = new byte[5][(int)fn.blockUnit];
		//Gross error - did not allocate memory for empty...
		empty = new boolean[5];
		for(int i=0; i<5; i++)
						empty[i] = true;
		
		toRead = 0;
		lastBlockPut = -1;
		flagAllOut=false;	//not yet all-out
		
		this.start();		//Start the thread
	}



public void run(){
//Retrieve and store 5 blocks in your series.
//Replace blocks as they are consumed.
//Close the connection when you have read all the blocks
//in your series.
//If you cannot get the blocks from your FS, try the next FS 
//and so on

//Need a synchronized putBlock? Yes

//keep calling putBlock() :-)
		
	//Attempt to connect to the FS according to mySeries
	int FSIndex = mySeries; //Try to connect to mySeries FS first

	Socket fsClient;
	OutputStream os ;
	InputStream is;
	
	while(true){
		try{

			fsClient = new Socket(fn.FS[FSIndex], FSPORT);
			os = fsClient.getOutputStream();
			is = fsClient.getInputStream();
			//The maximum time-limit to block on a read
			fsClient.setSoTimeout(TIMEOUT);
			System.out.println("RetrieveFS-Opened input stream from FS: " + fn.FS[FSIndex]);
			break;					//jump out if you get a connection

		}catch(IOException e){
			//try the next FS
			FSIndex = (FSIndex+1)%5;
			if(FSIndex == mySeries){
				//implies, unsuccessfully tried all 5 FSs
				return;				//break out of the function
			}
		}
	}


	DataOutputStream dos = new DataOutputStream(os);
	DataInputStream dis = new DataInputStream(is);

	byte[] blockBytes = new byte[(int)fn.blockUnit];

	//fileId + blockIndex + blockSig
	RequestArray reqArray = new RequestArray(fn);	

	int blockIndex;

	//Request a new block from mySeries each time
	for(blockIndex=mySeries; blockIndex<=fn.noBlocks; blockIndex+=5)	
	{	
		try{
		byte[] req = reqArray.byteEncode(blockIndex);
		FileManagerProtocol fmProto = new FileManagerProtocol((byte)BLOCK_REQ, req);
		byte[] encFMProto = fmProto.byteEncode();
		
		//write this to output stream
		dos.write(encFMProto);
		}catch(Exception e){ }
		
		//read a block from the input stream and putBlock()
		//Also compute sig of retrieved block and compare 
		//with recorded value
		int bytesRead = 0;
		try{//blocking call
			System.out.println("Attempting to read " + (int)fn.blockUnit + " bytes from FS");
			//What if you cannot get all the bytes in one read
			//LATER...
			bytesRead = dis.read(blockBytes);

			System.out.println("Read " + bytesRead + " bytes");

			//compute sig of retrieved block and compare 
			//LATER...
			
			this.putBlock(blockBytes, false/*not the end*/);	

		}catch(Exception e){
			System.out.println("Did not receive expected block from FS");
			try{//try to close streams
				dis.close();
				dos.close();
			}catch(Exception ee){
			}
			break; 	//Assume this FS is of no further use for this transaction

		}
	}	
	
	//Check if we have reached the greatest possible blockIndex for 
	//this file
	if((blockIndex + 5)<= fn.noBlocks){
		System.out.println("Did not retrieve all blocks in my series.");
		System.out.println("Trying to resume with another FS...");
		//Do something...
	}
	else{
		//Successfully retrieved all blocks in my series. Terminate.
		//One more putBlock with 'end=true'
		try{
		this.putBlock(blockBytes, true/*the end*/);
		dis.close();
		dos.close();
		}catch(Exception e){}
	}
				
} //end of run()

	public synchronized void putBlock(byte[] inBlock, boolean end){
	
		while(empty[((lastBlockPut+1)%5)] == false){
			try {
				wait();
			} catch (InterruptedException e){}
		}
		lastBlockPut = (lastBlockPut+1)%5;
		empty[lastBlockPut]=false; 			//now available

		if(end){
			//Termination condition
//			flagAllOut=true;
			blocks[lastBlockPut] = null;
			notifyAll();
			return;
		}

		System.arraycopy(inBlock, 0, blocks[lastBlockPut], 0, inBlock.length);
		notifyAll();


	}



//Return the toRead block and increment (with mod) toRead
//update empty[]
public synchronized byte[] getBlock(){

	while(empty[toRead] == true){
		try {
			wait();
		} catch (InterruptedException e){}
	}	
	
	//My terminating condition
	if(blocks[toRead]==null){
		notifyAll();
		System.out.println("GET: returning null");
		return null;
	}	

		empty[toRead] = true;					//block consumed
		int oldRead = toRead;
		toRead = (toRead+1)%5;				//the next toRead
		notifyAll();
		return blocks[oldRead];

	}

}//End of class

//The request - fileId + blockIndex + blockSig
class RequestArray implements FileManagerConstants{
				
	FNode myFNode;

	String fId;
	int blockIndex;
	byte[] bSig;		//the block signature in the request
									//No space allocated yet.

	public RequestArray(FNode fileN){
		myFNode = fileN;
	}

	public RequestArray(){
		//Empty constructor. Data members will be filled in by byteDecode
		bSig = new byte[20];		//sigSize is fixed at 20 bytes
	}

	public byte[] byteEncode(int bIndex) throws Exception{

		ByteArrayOutputStream buf = new ByteArrayOutputStream();
		DataOutputStream out = new DataOutputStream(buf);

		byte[] idArr = myFNode.fileId.getBytes(DEF_ENCODING);
		out.writeInt(idArr.length);
		out.write(idArr);
		out.writeInt(bIndex);
		byte[] sig = new byte[myFNode.sigSize];
//		System.arraycopy(myFNode.blockSig[bIndex], 0, sig, 0, myFNode.sigSize);
		System.out.println("***Corrected index of block sig on RetrieveFS ***");
		System.arraycopy(myFNode.blockSig[bIndex-1], 0, sig, 0, myFNode.sigSize);
		out.write(sig);
		out.flush();
		return buf.toByteArray();

	}

	public void byteDecode(byte[] data) throws Exception{

  	ByteArrayInputStream is = new ByteArrayInputStream(data);
	  DataInputStream dis = new DataInputStream(is);

		System.out.println("Decoding byte array data for RequestArray: ");

		int fIdLen = dis.readInt();
		byte[] idArr = new byte[fIdLen];
		dis.readFully(idArr);
		fId = new String(idArr, DEF_ENCODING); 	//fileId
		blockIndex = dis.readInt();							//Block Index


		dis.readFully(bSig);		//block signature

		dis.close();

	}


}


