package FM;

/***
 * Purpose: Each OwnerNode object contains information about a user importing
 * 					space from Diskster. All the OwnerNode objects are stored in the
 * 					OwnerDirectory TreeMap.
 ***/

import java.util.*;
import java.io.*;
import java.net.*;
import java.security.*;

public class OwnerNode implements FileManagerConstants, Serializable{

	public String ownerId;		
	public long totSpace; 		//Total space requested
	public long spaceLeft;		//Unused space - reduced 
														//updated everytime a new file is 
														//submitted or deleted.
	String password;					
														
	public String DESKey;			//Encryption Key
														//Not used on FM 

	public FileDirectory fDir; 	//tree of files owned by user


	public long lastAccessed;		//timeStamp when last accessed
	public long pwTimeStamp=0;	//timeStamp in last successful 
															//authentication

	/***
	 * Precondition: 	This constructor is used by the FM class to create
	 * 								an OwnerNode for new users registered through the 
	 * 								Diskster webpage.
	 ***/
	
	public OwnerNode(String ownerId, String pw, long spaceReq){

		this.ownerId = ownerId; 
		this.password = pw;
		this.totSpace = spaceReq;
		this.spaceLeft = this.totSpace;
		fDir = new FileDirectory(); //empty to start with
																//add/remove FNodes as files
																//are submitted or deleted
		this.lastAccessed = System.currentTimeMillis();
					
	}

	//updates time of most recent access 
	public synchronized void updateTimeStamp(long ts){

		lastAccessed = ts;

	}

}//end of class

