package FM;


/***
 * Purpose: FileManagerProtocol contains data members and methods
 * 					to code/decode messages between FM and FS, between 
 * 					DT and FS, and between Proxy and FS.
 ***/

import java.io.*;
import java.net.*;
import java.util.*;

public class FileManagerProtocol implements FileManagerConstants{

    public byte protocol;      
    public byte msgType;       
    public int dataLength;     
    public byte[] data = null;  

    //Constructor
    public FileManagerProtocol(byte msgType, byte[] data) throws Exception{

		System.out.println("Constructing new FileManagerProtocol packet with msgType: " + msgType);
        
        this.protocol = 1;
        this.msgType = msgType;

				//kill this test 
        if(false && (data.length > MAX_DATA_SIZE)){ 
            this.dataLength = MAX_DATA_SIZE;
            throw new IOException("Data more than MAX_DATA_SIZE: ");
        }
        else this.dataLength = data.length;
        //Allocate space for the data buffer
        this.data = new byte[data.length];
        System.arraycopy(data,0,this.data,0,this.dataLength);
    }


		    /***
				 * Precondition: data members are initialized.
				 * Postcondition: returns the data members, encoded as a byte array.
				 ***/
		
    public byte[] byteEncode() throws Exception{
        
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf); 

        out.writeByte(protocol);
        out.writeByte(msgType);
        out.writeInt(dataLength);
        out.write(data);
        
        out.flush();

        return buf.toByteArray();
       
    }
 
    //Constructor
    public FileManagerProtocol() throws Exception{;
    	//Does nothing. The data members will be initialized by byteDecode
    }
    
    /***
		 *Precondition:   The data members of the class are not initialized
		 *Postcondition:  The data members of the protocol packet are 
		 *								initialized using data from the input stream is.
		 ***/
		
	public boolean byteDecode(InputStream is)throws Exception{

		DataInputStream dis = new DataInputStream(is);

		try{
			protocol = (byte)dis.readByte();
			msgType = (byte)dis.readByte();
			dataLength = dis.readInt();

		}catch(Exception e){
			System.out.println("Input stream does not conform to FMP...");
			return false;
		}
		//Allocate space for data buffer
		data = new byte[dataLength];

		try{
			dis.readFully(data); //Returns error on premature EOStream
		}catch(Exception e){
			System.out.println(	"Could not read expected data bytes in " +
													"FileManagerProtocol.");
			return false;
		}
		return true; 	//All well
	}

	//Helper function, returns data members as strings.
	public String toString(){

		String value = 	L_SEP + " Protocol: "+ protocol  + " msgType: " 
										+ msgType + " dataLength: " + dataLength + L_SEP;
		return value;
	}
	
}// End of Class  
 



