package FM;

import java.net.*;
import java.io.*;
import java.util.*;
import java.lang.*; //for Math class

	/***
	*	Purpose: 	This class has methods and data members to code/decode 
	*						File Description information sent between the FM and 
	*						DT, HH, Proxy.
	***/

  public class FileDescription implements FileManagerConstants{

	String fileId = null;     //generated by constructor of FNode
  int fIdLength = 0;       

  String fName = null;
  String ownerId = null;
  int idLength;
  int fNameLength;

	long maxEncFileSize = 0; 	//max expected size of the file
														//when it is encrypted.
	long blockUnit = 0; 			//our size of the encrypted file block which 
														//depends on the encryption mechanism

	//construct all data members from FNode
	public FileDescription(FNode fn){

		System.out.println("***In constructor of FileDescription***");
		fileId = fn.fileId;
		fIdLength = fn.fIdLength;
		fName = fn.fileName;
		System.out.println("File Name: " + fName);
		ownerId = fn.ownerId;
		System.out.println("fn.ownerId: " + fn.ownerId);
		idLength = fn.idLength;
		fNameLength = this.fName.length();
		maxEncFileSize = fn.fileSize;
		blockUnit = fn.blockUnit;

	}


  public FileDescription(String fName){
		this.fName = fName;
  }

	public FileDescription(){
	 //Data members are initialized by byteDecode()
	}

	public void putId(FNode fN){
		this.fileId = fN.fileId;
		this.fIdLength = fN.idLength;
	}

	public void putEncFileSize(int inSize, int outSize){
		
		File file = new File(fName); //assuming fName initialized
		this.blockUnit = outSize;

		long totBytes = file.length();
		System.out.println("Length of the file: " + totBytes + " bytes");
		//Dont ask how I conjured up this formula ;-)
		maxEncFileSize = (long)(Math.ceil((totBytes/(float)inSize))*outSize);
		
		System.out.println("DEBUGGING messages for file size calculation:\n\n");
		System.out.println(	"File Name: " + fName + "\n" +
												"Original File Lenght: " + totBytes + " bytes" +"\n" +
												"inBlockSize: " + inSize +"\n" +
												"outputSize: " + outSize +"\n" +
												"Calculated size of encrypted file: " + maxEncFileSize);

	}

	/***
	 * Precondition: class data members are initialized.
	 * Postcondition: returns a byte array of class data members.
	 ***/

  public byte[] byteEncode() throws Exception{

    /*Encode the ownerId,fileName and their lengths*/

    byte[] fileNameArr = fName.getBytes(DEF_ENCODING);
    int fNameLength = fileNameArr.length;
    System.out.println("fName: " + fName);
    System.out.println("Len: "+ fNameLength);

    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(buf);

		out.writeInt(idLength);
		System.out.println("FD: idLength: " + idLength);
		out.write(ownerId.getBytes(DEF_ENCODING));
    out.writeInt(fNameLength);

    out.write(fileNameArr);

		out.writeInt(fIdLength);
		out.write(fileId.getBytes(DEF_ENCODING));

		out.writeLong(maxEncFileSize);
		out.writeLong(blockUnit);

    out.flush();
    return buf.toByteArray();

  }

	/***
	 * Precondition: 	data is a byte array containing byte encoding of 
	 * 								FileDescription object.
	 * Postcondition: initializes data members from byte array data.
	 ***/

  public void byteDecode(byte[] data) throws Exception{

  ByteArrayInputStream is = new ByteArrayInputStream(data);
  DataInputStream dis = new DataInputStream(is);

  System.out.println("Decoding byte array data for FileDescription: ");
  idLength = dis.readInt();
  byte buf[] = new byte[idLength];
	System.out.println("ownerId Length: " + idLength);

  dis.readFully(buf);
  ownerId = new String(buf, DEF_ENCODING);
	System.out.println("***ownerId: " + ownerId);

  fNameLength = dis.readInt();

  byte[] tempArr = new byte[fNameLength];
  dis.readFully(tempArr);
  fName = new String(tempArr,DEF_ENCODING);
	
	fIdLength = dis.readInt();
	System.out.println("***fIdLength: " + fIdLength);
	byte[] tempArr2 = new byte[fIdLength];
	dis.readFully(tempArr2);
	fileId = new String(tempArr2,DEF_ENCODING);
	System.out.println("***fileId: " + fileId);

	maxEncFileSize = dis.readLong();
	System.out.println("***maxEncFileSize: " + maxEncFileSize);
	blockUnit = dis.readLong();
	System.out.println("***blockUnit: " + blockUnit);

  dis.close();
  }

	//Helper function: returns data members as strings for debugging.
  public String toString(){

    if(fName == null) return null;


    String dInfo = L_SEP + "*******************************************************";

    dInfo += L_SEP + "File Name: " + fName;
    dInfo += L_SEP + "OwnerId: " + ownerId + L_SEP + "maxEncFileSize: " + maxEncFileSize + L_SEP;

    dInfo += "*******************************************************" + L_SEP;

    return dInfo;

  }

}//end of class



