
package FM;

/****
 * Purpose: When the FM wants to read (and store) a block submitted 
 * by the Owner it stores it in the FileBlock object, while about 5 
 * FSs wait to grab the block as soon as it gets stored
 ****/

import java.io.*;
import java.net.*;
import java.util.*;

public class FileBlock { 

	private byte[] block;
	private int totBytes;	//bytes in block, may be less than blockUnit
	private boolean AllAvailable = false;
	private int FSCount = 0; 	//num of FS that have consumed this block
														//we dont want to produce another block 
														//until this block has been consumed by 
														//5 FSs
 	private int blockIndex;

	private boolean[] available; 	//block available for FS0, FS1 ... 
	
	public FileBlock(int blockUnit){
		
		//allocate space for the block in the constructor
		block = new byte[blockUnit];
		available = new boolean[5];
		for(int index = 0; index < 5; index++)
						available[index] = false;
		totBytes = 0;

	}

/***
 * Precondition: If a block is available here it implies that 
 * it is meant to be transmitted to the FS i.e. either it is part 
 * of a new file or its signature has changed. This method is
 * called by the FSConsumer object which transmits the block to 
 * one FS.
 * Postcondition: Returns a block+block index byte array
 ***/

public synchronized byte[] get(int FSNum){
		while (available[FSNum] == false){ //new block has not been produced
						try {
										wait();
						} catch (InterruptedException e){}
		}
		//So as each FS that consumes this block, we increment FSCount
		FSCount++;
		available[FSNum] = false;

    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(buf);
		try{
		out.writeInt(blockIndex);
		out.write(block,0, totBytes);
		out.flush();
		}catch(Exception e){
			System.out.println("Exception in get() of FileBlock"); 
		}
		
		byte[] rBlock;

		if(blockIndex == -1) {

			rBlock = null; 	//Now consumer should understand that
											//there are no more blocks
		}else{
			rBlock = buf.toByteArray(); //block + block index
		}
		
		if (FSCount >= 5)
						AllAvailable = false; //so new block can be produced
		notifyAll();
		return rBlock;
										
	}

/***
 * Precondition: This method is called by an OwnerProtocol object when
 * DT has submitted a block to the FM. Five FSConsumer objects in five
 * threads will consume this block using the get() method.
 * Postcondition: Stores inBlock as a data member block.
 ***/

	public synchronized void put(byte[] inBlock, int bIndex, int totBytes){
		while (AllAvailable == true){ //previous block has not been taken by FSs
						try {
										wait();
						} catch (InterruptedException e){}
		}
		this.totBytes = totBytes;
		System.arraycopy(inBlock, 0, this.block, 0, this.totBytes);					
		blockIndex = bIndex;
		FSCount = 0; 	//None of the 5 FSs have consumed the block yet
		AllAvailable = true;
		for(int index=0;index<5; index++) available[index]=true;
		notifyAll();

	}
} //end of class
