package FM;

/***
 * Purpose: The FM_Owner class is the driver class that uses the 
 * 					OwnerProtocol class for interaction with HH, DT and Proxy.
 ***/


import javax.servlet.*;
import javax.servlet.http.*;

import java.io.*;
import java.net.*;

//Handles interaction between FM and Owner (DT or HH)

public class FM_Owner{
	
	OwnerProtocol ownerProtocol;

	boolean validated;	//whether Owner is authenticated

	//constructor
	public FM_Owner(ServletInputStream sis, ServletOutputStream sos)
	throws Exception{
		
		validated = false;	//Owner is not yet validated

		//Create instance of OwnerProtocol to decode & decrypt
		System.out.println("FM_Owner: Instantiating OwnerProtocol");
		ownerProtocol = new OwnerProtocol(sis,sos);

		//Decodes/Decrypts most of the input stream but does not
		//actually read the file
		System.out.println("FM_Owner: Calling ownerProtocol.byteDecode()");
		ownerProtocol.byteDecode();

		System.out.println("FM_Owner: Calling ownerProtocol.authenticateOwner()");
		validated = ownerProtocol.authenticateOwner(); 

		if(validated){
			
			System.out.println("FM_Owner: Owner validated");
			System.out.println("FM_Owner: Calling ownerProtocol.actOnMsg()");
			if(!ownerProtocol.actOnMsg()) sendInvalid(sos);				
		}

		else {
			System.out.println("Couldn't authenticate the Owner");
			sendInvalid(sos);
		}

	}

	public void sendInvalid(ServletOutputStream sos){
		System.out.println("Sending Invalid Authentication message");
		try{
			DataOutputStream dos = new DataOutputStream(sos);
			byte res = 0;
			dos.writeByte(res);
			dos.close();
		}catch(Exception w){
			System.out.println("sendInvalid Exception-"+w.getMessage());
		}
	}	

}//end of class


