
package FM;

/***
 * Purpose: This file contains three classes, FM_FS, MSProtocol and 
 * 					MSProtocolHandler, for handling communication with FSs.
 *					The FM_FS class instantiates a MSProtocol object in a
 *					separate thread, which in turn starts a server pool of 
 *					10 threads using the DispatchLoop() method. 
 *					The DispatchLoop() method instantiates an MSProtocolHandler
 *					object for every connection request it receives from FS.
 ***/

import java.io.*;
import java.net.*;
import java.util.*;

//Sets up the FM server that interacts with the FS
public class FM_FS implements FileManagerConstants{

   	static  ServerSocket MSSocket; //Manager-Server connections  
		FileServerDirectory fsd;

    public FM_FS() throws Exception{
    
      MSSocket = new ServerSocket(MSPORT);
			fsd = new FileServerDirectory();
    
    	System.out.println("Creating thread for manager-server connections");
    	new Thread(new MSProtocol(MSSocket)).start();
	  
    }
	
}//end of FileManager class

/***
 * Postcondition: Starts a thread pool of 10 server threads waiting for
 * 								connection requests from FSs. All the server threads 
 * 								listen on the same MSPORT (defined in the FileManagerConstants
 * 								interface.
 ***/

class MSProtocol implements Runnable,FileManagerConstants{

ServerSocket MSSocket;
int numThreads;

	public MSProtocol(ServerSocket MSSocket){
		this.MSSocket = MSSocket;
		numThreads = FSTHREADS;
	}

	public void run() {
	//Create thread-pool for handling File Server clients
							
	System.out.println("Creating thread pool for servers");
	for(int i=0; i<(numThreads - 1); i++){
		Thread thread = new Thread(){
			public void run(){
								
				try{
				DispatchLoop(MSSocket);
				} catch(Exception e) {}

			}
		};
		thread.start();
	}
	//The Nth thread itself	
	try{		
	DispatchLoop(MSSocket);
	} catch(Exception e){}
	
	
	}//end of run
	
private static void DispatchLoop(ServerSocket MSSocket) throws Exception{
	for(;;){
        System.out.println("In infinite loop, waiting for file-server to connect.");
		try{
			//The following is a blocking call
			Socket MSClient = MSSocket.accept();
			System.out.println("accept()ed connection from file-server");
			MSProtocolHandler handler = new MSProtocolHandler(MSClient);
			//Although the following call is for run(),
			//it is still a blocking call because a 
			//separate thread instance is not created.
			handler.run();		
		} catch (IOException e){;}

	}

}//end of DispatchLoop

}//end of class


class MSProtocolHandler implements Runnable,FileManagerConstants{

Socket MSClient;

//FileManagerProtocol instance to communicate with FS
FileManagerProtocol fmp;
InputStream in;
OutputStream out;
DataOutputStream dOut;


	//Constructor	
	public MSProtocolHandler(Socket MSClient) throws Exception{

	this.MSClient = MSClient;
	fmp = new FileManagerProtocol();
	in = MSClient.getInputStream();
	out = MSClient.getOutputStream();
	dOut = new DataOutputStream(out);
	}
	
	public void run() {
		try{
		
		fmp.byteDecode(in);
		//Now we have read the protocol number and msgType sent by the FS
		
		if(fmp.protocol != 1)
		{
			System.out.println("Client connecting on port: "+ MSPORT);
			System.out.println("not following manager-server protocol");
			return;
		}
		else
			System.out.println("File Server connecting from IPAddr: " + 
											MSClient.getInetAddress().getHostAddress());

		//Debugging
		//System.out.println(fmp);

		//Act on fmp message - could be setup or new setup or ...
		System.out.println("Acting on fmp message");

		switch((int)(fmp.msgType)){
		
			case SETUP: 	System.out.println("Calling handleSetup()");
										handleSetup();
										break;

			case SHUTDOWN: System.out.println("Calling handleShutdown()");	
										 handleShutdown();
										 break;
			
			default:		
				
		}
	
		} catch(Exception e){}
	
		try{
			MSClient.close();
		} catch(IOException e){;}
	
	}

	/***
 	*	Precondition: 	Data member fmp has already been instantiated by run()
 	*									and msgType in fmp is SETUP.
	*	Postcondition: 	If this is a setup for a new FS, this method saves the
	*									setup information in a FSNode object in the FSDirectory.
	*									Also assigns a serverId for a new file server.
	***/

 void handleSetup() throws Exception{

	String mOne = new String("-1".getBytes(DEF_ENCODING), DEF_ENCODING); 

 	DiskInfo DI = new DiskInfo();
 	DI.byteDecode(fmp.data);
 	System.out.println(DI); 

  FileManagerProtocol respondSetup;
 	 	
 	if((DI.serverId).equals(mOne)){
					
		System.out.println(	"Message received from server with serverId -1." +
												"\nMaking new server node");
		
 		//make a new server node and tell the server its Id
		//Assume FS status is active, by default
 		FSNode fSNode = new FSNode(DI);

		//Add the FSNode to the FileServerDirectory
 		if(!FileServerDirectory.addNode(fSNode)){
 			System.out.println("Could not add new File Server to FileServerDirectory");
	                //Need to send error message and EXIT
		}	
	  else{    //successfully added server, send confirmation and new serverId 
			DI.idLength = fSNode.idLength;
			DI.serverId = new String(fSNode.serverId); //Overwrite -1 with the new serverId	
		}	

 	}//end of serverId == -1

	//  System.out.println(DI);
	
	try{
		FSNode fSNode = FileServerDirectory.getNode(DI.serverId);
		System.out.println("Setting status of FS" + DI.serverId + " to active.");
		fSNode.active=true;
	}catch(Exception ee){
		
		System.out.println("handleSetup Exception-"+ee.getMessage());
		
	}

	respondSetup = new FileManagerProtocol((byte)SETUP_CONF,DI.byteEncode()); 

//  System.out.println(respondSetup);
	System.out.println("Sending SETUP_CONF msg to File Server: " + DI.myIP); 

	byte[] setupInfo = respondSetup.byteEncode();
	
	long timeStamp = System.currentTimeMillis();
	byte[] fmSig = FMSign.sign(setupInfo,timeStamp);
	
  dOut.write(setupInfo);

	dOut.writeLong(timeStamp);				//New-to prevent replay attack
	dOut.writeInt(fmSig.length);			//New-length of sig of data+timeStamp
	dOut.write(fmSig);								//New-sig of data+timeStamp

  dOut.close();		
	
	FileServerDirectory.showTrace(); //Debugging

 }//end of handleSetup()

	/***
	 * Postcondition: Changes the status of the FSNode object for the
	 * 								file server that sent the SHUTDOWN message to 
	 * 								active=false. Also sends SHUTDOWN_CONF message 
	 * 								to the FS.
	 ***/
 
	public void handleShutdown() throws Exception{

 		DiskInfo DI = new DiskInfo();
 		DI.byteDecode(fmp.data);
 		System.out.println(DI); 
	
		System.out.println("In handleShutdown()... FS: "+DI.serverId);

		try{
			FSNode fSNode = FileServerDirectory.getNode(DI.serverId);
			System.out.println("Setting status of FS " + DI.serverId + " to inactive.");
			fSNode.active=false;
		}catch(Exception ee){
			System.out.println("handleShutdown()-exception: " + ee.getMessage());
			return;
		}

  	FileManagerProtocol respondShutdown;
		respondShutdown = new FileManagerProtocol((byte)SHUTDOWN_CONF,DI.byteEncode()); 
		System.out.println("Encoded respondShutdown as byte array.");
		byte[] shutdownInfo = respondShutdown.byteEncode();

		long timeStamp = System.currentTimeMillis();
		byte[] fmSig = FMSign.sign(shutdownInfo,timeStamp);
		
  	dOut.write(shutdownInfo);
		System.out.println("Sending following timeStamp: " + timeStamp);
		dOut.writeLong(timeStamp);				//New-to prevent replay attack
		System.out.println("Sending following sigLen: " + fmSig.length);
		dOut.writeInt(fmSig.length);			//New-length of sig of data+timeStamp
		dOut.write(fmSig);								//New-sig of data+timeStamp

  	dOut.close();		
		System.out.println("handleShutdown-Done");
	}


}//end of class
 



