/*
 * FM.java
 *
 * Created on April 23, 2002, 4:40 PM
 */
 
package FM;           

/***
 * Purpose: This class contains the init() method of the FM servlet and
 * 					is the first class to be loaded by the servlet server on 
 * 					initialization. This class also contains the destroy()
 * 					method of the FM servlet. The destroy() method is called 
 * 					by the servlet server before the FM servlet is destroyed.
 * 					The destroy() method saves the FM's state information to files.
 ***/ 					

import java.net.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

/** 
 * @author Prashant Sarma
 * @version 0.1
 */

public class FM extends HttpServlet implements FileManagerConstants{

		FileOutputStream dfos;
		PrintStream dps;
		OwnerDirectory od;
		FMSign fms;						//Class for signing data with FM's private key
		
		Cleaner cleaner;			//Runs once a day, removing 'expired' owners

		
  /*** 
	 * 	Initializes the servlet.This method executes once when the servlet gets
	 * 	loaded into the JVM. Very useful.
	 ***/  

	public void init(ServletConfig config) throws ServletException {

  	super.init(config);

		/***Uncomment to send output to log file: debug.log
		***/
		try{
			dfos = new FileOutputStream("debug.log");
			dps = new PrintStream(dfos);
			System.out.println("Sending Debug Messages to file debug.log");
			System.setOut(dps);
		}catch(Exception e){
			System.out.println("Couldn't set output stream to log file");
		}

		try{
			System.out.println("In init() of servlet FM");
			od = new OwnerDirectory();
			fms = new FMSign();
			cleaner = new Cleaner();	
			
		}catch(Exception ee){
			System.out.println("init Exception-"+ee.getMessage());
		}

		/***
 		* FM_FS handles interaction of the FM with FSs. We start the server which 
		* then creates its own thread pool (10 threads).
 		***/ 	

		try{
			FM_FS fm_fs = new FM_FS();
		}catch(Exception e){
			System.out.println("Cound not instantiate FM_FS for conversation with FS");
		}

    }//end of init

		/***
		 * Postcondition: Saves the FM's state information to various files before the 
		 * 								FM servlet is destroyed.
     *								Destroys the servlet. 
		 ***/ 								

    public void destroy() {
			
			dps.close();	//close output stream to log file.
			
			System.out.println("\n\nSaving OwnerDirectory state to file: " + ODFILE);
			OwnerDirectory.writeToFile();
			System.out.println("\n\nSaving FileServerDirectory state to file: " + FSDFILE);
			FileServerDirectory.writeToFile();
			System.out.println("Saving FM's KeyPair to file: " + KEYFILE);
			FMSign.writeToFile();
			System.out.println("\n");
    }

    /** Handles the HTTP <code>GET</code> method.
    * @param request servlet request
    * @param response servlet response
    */

    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, java.io.IOException {

			System.out.println("****************In GET******************");

				if(request.getHeader("referer") != null) {
					doPost(request,response);				
					return;
				}
				else {
				}

				//Display user-registration web page form.

        PrintWriter out = response.getWriter();

        out.println("<html>");
        out.println("<body>");
        out.println("<head>");

        out.println("</head>");
        out.println("<body bgcolor=\"white\">");
				out.println("<br>");
				out.println("<p>Welcome to Diskster.</p>");
				out.println("<br>");
				out.println("If you are a new user, click <a href=\"https://ep.netlab.uky.edu:8443/servlet/FM.FM\"><i>here</i></a> to register");

        out.println("</body>");
        out.println("</html>");

    } 

    /** Handles the HTTP <code>POST</code> method.
    * @param request servlet request
    * @param response servlet response
    */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, java.io.IOException {

			System.out.println("\n****************In Post******************\n");
	
			String FMHOME = "https://ep.netlab.uky.edu:8443/servlet/FM.FM";
						
			String ref = request.getHeader("referer");
			System.out.println("In Post, Referer: " + ref);

			if(ref != null && FMHOME.compareTo(ref)==0) {

				System.out.println("POST request through FM webpage");
				System.out.println("Calling ownerSetup()");

					try{
						ownerSetup(request,response);
					}catch (Exception e){
						System.out.println("Couldn't call ownerSetup(): " + e.getMessage());
						doPost(request,response);
					}

				return;
			}

			//Create FM_Owner instance to handle the interaction
			try{
							ServletInputStream sis = request.getInputStream();
							ServletOutputStream sos = response.getOutputStream();
							System.out.println("Instantiating FM_Owner...");

							FM_Owner fm_owner = new FM_Owner(sis,sos); //Thats it!!!

			} catch(Exception e){
			}
    }


    /* Returns a short description of the servlet*/
    public String getServletInfo() {
        return "Short description";
    }


		/***
		 * Postcondition: Reads user-registration information from the submitted web
		 * 								form. Checks validity of user information (valid ownerId and
		 * 								valid space request) and creates an OwnerNode object 
		 * 								and stores the OwnerNode object in the OwnerDirectrory.
		 * This method also uses one Apache opensource HTMLFilter object.
		 ***/
		
		public void ownerSetup(HttpServletRequest request, HttpServletResponse response) throws Exception{

        response.setContentType("text/html");

        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<body>");
        out.println("<head>");

        out.println("</head>");
        out.println("<body bgcolor=\"white\">");

        String ownerId = request.getParameter("OwnerId");
        String passWord = request.getParameter("PassWord");
        String spaceReqString = request.getParameter("SpaceReq");

				//Will be made true if invalid data is submitted
				boolean invalid = false;
				boolean invalid2 = false;

				long spaceReq=-1;
				try{
					spaceReq = (new Long(spaceReqString)).longValue();
				}catch(Exception e){
					System.out.println("Invalid space request...");
					invalid=true;
				}

				if(ownerId != null){
						//invalid2 is true if ownerId already taken	
						invalid2 = OwnerDirectory.containsNode(HTMLFilter.filter(ownerId));
						System.out.println("contains"+HTMLFilter.filter(ownerId)+" returned "+invalid2);
						
				}
				
        if (ownerId != null &&  passWord != null && spaceReqString != null && !invalid && !invalid2) {

						OwnerNode oNode = new OwnerNode(HTMLFilter.filter(ownerId), passWord, spaceReq); //pass setup parameters
						//add oNode to OwnerDirectory
						OwnerDirectory.addOwner(oNode);

						System.out.println("Finished adding new Owner");


						out.println("Welcome to the Diskster world of disk sharing!");
        		out.println("<br>");
        		out.println("<br>");
						out.println("You are registered as follows: ");
        		out.println("<br>");
        		out.println("<br>");

            out.println("Owner Id = " + HTMLFilter.filter(ownerId) + "<br>");
            out.println("Space Requested = " + spaceReq + "<br>");


        } else {
        out.println("<P>");
        out.print("<form action=\"");
        out.print("FM.FM\" ");
        out.println("method=POST>");
        out.println("<br>");
				out.println("Welcome to the Diskster world.");
				out.println("<br>");

				if(invalid && (ownerId != null || passWord != null)){
					//implies Not the first POST

        out.println("<br>");
        out.println("<br>");
				out.println("***Invalid Space Request***");
        out.println("<br>");
        out.println("<br>");
					
				}
				
				if(invalid2 && (ownerId != null || passWord != null)){
					//implies Not the first POST
					//Can also check for owner ids that are already taken

        out.println("<br>");
        out.println("<br>");
				out.println("***ownerId already taken. Please choose another ownerId***");
        out.println("<br>");
        out.println("<br>");
					
				}
        out.println("<br>");
				out.println("Please enter the following information:");
        out.println("<br>");
				out.println("Owner Id: ");

        out.println("<input type=text size=20 name=OwnerId>");
        out.println("<br>");
        out.println("<br>");

				out.println("Password: ");
				
        out.println("<input type=password size=20 name=PassWord>");
        out.println("<br>");
        out.println("<br>");

				out.println("Space Request: ");

        out.println("<input type=text size=20 name=SpaceReq>");
        out.println("<br>");
        out.println("<br>");

        out.println("<input type=submit value=\"Register\">");
        out.println("<input type=reset value=\"Reset\">");
				
        out.println("</form>");
				}

        out.println("</body>");
        out.println("</html>");

			System.out.println("User entered...");
			System.out.println("ownerId: " + ownerId);
			System.out.println("passWord: " + passWord);
			System.out.println("spaceReq: " + spaceReq);
    

		}

} //end of FM class





