
package FM;

/***
 * Purpose: This class is used by the FM and FSs to store/transmit setup information 
 * 					about a File Server.
 ***/

import java.net.*;
import java.io.*;
import java.util.*;


class DiskInfo implements FileManagerConstants{

    int idLength = 0;    
    String serverId;     //this variable should have DEF_ENCODING
    long totSpace = 0;
    long spaceLeft = 0;
    String myIP;     	 	
    String fileManagerIP;//IP address
    File setupFile = new File("server_setup.properties"); // long file ext - Unix???

    public DiskInfo(){
            //Constructor - Data members are initialized by readSetup() or byteDecode()
    }

        /***
				*	This method is used on the FS, not on the FM.
				*
				* Precondition: 	server_setup.properties does not exist 
        * Postcondition: 	Creates a setup file interactively if it does not exist.
        ***/

        boolean createSetup() throws Exception{

                FileOutputStream fOut = new FileOutputStream(setupFile);
                DataOutputStream dOut = new DataOutputStream(fOut);

                System.out.println("Writing to setup file: ");

                //Actually store encoded bytes in file
                byte[] encodedByteId = "-1".getBytes(DEF_ENCODING);
                idLength = encodedByteId.length;

                dOut.writeByte(idLength);

                dOut.write(encodedByteId);

                System.out.print(	"Please enter the amount of disk space(in bytes) " 
																	+ "you intend to offer: ");

                //Read from keyboard
                InputStreamReader isr = new InputStreamReader(System.in);
                StreamTokenizer st = new StreamTokenizer(isr);
                long c = st.nextToken();
                while(c != StreamTokenizer.TT_NUMBER){
                        System.out.print(	"Please enter the amount of disk space(in bytes) " 
																					+ "you intend to offer: ");
                        c = st.nextToken();
                }

								//total space offered by FS
                dOut.writeLong((long)(st.nval));

								//space left out of total space
                dOut.writeLong((long)(st.nval));

								fileManagerIP = "206.240.24.73";            //SELAB - EP
								
								//fixed length, add trailing blanks
               	while(fileManagerIP.length() < 15)
									fileManagerIP += " ";

               	dOut.writeBytes(fileManagerIP);

                dOut.flush();
                dOut.close();
                return true;

        }

    /***
		 * This method is used on FS, not FM
		 * 
		 * Postcondition: Reads FS setup file if it exists. If setup file for FS
		 *                does not exist, this method calls createSetup() to create 
		 *                the setup file interactively with the user.
		 *                If file file_dir.properties exists, initializes FileDirectory
		 *                from saved state in file_dir.properties.
		 *                If file_dir.properties does not exist instantiates empty            *                FileDirectory.
		 ***/
				
    public void readSetup() throws Exception{

            if(!setupFile.exists()){
            		System.out.println(	"Setup file does not exist.\n " 
																		+ "Interactively creating new setup file");
                //create setup file
                if(!createSetup()){
                        System.out.println(" ERROR: Unable to create setup file");
                        System.exit(1);
                }
            }

        try{

            FileInputStream fIn = new FileInputStream(setupFile);
            DataInputStream dIn = new DataInputStream(fIn);


        		System.out.println();
        		System.out.println("Reading from setup File:");

        		idLength = dIn.read();

						//serverId        
        		byte[] buf = new byte[idLength];
        		dIn.readFully(buf);
        		serverId = new String(buf,DEF_ENCODING); 
        
        		//totSpace
						totSpace = dIn.readLong();

						//spaceLeft
						spaceLeft = dIn.readLong();
 
     				//myIP
        		try{

            	InetAddress myAddr = InetAddress.getLocalHost();
            	myIP = myAddr.getHostAddress();
               	while(myIP.length() < 15) myIP += " ";

        		} catch(Exception E){ }

						//fileManagerIP
        		byte[] buf2 = new byte[15];
        		dIn.readFully(buf2);
        		fileManagerIP = new String(buf2); 

        		dIn.close();

        } catch(Exception E){ }

    }//end of readSetup()

		/***
		 * This method is used on FS, not on FM.
		 * Postcondition: Writes the FS setup file to disk.
		 ***/
    public void writeToFile() throws Exception{
   
			FileOutputStream fOut = new FileOutputStream(setupFile);
      DataOutputStream dOut = new DataOutputStream(fOut);

			System.out.println("Writing following DiskInfo to setup file.");

			dOut.write(idLength);
			byte[] buf = serverId.getBytes(DEF_ENCODING);
			dOut.write(buf);

      dOut.writeLong(totSpace);
      dOut.writeLong(spaceLeft);
      dOut.writeBytes(fileManagerIP); 

      dOut.flush();
      dOut.close();

    }

		/***
		 * Precondition: 	Data members are initialized.
		 * Postcondition: Encodes data members as a byte array fit to be
		 * 								transmitted over the network.
		 ***/

    byte[] byteEncode() throws Exception{

        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf);

        System.out.println("Encoding DiskInfo data as Byte Array");

        out.writeByte(idLength);

				byte[] encBuf = serverId.getBytes(DEF_ENCODING);
				out.write(encBuf);

        out.writeLong(totSpace);
        out.writeLong(spaceLeft);

				out.writeBytes(myIP); 		

        out.writeBytes(fileManagerIP); 

				//Send FM's public key
				byte[] pubKey = FMSign.getPublicKeyEncoded();
				out.writeInt(pubKey.length);
				out.write(pubKey);

        out.flush();
        return buf.toByteArray();
    }
		/***
		 * Precondition: 	data is a byte-array encoding of a DiskInfo object
		 * Postcondition:	DiskInfo data members are initialized with the contents of 
		 * 								data.
		 ***/

    void byteDecode(byte[] data) throws Exception{

        ByteArrayInputStream is = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(is);

        System.out.println("Decoding byte array data for DiskInfo: ");

        idLength = dis.read();		

 				System.out.println("serverId Length: " + idLength);

				byte buf[] = new byte[idLength];
				dis.readFully(buf);
				serverId = new String(buf,DEF_ENCODING);

        totSpace = dis.readLong();
        spaceLeft = dis.readLong();

        byte tempIP[] = new byte[15]; 	// IP address string is 15 bytes long
        dis.readFully(tempIP);
        myIP = new String(tempIP);     

        dis.readFully(tempIP);
        fileManagerIP = new String(tempIP);

        dis.close();

    }//end of byteDecode()

		/***
		 * Purpose: Helper function to print data members.
		 ***/
		
    public String toString(){

        String dInfo = L_SEP + "*******************************************************";

        dInfo += L_SEP + "Disk Info: " + L_SEP;
        dInfo += "idLength: " + idLength + L_SEP;
        dInfo += "serverId: " + serverId + L_SEP;
        dInfo += "totSpace: " + totSpace + " spaceLeft: " + spaceLeft + L_SEP;
        dInfo += "File Server IP: " + myIP + " File Manager IP: " + fileManagerIP + L_SEP;
        dInfo += "*******************************************************" + L_SEP;
        return dInfo;
    }

}//end of DiskInfo class






