package FM;

/***
 * Purpose: Minimal File Description sent by FM to FS
 ***/

import java.net.*;
import java.io.*;
import java.util.*;
import java.lang.*; 				//for Math class

  public class BriefFileDesc implements FileManagerConstants{

	String fileId = null;     //generated by constructor of FNode
  int fIdLength = 0;       	

	long maxEncFileSize = 0; 	//max expected size of the file
														//when it is encrypted.
	long blockUnit = 0; 			//size of the encrypted file block, 

	/***
	*	Constructor: Most of the data members are copied from the 
	*	regular FileDescription, but some additional members may 
	*	be instantiated separately
	***/
  public BriefFileDesc(FileDescription fd){

					this.fileId = fd.fileId;
					fIdLength = fd.fIdLength;
					this.maxEncFileSize = fd.maxEncFileSize;
					this.blockUnit = fd.blockUnit;

  }

	public BriefFileDesc(FNode fn) throws Exception{

		this.fileId = fn.fileId;
		byte[] fIdArr = this.fileId.getBytes(DEF_ENCODING);
		fIdLength = fIdArr.length;					
		this.maxEncFileSize = fn.fileSize;
		this.blockUnit = fn.blockUnit;

	}



	public BriefFileDesc(){

	 //Data members are initialized by byteDecode()

	}

  /***
	 * Precondition: Data members are initialized.
	 * Postcondition: returns a byte array of data members.
	 ***/
  public byte[] byteEncode() {

		try{
    	ByteArrayOutputStream buf = new ByteArrayOutputStream();
    	DataOutputStream out = new DataOutputStream(buf);
			out.writeInt(fIdLength);
			out.write(fileId.getBytes(DEF_ENCODING));
			out.writeLong(maxEncFileSize);
			out.writeLong(blockUnit);

    	out.flush();

    	return buf.toByteArray();
		}catch (Exception e){
			return null;	
		}

  }

	/***
	 * Precondition: 	data is a byte array containing a byte encoding of 
	 * 								BriefFileDesc object
	 * Postcondition: Object data members are initialized from data.
	 ***/

  public void byteDecode(byte[] data) throws Exception{

  ByteArrayInputStream is = new ByteArrayInputStream(data);
  DataInputStream dis = new DataInputStream(is);

  System.out.println("Decoding byte array data for BriefFileDesc: ");

	fIdLength = dis.readInt();

	byte[] tempArr2 = new byte[fIdLength];
	dis.readFully(tempArr2);
	fileId = new String(tempArr2,DEF_ENCODING);

	maxEncFileSize = dis.readLong();
	blockUnit = dis.readLong();

  dis.close();
  }

	//Helper function: prints data members for debugging
  public String toString(){

    String dInfo = L_SEP + "************************************************";
    dInfo += "maxEncFileSize: " + maxEncFileSize + L_SEP;
    dInfo += "fileId: " + fileId + L_SEP;
    dInfo += "blockUnit: " + blockUnit + L_SEP;
    dInfo += "************************************************" + L_SEP;
    return dInfo;
  }

}//end of class



