package DT;

/***
 * Purpose: OwnerInfo class stores the ownerId, user's password and
 * 					DES key. This class has methods for retrieving the above
 * 					mentioned information from the user.
 ***/

import java.io.*;

	public class OwnerInfo implements FileManagerConstants, Serializable{

     	public String ownerId;
     	public String DESKey ;
			public String password;

     	public byte[] idArr;
     	public byte idLength; //length of owner id

     	public OwnerInfo() throws Exception{

			InputStreamReader isr = new InputStreamReader(System.in);
			StreamTokenizer st = new StreamTokenizer(isr);
	
			System.out.print("Please enter Owner Id: ");
			int choiceType = st.nextToken();
			while(choiceType != StreamTokenizer.TT_WORD){
				System.out.println("Invalid owner id. Please try again");
				System.out.print("Please enter Owner Id: ");
				choiceType = st.nextToken();
			}
			ownerId = new String(st.sval);

			System.out.print("Please enter password: ");
			choiceType = st.nextToken();
			while(choiceType != StreamTokenizer.TT_WORD){
				System.out.println("Invalid password. Please try again");
				System.out.print("Please enter password: ");
				choiceType = st.nextToken();
			}
			password = new String(st.sval);
			
			int keyLen = 0;
			System.out.println("Please enter a DES key that is at least 8 ");
			System.out.println("characters long. This key will be used for ");
			System.out.println("encrypting and decrypting data submitted ");
			System.out.print("to Diskster: ");
			choiceType = st.nextToken();
			if(choiceType == StreamTokenizer.TT_WORD){
			 	DESKey = new String(st.sval);
				keyLen = DESKey.length();
			}

			while(choiceType != StreamTokenizer.TT_WORD || keyLen<8){
				System.out.println("Invalid DESKey...");
				if(keyLen<8)
						System.out.println("DESKey should be atleast 8 characters long.");
				System.out.print("Please enter DES key: ");
				choiceType = st.nextToken();
			  if(choiceType == StreamTokenizer.TT_WORD){
					 	DESKey = new String(st.sval);
						keyLen = DESKey.length();
						}
			}
	
       byte[] tempIdArr = ownerId.getBytes(DEF_ENCODING);

      if(tempIdArr.length > MAX_DESC_LEN){

        System.out.println("ERROR: Owner Id can have maximum " + 
														MAX_DESC_LEN + " bytes");
        System.exit(1);

      }
       idLength = (byte)tempIdArr.length;
       idArr = new byte[idLength];

       System.arraycopy(tempIdArr, 0, idArr, 0, idLength);

     }//end of constructor

	}//end of class

