package DT;

/***
 * Purpose: FileDirectory contains the TreeMap of all FNode
 *          objects of the user. On DT, we only need a simplified 
 *          FileDirectory containing FNode objects with the fName 
 *          and block signatures.
 ***/

import java.util.*;
import java.io.*;
import java.net.*;
import java.security.*;
import java.util.TreeMap;

public class FileDirectory{

	static TreeMap fileTree;				//common to all instances
	static int numFiles = 0;				//updated by getFileNames()
	
	public FileDirectory() throws Exception{
		File fdFile = new File("file_dir.properties");
		if(fdFile.exists()){
			FileInputStream fis = new FileInputStream(fdFile);
			ObjectInputStream ois = new ObjectInputStream(fis);		
			fileTree = (TreeMap)ois.readObject();			
			ois.close();
		}
		else
			fileTree = new TreeMap();
	}

	public static void writeToFile() throws Exception{
	
		FileOutputStream fos = new FileOutputStream("file_dir.properties");
		ObjectOutputStream oos = new ObjectOutputStream(fos);

		oos.writeObject(fileTree);	
		oos.flush();
		oos.close();
		fos.close();	
	}

	public static FNode removeNode(String fId){
		return (FNode)fileTree.remove(fId);
	}		

	public static boolean addNode(FNode fNode){
		if(fileTree.containsKey(fNode.fileId)) return false;
		fileTree.put(fNode.fileId, fNode);
		return true; 
	}

  /***
	 *  Precondition:   Called when the fNode is already present in
	 *                  the FileDirectory. Called when a file has
	 *                  been modified by its owner.
	 *  Postcondition:  Replaces an FNode object in the FileDirectory.
	 ***/

	public static boolean updateNode(FNode ufNode){
		//redundant based on our precondition
		if(!fileTree.containsKey(ufNode.fileId)) return false;
		//Do we simply want to replace the old fNode?		
		fileTree.put(ufNode.fileId, ufNode);
		return true; 
	}

	/***
 	*  Postcondition: Returns true if fileId is already present, 
	*  								false otherwise
 	***/
	public static boolean contains(FNode cfNode){
		return fileTree.containsKey(cfNode.fileId);
	}
	
	/***
 	*  Precondition: directory contains FNode with fileId..
	*  Postcondition: retrieves requested FNode obejct from 
	*  								FileDirectory and returns it.
 	***/
	public static FNode getNode(String fileId){
	  return (FNode)fileTree.get(fileId);
	}

	/***
	*	Purpose: 	This method is used to display the file listing of 
	*						files submitted to Diskster.
	*	Postcondition: Returns file name list of submitted files
	***/
	public static String[] getFileNames(){

		Set fSet = fileTree.entrySet();
		Iterator it = fSet.iterator();

		//I am assuming this is efficient because these are only
		//pointers to Strings. Space will be allocated for the String 
		//only on assignment
    String[] fList = new String[100];
		int fIndex=0;
		
 		while(it.hasNext()){
			Map.Entry me = (Map.Entry)it.next();
			FNode fNode = (FNode)me.getValue();
			fList[fIndex++] = fNode.fileName;
		}
    numFiles = fIndex;
		return fList;
	}
	
}//end of class




