package DT;

  /***
	 * Purpose:  This class has methods and data members to code/decode
	 *           File Description information sent between the FM and
	 *           DT, HH, Proxy.
	 ***/

import java.net.*;
import java.io.*;
import java.util.*;
import java.lang.*; //for Math class

  public class FileDescription implements FileManagerConstants{

	String fileId = null;			//generated by constructor of FNode
	int fIdLength = 0;				

  String fName = null;
  String ownerId = null;
  int idLength;
  int fNameLength;

	public long maxEncFileSize = 0;	//expected size of the file
																	//when it is encrypted.

	public long blockUnit = 0; 			//size of the encrypted file 
																	//block
	public OwnerInfo oi;

	//constructor, initializes all data members from FNode
	public FileDescription(FNode fn, OwnerInfo oi){
		fileId = fn.fileId;
		fIdLength = fn.idLength;
		fName = fn.fileName;
		maxEncFileSize = fn.fileSize;
		blockUnit = fn.blockUnit;
		this.oi = oi;
	}

  public FileDescription(String fName, OwnerInfo oi){
		this.fName = fName;
		this.oi = oi;
  }

	public FileDescription(){
	 //Data members are initialized by byteDecode()
	}

	public void putId(FNode fN){
		this.fileId = fN.fileId;
		this.fIdLength = fN.idLength;

	}

	public void putEncFileSize(int inSize, int outSize){
		
		File file = new File(fName); //assuming fName initialized
		this.blockUnit = outSize;

		long totBytes = file.length();
		//Dont ask how I conjured up this formula ;-)
		maxEncFileSize =(long) Math.ceil((totBytes/(float)inSize))*((long)outSize);
		
	}

  /***
	 * Precondition: class data members are initialized.
	 * Postcondition: returns a byte array of class data members.
	 ***/

  public byte[] byteEncode() throws Exception{

    byte[] fileNameArr = fName.getBytes(DEF_ENCODING);
    int fNameLength = fileNameArr.length;

    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(buf);
    out.writeInt(oi.idLength);
    out.write((oi.ownerId).getBytes(DEF_ENCODING));

    out.writeInt(fNameLength);

    out.write(fileNameArr);


		out.writeInt(fIdLength);
		out.write(fileId.getBytes(DEF_ENCODING));

		out.writeLong(maxEncFileSize);
		out.writeLong(blockUnit);

    out.flush();

    return buf.toByteArray();
  }

  /***
	 * Precondition:  data is a byte array containing byte encoding of
	 *                FileDescription object.
	 * Postcondition: initializes data members from byte array data.
	 ***/

  public void byteDecode(byte[] data) throws Exception{

  	ByteArrayInputStream is = new ByteArrayInputStream(data);
  	DataInputStream dis = new DataInputStream(is);

  	idLength = dis.readInt();
  	byte buf[] = new byte[idLength];

  	dis.readFully(buf);
  	ownerId = new String(buf, DEF_ENCODING);

  	fNameLength = dis.readInt();

  	byte[] tempArr = new byte[fNameLength];
  	dis.readFully(tempArr);
  	fName = new String(tempArr,DEF_ENCODING);

		fIdLength = dis.readInt();
		byte[] tempArr2 = new byte[fIdLength];
		dis.readFully(tempArr2);
		fileId = new String(tempArr2,DEF_ENCODING);
	
		maxEncFileSize = dis.readLong();
		blockUnit = dis.readLong();

  	dis.close();
  }

	//Helper function: returns data members as strings for debugging.
  public String toString(){
    if(fName == null) return null;
    String dInfo = L_SEP + "*******************************************************";
    dInfo += L_SEP + "File Name: " + fName;
    dInfo += L_SEP + "OwnerId: " + ownerId + L_SEP + "maxEncFileSize: " + maxEncFileSize + L_SEP;
    dInfo += "*******************************************************" + L_SEP;
    return dInfo;
  }

}//end of class



