package DT;

import java.util.*;
import java.io.*;
import java.net.*;
import java.security.*;

/***
 * Purpose: The FNode object stores information about a file.
 *          The FNode object is stored in the FileDirectory
 *          tree.On the DT, we only need a simplified FileDirectory 
 *          with the fName and block signatures stored.
 ***/

public class FNode implements FileManagerConstants, Serializable{

	public String fileId = null;				//server as key to FileDirectory
																			//TreeMap
	public int idLength;								//length of fileId
	public String fileName;
	public String[] FS = new String[5];	// File Server IPs where this file
																			// is replicated
	public int noBlocks;   							// Number of encblocks in the file
	public long fileSize;								// Max Size of file in bytes
	public long blockUnit;							// size of one block
	
	//Entry 0 corresponds to signature of block 0 and so on.
	byte[][] blockSig;
	int sigSize;                        

	/***
	 * If more blocks are needed, point to another FNode
	 * Not implemented, just a provision for future implementation.
	 ***/
	FNode nextNode = null; 							// Initialised only if more than 500 
																			// blocks are required for the file  						
//constructor, generates FNode from BriefFNode
public FNode(BriefFNode bfn){

 	this.fileId = bfn.fileId;
	this.idLength = bfn.fIdLen;
	this.fileName = bfn.fileName;
	this.noBlocks = bfn.noBlocks;
	this.fileSize = bfn.fileSize;
	this.blockUnit = bfn.blockUnit;
	this.sigSize = bfn.sigSize;
  
	this.blockSig = new byte[500][sigSize];	//500 blocksigs each sig of size sigSize
	for(int bIndex=0; bIndex<this.noBlocks; bIndex++)
		System.arraycopy(bfn.blockSig[bIndex], 0, this.blockSig[bIndex], 0, this.sigSize);

}

//constructor, generates an FNode with a new fileId
public FNode(String fName, OwnerInfo oi) throws Exception{

	fileName = fName;
	
	//make a new fileId using SHA-1 on the ownerId+file name
	//Store the fileId as a String

	MessageDigest md = MessageDigest.getInstance("SHA-1");
	md.update(fName.getBytes(DEF_ENCODING));
	md.update(oi.ownerId.getBytes(DEF_ENCODING));
	byte digest[]  = md.digest();
	
	fileId= new String(digest, DEF_ENCODING);

	byte[] idArr = fileId.getBytes(DEF_ENCODING);
	idLength = idArr.length;
}

//helper function, enters FS IP addresses when FM responds to file request.
public void setFSList(String[] FSList){
	for (int fsIndex=0; fsIndex<5; fsIndex++){
		this.FS[fsIndex] = FSList[fsIndex];
	}
}

//helper function, initializes block information 
public void setBlockInfo(int sSize, FileDescription fDesc){
	sigSize = sSize;
	blockSig = new byte[500][sigSize];	//500 blocksigs each sig of size sigSize
	fileSize = fDesc.maxEncFileSize;	
	blockUnit = fDesc.blockUnit;
}

//helper function, initializes number of blocks in the FNode for 
//a file submitted to Diskster.
public void setNumBlocks(int numBlocks){
	noBlocks = numBlocks;
}

//helper function, for debugging
public String toString(){
	
	String fNodeInfo;
	
	fNodeInfo = " File Id: " + fileId + " Name: " + fileName + 
				"\n FS 0: " + FS[0] + " FS 1: " + FS[1] + " FS 2: " + FS[2] +
				"\n FS 3: " + FS[3] + " FS 4: " + FS[4] + "\n";

	return fNodeInfo;
}


}// end of class

