
package DT;

/***
 * Purpose: Encryptor is used by DeskTop to encrypt and decrypt file 
 * 					blocks submitted and retrieved from FM using the DES 
 * 					implementation of BouncyCastle cryptography.
 *
 * This class has been modified from the article "Data Encryption for 
 * J2ME Profiles" by Eric Giguere posted on the Sun website at 
 * http://wireless.java.sun.com/midp/ttips/dataencryp/
 ***/

import org.bouncycastle.crypto.*;
import org.bouncycastle.crypto.engines.*;
import org.bouncycastle.crypto.modes.*;
import org.bouncycastle.crypto.params.*;
import org.bouncycastle.crypto.paddings.*;

public class Encryptor {

    BufferedBlockCipher cipher;
    private KeyParameter        key;
    public  int 		blockSize;
		public  int     outputSize;

    // Initialize the cryptographic engine.
    // The key array should be at least 8 bytes long.
    public Encryptor( byte[] key ){
        cipher = new PaddedBufferedBlockCipher(
                    new CBCBlockCipher(
                       new DESEngine() ) );

        this.key = new KeyParameter( key );
		//NOTE: So the following sizes are valid only while encrypting
		cipher.init(true,this.key);
		blockSize = 24*cipher.getBlockSize();
		outputSize = cipher.getOutputSize(blockSize);

    }

    // Initialize the cryptographic engine.
    // The string should be at least 8 chars long.
    public Encryptor( String key ){
        this( key.getBytes() );
    }

    // Private routine that does the gritty work.
    private byte[] callCipher( byte[] data , int len) {
				
        int    size = cipher.getOutputSize( len );
        byte[] result = new byte[ size ];
        int    olen = cipher.processBytes( data, 0,
                              len, result, 0 );
				try{
        	olen += cipher.doFinal( result, olen );
				}catch(InvalidCipherTextException icte){
					System.out.println("callCipher Exception-"+icte.getMessage());
					System.exit(1);
				}

        if( olen < size ){
            byte[] tmp = new byte[ olen ];
            System.arraycopy( 
                             result, 0, tmp, 0, olen );
            result = tmp;
        }

        return result;
    }

    // Encrypt arbitrary byte array, returning the
    // encrypted data in a different byte array.
    public synchronized byte[] encrypt( byte[] data, int len )
                  throws CryptoException {
        if( data == null || data.length == 0 ){
            return new byte[0];
        }

        cipher.init( true, key );
        return callCipher( data, len );
    }

    // Encrypts a string.
    public byte[] encryptString( String data )
                  throws CryptoException {
        if( data == null || data.length() == 0 ){
            return new byte[0];
        }

        return encrypt( data.getBytes() , data.length());
    }

    // Decrypts arbitrary data.
    public synchronized byte[] decrypt( byte[] data, int len )
                  throws CryptoException {
        if( data == null || data.length == 0 ){
            return new byte[0];
        }

        cipher.init( false, key );
        return callCipher( data,len );
    }

    // Decrypts a string that was previously encoded
    // using encryptString.
    public String decryptString( byte[] data , int len)
                    throws CryptoException {
        if( data == null || data.length == 0 ){
            return "";
        }

        return new String( decrypt( data, len ) );
    }
}


