package DT;

/***
 * Purpose: Minimal File Description sent by FM to Proxy
 *          to enable Proxy to retrieve the file on behalf
 *          of HH.
 ***/

import java.net.*;
import java.io.*;
import java.util.*;
import java.security.*;

class BriefFNode implements FileManagerConstants{

	String fileId;
	int fIdLen;
	String fileName;	//For display in GUI
	int sigSize;
	int noBlocks;
	long blockUnit;
	long fileSize;
	byte[][] blockSig;	//Need to allocate memory


	public BriefFNode(){
		//Data members will be initialized by byteDecode()
	}

	//Initializes data members from input stream
	public void byteDecode(byte[] bfNodeArr) throws Exception{

	ByteArrayInputStream bais = new ByteArrayInputStream(bfNodeArr);
	DataInputStream badis = new DataInputStream(bais);

	
	
		fIdLen = badis.readInt();
		byte[] tempArr = new byte[fIdLen];
		badis.readFully(tempArr);
		fileId = new String(tempArr, DEF_ENCODING);

		int nameArrLen = badis.readInt();
		byte[] nameArr = new byte[nameArrLen];
		badis.readFully(nameArr);
		fileName = new String(nameArr,DEF_ENCODING);

		sigSize = badis.readInt();
		noBlocks = badis.readInt();
		blockUnit = badis.readLong();
		fileSize = badis.readLong();

		//important to allocate memory after reading sigSize
		blockSig = new byte[500][sigSize];	//max 500 sigs per file

		byte[] sig = new byte[sigSize];
		//Read block sigs
		for(int bIndex=0; bIndex<noBlocks; bIndex++){
			badis.readFully(sig);
			System.arraycopy(sig, 0, blockSig[bIndex], 0, sigSize);
		}

		badis.close();
	}

}


