/* JobAgent.java */ 

public class JobAgent extends JavaPVM implements Constants
{
      int myTid;
      int parentTid;
      int jobID[] = new int[1];
      
// Constructor of Class JobAgent
JobAgent()
{
   super(0, null, 0);
   myTid = pvm_mytid();
   parentTid = pvm_parent();
}

protected Job Receive()
{
   Job    job;
   Buffer bufptr;
   int    i;
   int    info[] = new int[1];

   job = new Job();


   //receive broadcast data
      pvm_recv(parentTid, 0);

      pvm_upkint(info, 1, 1);

      if(info[0] != -1)
      {

         bufptr = job.broadcastReceiveBuffer;


         UnpackBuffer(bufptr);
      }

      // receive private data
      pvm_recv(parentTid, 1);

      pvm_upkint(jobID, 1, 1);

      bufptr = job.privateReceiveBuffer;

      UnpackBuffer(bufptr);

/*   fout << "bufptr->ptr[0] = " << bufptr->strptr[0] << endl;
   fout.close();
*/
      return job;
}

protected void Send(Result result)
{
   Buffer bufptr;
   int i;

   pvm_initsend(PvmDataDefault);

   pvm_pkint(jobID, 1, 1);

   bufptr = result.privateSendBuffer;

   PackBuffer(bufptr);

   pvm_send(parentTid, 2);
}

public void Run(Worker worker)
{
   Job job;
   Result result;

   while(true)
   {
      job = Receive();
      if(jobID[0] == -1)
      {
      }
      else
      {
         result = worker.run(job);
         Send(result);
      }
   }
}

public void PackBuffer(Buffer bufptr)
{

   int i;

   int inttmp[] = new int[1];
   inttmp[0] = bufptr.intcnt;
   pvm_pkint(inttmp, 1, 1);
   if(bufptr.intcnt != 0)
      for(i=0; i<bufptr.intcnt; i++)
      {
         int numtmp[] = new int[1];
         numtmp[0] = bufptr.intnum[i];
         pvm_pkint(numtmp, 1, 1);
	 pvm_pkint(bufptr.intptr[i], bufptr.intnum[i], 1);
      }

   int flttmp[] = new int[1];
   flttmp[0] = bufptr.floatcnt;
   pvm_pkint(flttmp, 1, 1);
   if(bufptr.floatcnt != 0)
      for(i=0; i<bufptr.floatcnt; i++)
      {
         int numtmp[] = new int[1];
         numtmp[0] = bufptr.floatnum[i];
         pvm_pkint(numtmp, 1, 1);
	 pvm_pkfloat(bufptr.floatptr[i], bufptr.floatnum[i], 1);
      }
/*
   int clxtmp[] = new int[1];
   clxtmp[0] = bufptr.complexcnt;
   pvm_pkint(clxtmp, 1, 1);
   if(bufptr.complexcnt != 0)
      for(i=0; i<bufptr.complexcnt; i++)
      {
         int numtmp[] = new int[1];
         numtmp[0] = bufptr.complexnum[i];
         pvm_pkint(numtmp, 1, 1);
	 pvm_pkcplx((float[])bufptr.complexptr[i], bufptr.complexnum[i], 1);
      }
*/
   int strtmp[] = new int[1];
   strtmp[0] = bufptr.strcnt;
   pvm_pkint(strtmp, 1, 1);
   if(bufptr.strcnt != 0)
      for(i=0; i<bufptr.strcnt; i++)
      {
         pvm_pkstr(bufptr.strptr[i]);
      }
}

// Utility Function
public void UnpackBuffer(Buffer bufptr)
{
   int i;

   int inttmp[] = new int[1];
   pvm_upkint(inttmp, 1, 1);
   bufptr.intcnt = inttmp[0];
   if(bufptr.intcnt != 0)
       for(i=0; i<bufptr.intcnt; i++)
       {
          int numtmp[] = new int[1];
          pvm_upkint(numtmp, 1, 1);
          bufptr.intnum[i] = numtmp[0];
          bufptr.intptr[i] = new int[bufptr.intnum[i]];
	  pvm_upkint(bufptr.intptr[i], bufptr.intnum[i], 1);
       }

   int flttmp[] = new int[1];
   pvm_upkint(flttmp, 1, 1);
   bufptr.floatcnt = flttmp[0];
   if(bufptr.floatcnt != 0)
      for(i=0; i<bufptr.floatcnt; i++)
      {
          int numtmp[] = new int[1];
          pvm_upkint(numtmp, 1, 1);
          bufptr.floatnum[i] = numtmp[0];
          bufptr.floatptr[i] = new float[bufptr.floatnum[i]];
          pvm_upkfloat(bufptr.floatptr[i], bufptr.floatnum[i], 1);
      }
/*
       pvm_upkint(&(bufptr->complexcnt), 1, 1);
       if(bufptr->complexcnt != 0)
	  for(i=0; i<bufptr->complexcnt; i++)
	  {
	     pvm_upkint(&(bufptr->complexnum[i]), 1, 1);
	     bufptr->complexptr[i] = new Complex[bufptr->complexnum[i]];
	     pvm_upkcplx((float *)bufptr->complexptr[i], bufptr->complexnum[i], 1);
          }
*/
   int strtmp[] = new int[1];
   pvm_upkint(strtmp, 1, 1);
   bufptr.strcnt = strtmp[0];
   if(bufptr.strcnt != 0)
      for(i=0; i<bufptr.strcnt; i++)
      {
         char chartmp[] = new char[MAXSTRLENGTH];
         pvm_upkstr(chartmp);
         bufptr.strptr[i] = new String(chartmp);
      }
}

}

