/**********************************************************************
 * Note: 							      *
 *		This code is based on the one we did in cs270 class   *
 *		with modifications. The main frame of the code was    *
 *		given by the cs270 instructor Mr. Anderson            *
 *								      *
 *								      *
 *  Class:							      *
 *  	  ListNode						      *
 *	  List							      *
 *	  ListIterator						      *
 *								      *
 *	                                                              *
 *  Functions and overloading in Class: 			      *
 *								      *
 *	ListNode						      *
 *								      *
 *		getData()	- Get the value of node date	      *
 * 		setData()	- Set the value of node data	      *
 *		==		- Overload to judge if equal?	      *
 *								      *
 *	List							      *
 *								      *
 *		Delete()	- Delete the list nodes		      *
 *		InsertAtFront()	- Insert the node at front	      *
 *		InsertAtBack()	- Insert the node at back	      *
 *		RemoveFromFront()-Remove node from front	      *
 *		RemoveFromBack()- Remove node from back		      *
 *		isEmpty()	- Test whether the list is empty      *
 *		==		- Overload to judge if equal? 	      *
 *		!=		- Overload to judge if not equal?     *
 *		<=		- Overload to judge if less or 	      *
 *				  equal? 	 		      *
 *		=		- Assignment overload		      *
 *		contains()	- To test whether one element in      *
 *				  list				      *
 *		count()		- count the node number of list	      *
 *								      *
 *	ListIterator						      *
 *								      *
 *		==		- Overload to judge if equal?	      *
 *		!= 		- Overload to judge if not equal?     *
 *		= 		- Assignment overload		      *
 *		Next()		- Move the pointer to next node	      *
 *		Prev()		- Move the pointer to the previous    *
 *				  node				      *
 *		getData()	- Get the data of the node pointer    *
 * 		setData()	- Set the data of the node pointer    *
 *		First()		- Set the node pointer at the list    *
 *				  head				      *
 *		Last()		- Set the node pointer at the tail    *
 *				  of the list			      *
 *		Valid()		- Test if the node pointer is NULL    *
 *								      *
 *								      * 
 **********************************************************************/
#ifndef LIST_CC
#define LIST_CC

#include "list.h"

/**********************************************************************
 *                                                                    *
 * Functions for ListNode Class:                               	      *
 *                                                                    * 
 *		ListNode()	- Copy constructor		      *
 *		getData()	- Get the value of node date	      *
 * 		setData()	- Set the value of node data	      *
 *		==		- Overload to judge if equal?	      *
 *                                                                    *
 * Description:	This class defines the content of the list node and   *
 *		gives some basic operation functions in class	      *
 *								      *
 **********************************************************************/ 
template<class T>
ListNode<T>::ListNode( T &info) {
  data    = info;
  nextPtr = NULL;
  prevPtr = NULL;
}

template<class T>
T & ListNode<T>::getData()  { return data; }

template<class T>
void ListNode<T>::setData( T &value) { data = value; }

template<class T>
int ListNode<T>::operator==( ListNode<T> &RHS)  {
  if(data == RHS.data) return 1;
  return 0;
}

/**********************************************************************
 *                                                                    *
 * Functions for Class List:                                  	      *
 *								      *
 *		List()		- Default constructor		      *
 *		Delete()	- Delete the list nodes		      *
 *		InsertAtFront()	- Insert the node at front	      *
 *		InsertAtBack()	- Insert the node at back	      *
 *		RemoveFromFront()-Remove node from front	      *
 *		isEmpty()	- Test whether the list is empty      *
 *		==		- Overload to judge if equal? 	      *
 *		!=		- Overload to judge if not equal?     *
 *		<=		- Overload to judge if less or 	      *
 *				  equal? 	 		      *
 *		=		- Assignment overload		      *
 *		contains()	- To test whether one element in      *
 *				  list				      *
 *		count()		- count the node number of list	      *
 *								      * 
 * Description:	This class keeps control of the head and tail of the  *
 *		list and offers some node adding and removing  	      *
 *		function to make the list operation easoer.	      *
 *								      *
 **********************************************************************/
template<class T>
List<T>::List(void) { firstPtr = lastPtr = NULL; NodeCount = 0; }

template<class T>
List<T>::~List() {
//  printf("~List\n");
//  fflush(stdout);
//  Delete();
//  printf("~List over\n");
//  fflush(stdout);
}

template<class T>
void List<T>::Delete(void) {
  if (!isEmpty()) {
    ListNode<T> *currentPtr = firstPtr, *tempPtr;
    while(currentPtr != NULL) {
      tempPtr    = currentPtr;
      currentPtr = currentPtr->nextPtr;
      delete tempPtr;
    }
  }
  firstPtr  = lastPtr = NULL;
  NodeCount = 0;
}

template<class T>
int List<T>::isEmpty()  { return firstPtr == NULL; }

template<class T>
ListNode<T> *List<T>::getNewNode( T &value) {
  ListNode<T> *ptr = new ListNode<T>(value);
  assert(ptr != NULL);
  return ptr;
}

template<class T>
int List<T>::operator ==( List<T> &RHS)  {
  if(*this <= RHS && RHS <= *this) return 1;
  else                             return 0;
}

template<class T>
int List<T>::operator !=( List<T> &RHS)  {
  return !(*this == RHS);
}

template<class T>
int List<T>::operator <=( List<T> &RHS)  {
  ListNode<T> *Temp = firstPtr;
  while(Temp != NULL) {
    if(!RHS.contains(*Temp)) return 0;
    Temp = Temp->nextPtr;
  }
  return 1;
}

template<class T>
int List<T>::contains( ListNode<T> &value)  {
  ListNode<T> *Temp = firstPtr;
  while(Temp != NULL) {
    if(*Temp == value) return 1;
    Temp = Temp->nextPtr;
  }
  return 0;
}

template<class T>
void List<T>::Print(void) {
  ListNode<T> *Temp = firstPtr;
  while(Temp != NULL) {
    Temp->Print();
    Temp = Temp->nextPtr;
  }
}

template<class T>
void List<T>::InsertAtFront( T &value) {
  ListNode<T> *newPtr = getNewNode(value);
  NodeCount++;
  if(isEmpty()) firstPtr = lastPtr = newPtr;
  else {
    newPtr->nextPtr   = firstPtr;
    firstPtr->prevPtr = newPtr;
    firstPtr          = newPtr;
  }
}

template<class T>
void List<T>::InsertAtBack( T &value) {
  ListNode<T> *newPtr = getNewNode(value);
  NodeCount++;
  if(isEmpty()) { firstPtr = lastPtr = newPtr; }
  else {
    lastPtr->nextPtr = newPtr;
    newPtr->prevPtr  = lastPtr;
    lastPtr          = newPtr;
  }
}

template<class T>
int List<T>::InsertAtBackDistinct( T &value) {
   ListNode<T> A(value); 
  if(contains(A)) return 0;
  InsertAtBack(value);
  return 1;
}

template<class T>
int List<T>::RemoveFromFront(T &value) {
  if(isEmpty()) return 0;
  else {
    ListNode<T> *tempPtr = firstPtr;

    if(firstPtr == lastPtr) firstPtr = lastPtr = NULL;
    else {
      firstPtr          = firstPtr->nextPtr;
      firstPtr->prevPtr = NULL;
    }

    value = tempPtr->data;
    delete  tempPtr;
    NodeCount--;
    return 1;
  }
}

template<class T>
int List<T>::RemoveFromBack(T &value) {
  if(isEmpty()) return 0;
  else {
    ListNode<T> *tempPtr = lastPtr;

    if(firstPtr == lastPtr) firstPtr = lastPtr = NULL;
    else {
      lastPtr          = lastPtr->prevPtr;
      lastPtr->nextPtr = NULL;
    }

    value = tempPtr->data;
    delete  tempPtr;
    NodeCount--;
    return 1;
  }
}

template<class T>
int List<T>::count(void)  {
  return NodeCount;
}

template<class T>
void List<T>::Append( List<T> &RHS) {
  ListNode<T> *currentPtr = RHS.firstPtr;
  while(currentPtr != NULL) {
    InsertAtBack(currentPtr->getData());
    currentPtr = currentPtr->nextPtr;
  }
}

template<class T>
void List<T>::AppendDistinct( List<T> &RHS) {
  ListNode<T> *currentPtr = RHS.firstPtr;
  while(currentPtr != NULL) {
    InsertAtBackDistinct(currentPtr->getData());
    currentPtr = currentPtr->nextPtr;
  }
}

template<class T>
List<T> & List<T>::operator=( List<T> &RHS) {
//printf("List<T>::operator= start\n");
fflush(stdout);
  T temp;
  Delete();
//printf("List<T>::operator= middle\n");
fflush(stdout);

  ListNode<T> *currentPtr = RHS.firstPtr;
  while(currentPtr != NULL) {
    temp = currentPtr->getData();
    InsertAtBack(temp);
    currentPtr = currentPtr->nextPtr;
  }
//printf("List<T>::operator= end\n");
fflush(stdout);
  return *this;
}


//add item here
/**********************************************************************
 *                                                                    *
 * Functions for Class ListIterator:                          	      *
 *								      *
 * 		ListIterator()	- 1. Default constructor	      *
 *				  2. Copy constructor		      *
 *				  3. List initial constructor	      *
 *		==		- Overload to judge if equal?	      *
 *		!= 		- Overload to judge if not equal?     *
 *		= 		- Assignment overload		      *
 *		Next()		- Move the pointer to next node	      *
 *		Prev()		- Move the pointer to the previous    *
 *				  node				      *
 *		getData()	- Get the data of the node pointer    *
 * 		setData()	- Set the data of the node pointer    *
 *		First()		- Set the node pointer at the list    *
 *				  head				      *
 *		Last()		- Set the node pointer at the tail    *
 *				  of the list			      *
 *		Valid()		- Test if the node pointer is NULL    *
 *								      *
 *                                                                    *
 * Description: This class gives the scanning node pointer and 	      *
 *		the related scaning functions to make the list        *
 *              search and other operations easier                    *
 *				                                      *
 **********************************************************************/
template<class T>
ListIterator<T>::ListIterator() { 
   ListIterator::ListPtr  = NULL;
                  NodePtr = NULL;}

template<class T>
ListIterator<T>::ListIterator(List<T> *ListPtr) {
  ListIterator::ListPtr = ListPtr;
  NodePtr = ListPtr->firstPtr;
}

template<class T>
ListIterator<T>::ListIterator( ListIterator<T> &Other) {
  *this = Other;
}

template<class T>
ListIterator<T> & ListIterator<T>::operator= ( ListIterator<T> &RHS) {
  ListPtr = RHS.ListPtr;
  NodePtr = RHS.NodePtr;
  return *this;
}

template<class T>
int ListIterator<T>::operator == ( ListIterator<T> &RHS)  {
  if(NodePtr == RHS.NodePtr) return 1;
  return 0;
}

template<class T>
int ListIterator<T>::operator != ( ListIterator<T> &RHS)  {
  return(!(*this == RHS));
}

template<class T>
int ListIterator<T>::getData(T &value) {
  if(NodePtr == NULL) return 1;
  value = NodePtr->getData();
  return 0;
}

template<class T>
int ListIterator<T>::setData(T &value) {
  if(NodePtr == NULL) return 1;
  NodePtr->setData(value);
  return 0;
}

template<class T>
int ListIterator<T>::Next(void) {
  if(NodePtr->nextPtr == NULL) return 0;
  NodePtr = NodePtr->nextPtr;
  return 1;
}

template<class T>
int ListIterator<T>::Prev(void) {
  if(NodePtr->prevPtr == NULL) return 0;
  NodePtr = NodePtr->prevPtr;
  return 1;
}

template<class T>
int ListIterator<T>::First(void) {
  NodePtr = ListPtr->firstPtr;
  return 0;
}

template<class T>
int ListIterator<T>::Last(void) {
  NodePtr = ListPtr->lastPtr;
  return 0;
}

template<class T>
int ListIterator<T>::Remove(T &value) {
  if(NodePtr == NULL) return 1;
  if(NodePtr->prevPtr == NULL && NodePtr->nextPtr == NULL) {
    ListPtr->firstPtr = NULL;
    ListPtr->lastPtr = NULL;
    value = NodePtr->getData();
    delete NodePtr;
    NodePtr = NULL;
    ListPtr->NodeCount--;
    return 0;
  }
  if(NodePtr->prevPtr != NULL && NodePtr->nextPtr == NULL) {
    ListPtr->lastPtr = NodePtr->prevPtr;
    NodePtr->prevPtr->nextPtr = NULL;
    value = NodePtr->getData();
    delete NodePtr;
    NodePtr = NULL;
    ListPtr->NodeCount--;
    return 0;
  }
  if(NodePtr->prevPtr == NULL && NodePtr->nextPtr != NULL) {
    ListPtr->firstPtr = NodePtr->nextPtr;
    NodePtr->nextPtr->prevPtr = NULL;
    value = NodePtr->getData();
    delete NodePtr;
    NodePtr = NULL;
    ListPtr->NodeCount--;
    return 0;
  }
  if(NodePtr->prevPtr != NULL && NodePtr->nextPtr != NULL) {
    NodePtr->prevPtr->nextPtr = NodePtr->nextPtr;
    NodePtr->nextPtr->prevPtr = NodePtr->prevPtr;
    value = NodePtr->getData();
    delete NodePtr;
    NodePtr = NULL;
    ListPtr->NodeCount--;
    return 0;
  }
  return 1;
}


template<class T>
int ListIterator<T>::Remove(void) {
  if(NodePtr == NULL) return 1;
  if(NodePtr->prevPtr == NULL && NodePtr->nextPtr == NULL) {
    ListPtr->firstPtr = NULL;
    ListPtr->lastPtr = NULL;
    delete NodePtr;
    NodePtr       = NULL;
    ListPtr->NodeCount--;
    return 0;
  }
  if(NodePtr->prevPtr != NULL && NodePtr->nextPtr == NULL) {
    ListPtr->lastPtr = NodePtr->prevPtr;
    NodePtr->prevPtr->nextPtr = NULL;
    delete NodePtr;
    NodePtr       = NULL;
    ListPtr->NodeCount--;
    return 0;
  }
  if(NodePtr->prevPtr == NULL && NodePtr->nextPtr != NULL) {
    ListPtr->firstPtr = NodePtr->nextPtr;
    NodePtr->nextPtr->prevPtr = NULL;
    delete NodePtr;
    NodePtr = NULL;
    ListPtr->NodeCount--;
    return 0;
  }
  if(NodePtr->prevPtr != NULL && NodePtr->nextPtr != NULL) {
    NodePtr->prevPtr->nextPtr = NodePtr->nextPtr;
    NodePtr->nextPtr->prevPtr = NodePtr->prevPtr;
    delete NodePtr;
    NodePtr = NULL;
    ListPtr->NodeCount--;
    return 0;
  }
  return 1;
}

template<class T>
int ListIterator<T>::InsertAfter( T &value) {
  if(NodePtr == NULL) return 1;
  ListNode<T> *newPtr = ListPtr->getNewNode(value);
  newPtr->nextPtr  =  NodePtr->nextPtr;
  newPtr->prevPtr  =  NodePtr;
  newPtr->prevPtr->nextPtr = newPtr;
  if(newPtr->nextPtr != NULL) newPtr->nextPtr->prevPtr = newPtr;
  else ListPtr->lastPtr = newPtr;
  ListPtr->NodeCount++;
  return 0;
}

template<class T>
int ListIterator<T>::InsertBefore( T &value) {
  if(NodePtr == NULL) return 1;
  ListNode<T> *newPtr = ListPtr->getNewNode(value);
  newPtr->prevPtr  =  NodePtr->prevPtr;
  newPtr->nextPtr  =  NodePtr;
  newPtr->nextPtr->prevPtr = newPtr;
  if(newPtr->prevPtr != NULL) newPtr->prevPtr->nextPtr = newPtr;
  else ListPtr->firstPtr = newPtr;
  ListPtr->NodeCount++;
  return 0;
}

#endif


