// Worker Program
// The worker receives a job requesting the sum of a range of numbers.
// It calculates that sum and returns the result in the job package.

import java.io.*;

public class Worker
{
   Worker()
   {
      try 
      {
        DataOutputStream fileout = new DataOutputStream(new FileOutputStream("result"));
        fileout.writeChars("I am in the class --- Worker" + "\n");
        fileout.close();
      }
      catch(IOException e)
      {
         System.exit(1);
      }
   }
      
   public Result run(Job job)
   {
      int number;
      int countOfDataNumber;
      int startNumber[] = new int[1];
      int dataNumber[] = new int[1];
      int sum[] = new int[1];

      Result result = new Result();

// Unpack startNumber and dataNumber.
      job.privateReceiveBuffer.UnpackInt(startNumber, 1);
      job.privateReceiveBuffer.UnpackInt(dataNumber, 1);


// Calculate.
      sum[0] = 0;
      number = startNumber[0];
      for(countOfDataNumber=0;countOfDataNumber<dataNumber[0];countOfDataNumber++)
      {
         sum[0] += number;
         number++;
      }

// Pack sum.
      result.privateSendBuffer.PackInt(sum, 1);

      return result;
   }
}
