/* Worker Program
 The worker receives a job requesting the sum of a range of numbers.
 It calculates that sum and returns the result in the job package.
*/

#include "jobpool_c.h"

Result* worker(Job *);

main()
{

/* Create jobAgent */ 
   JobAgent *jobAgent;

   jobAgent = (JobAgent *) malloc(sizeof(JobAgent));
   InitJobAgent(jobAgent);

/* Run jobAgent */
   RunJobAgent(jobAgent, worker);

}

Result* worker(Job *job)
{
   int number, startNumber, dataNumber, sum;
   int countOfDataNumber;
   Result *result = (Result *) malloc(sizeof(Result));
   
   InitResult(result, OUTOF_PLACE);

/* Unpack startNumber and dataNumber. */
   UnpackInt(job->privateReceiveBuffer, &startNumber, 1);
   UnpackInt(job->privateReceiveBuffer, &dataNumber, 1);


/* Calculate. */
   sum = 0;
   number = startNumber;
   for(countOfDataNumber=0; countOfDataNumber<dataNumber; countOfDataNumber++)
   {
         sum += number;
         number++;
   }

/* Pack sum. */
   PackInt(result->privateSendBuffer, &sum, 1);

   return result;

}
