/* Sample application main program

 This program adds the numbers from 1 to n by partitioning this range into
 groups of size DATANUMBER, each of which is packaged as a separate job to
 be independently calculated.
*/

#include <stdio.h>
#include "jobpool_c.h"

#define DATANUMBER 10    /* size of data groups */

main()
{
   Job *jobs;
   Result *results;
   int startNumber, dataNumber;
   int lastNumber;
   JobNumber jobNumber;
   CheckTime checkTime; /* how many seconds between checking liveness of workers*/
   int partialSum, sum;
   int countOfJobNumber;
   int counter;
   static JobManager *jobManager;

   printf("Calculate: 1+2+3+ ... +N = ? \n");
   printf("Please input N \n");
   scanf("%d", &lastNumber); 

/* How many jobs? */ 
   jobNumber = lastNumber/DATANUMBER;
   jobs = (Job *) malloc(sizeof(Job)*(jobNumber+1));
   for(counter=0; counter<jobNumber+1; counter++)
      InitJob(&(jobs[counter]), OUTOF_PLACE);

/* Pack startNumber and dataNumber into job buffers. */
   startNumber = 1;
   dataNumber = DATANUMBER;
   for(countOfJobNumber=0; countOfJobNumber<jobNumber; countOfJobNumber++)
   {
      SetJobName(&(jobs[countOfJobNumber]), "worker");
      PackInt(jobs[countOfJobNumber].privateSendBuffer, &startNumber, 1);
      PackInt(jobs[countOfJobNumber].privateSendBuffer, &dataNumber, 1);
      startNumber += DATANUMBER;
   }

/* If the data number in the last job is less than DATANUMBER, pack the
 startNumber and dataNumber here.  */
   if(startNumber <= lastNumber || lastNumber == 1)
   {
      dataNumber=lastNumber - startNumber + 1;
      SetJobName(&(jobs[jobNumber]), "worker");
      PackInt(jobs[jobNumber].privateSendBuffer, &startNumber, 1);
      PackInt(jobs[jobNumber].privateSendBuffer, &dataNumber, 1);
      jobNumber++;
   }
     
/* How frequently we check if machines are still alive (in seconds) */
   checkTime = 1;

/* Create jobManager. */
      jobManager = (JobManager *) malloc(sizeof(JobManager));

   InitJobManager(
      jobManager, /* pointer to jobManager */
      jobs, /* array of work */
      jobNumber, /* length of work array */
      NULL, /* we aren't using a broadcast buffer */
      NICE, /* only one agent on a machine */
      HIGH, /* re-send outstanding work to machines that finish */
      AUTOSTART, /* start PVM if it is not already running */
      checkTime /* how often to check if machines are still running */
   );

/* Run jobManager and get results. */ 
   results = RunJobManager(jobManager);

/* Add all partial sums to get the total sum. */
   sum = 0;
   for(countOfJobNumber=0; countOfJobNumber<jobNumber; countOfJobNumber++)
   {
      UnpackInt(results[countOfJobNumber].privateReceiveBuffer, &partialSum, 1);
      sum += partialSum;
   }

/* Print out the sum. */
   printf("\n Sum = %d \n", sum);

   return 0;
}
