/* machinelist.c */
#ifndef MACHINELIST_C
#define MACHINELIST_C
#include <stdlib.h>
#include "machinelist_c.h"

void InitMachineNode(MachineNode *machineNode)
{
   machineNode->machine = NULL;
   machineNode->nextMachineNode = NULL;
}

void InitMachineList(MachineList *machineList)
{
   machineList->firstNode = NULL;
   machineList->lastNode = NULL;
   machineList->listCount=0;
}	
	
	
/* Add new node into MachineList */
void AddNewMachine(MachineList *machineList, Machine *machine)
{
   MachineNode *tmpMachineNode;
   tmpMachineNode = malloc(sizeof(MachineNode));
   InitMachineNode(tmpMachineNode);
   tmpMachineNode->machine = machine;

   if(machineList->listCount == 0)
   {
      machineList->firstNode = tmpMachineNode;
      machineList->lastNode = tmpMachineNode;
   }
   else
   {
      machineList->lastNode->nextMachineNode = tmpMachineNode;
      machineList->lastNode = tmpMachineNode;
   }
      
   machineList->listCount++;
}

Machine *RemoveMachine(MachineList *machineList) 
{
   MachineNode *tmpMachineNode;
   Machine *machine;

   if(machineList->listCount == 0)
   {
      machine = NULL;
      return machine;
   }
   else
   {
      tmpMachineNode = machineList->firstNode;
      machine = tmpMachineNode->machine;
      machineList->firstNode = tmpMachineNode->nextMachineNode;
      free(tmpMachineNode); 
   }
   machineList->listCount--;
   if(machineList->listCount == 0)
      machineList->lastNode = NULL;
   return machine;
}

int isEmpty(MachineList *machineList)
{
   if(machineList->listCount == 0)
      return 1;
   else
      return 0;
}
#endif
