//package DatabaseExplorer;

import java.io.*;
import java.util.*;
import java.lang.*;
import java.sql.*;

public class DriverlistManager
{
//   static String filename = "DatabaseExplorer/driverlist.log";
   static String filename = "driverlist.log";

// This method is used to print out any information.
   public static void printMsg (String msg)
   {
	System.out.println(msg); 
   }

// This methods returns a Vector containing a list of all available
// drivers' names.

   public static Vector getDriverList()
   {
	FileInputStream file;

	Vector driverlist = new Vector();
	try{
	   file = new FileInputStream(filename);
	   ObjectInputStream objectIn = new ObjectInputStream(file);
	   driverlist = (Vector)(objectIn.readObject());
        } //try block
	catch (Exception e){
	   printMsg(e.getMessage());
	   printMsg("Can not read driverlist.log");	   
	}
	return driverlist;
   }  

// This method is used to print the list of drivers available.
   public static void printDriverList(Vector driverlist)
   {
        int num = 1;
	for(int i=0; i<driverlist.size(); i++)
	{
	   printMsg(num + ". "+ driverlist.elementAt(i));
           num ++;
	}
   }

// This method is used to save the list of drivers to the driverlist.log file.

   public static void setDriverList(Vector driverlist)
   {
	try{
	   FileOutputStream fileOut = new FileOutputStream(filename);
	      ObjectOutputStream objectOut = new ObjectOutputStream(fileOut);
	      objectOut.writeObject(driverlist);
	      objectOut.flush();
	      objectOut.close();
	      fileOut.close();
 	}// try block
	catch (Exception e)
	{
	   printMsg(e.getMessage());
	   printMsg("Save list error");
	} //catch block
	
//	printMsg("\nDriver list has been updated !");
	printDriverList(driverlist);
   }
  
// this method is used to print the usage of DriverlistManager.
   public static void DriverlistManagerUsage()
   {
	printMsg("DriverlistManager Usage: \n  DriverlistManager add <driver name>");
	printMsg("\n  DriverlistManager list \n  DriverlistManager delete\n");
        printMsg("\n  DriverlistManager update\n");
   }
   
// The main is a command line interface.
   public static void main (String argv[])
   {
	Vector driverlist = new Vector();
	if (argv.length<1)
	{
	   DriverlistManagerUsage();
	}
	else
	{
	   if (argv[0].equals("add"))
	   {
		driverlist = getDriverList();
		driverlist.addElement(argv[1]);
		setDriverList(driverlist);
		printMsg("The Driver has been added");
	   }
	   else if (argv[0].equals("list"))
	   {
		printMsg("The drivers are as follows:\n");
		driverlist = getDriverList();
		printDriverList(driverlist);
	   }	
	   else if (argv[0].equals("delete"))
	   {
		driverlist = getDriverList();
		printDriverList(driverlist);
		printMsg("Which driver number do you want to delete?");
		int num = (Integer.parseInt(getInput()));
		if (num <= driverlist.size())
		{
		   driverlist.removeElementAt(num-1);
		   setDriverList(driverlist);
		   printMsg("The Driver at line "+ num + " has been deleted\n");
		}
		else
		   printMsg("The line number you inputed is invalid!");
	   }//else if
	   else if (argv[0].equals("update"))
	   {
		driverlist = getDriverList();
		printDriverList(driverlist);
		printMsg("Which driver number do you want to update?");
		int num = (Integer.parseInt(getInput()));
		if (num <= driverlist.size())
		{
		   driverlist.removeElementAt(num-1);
  		   printMsg("What do you want tp update to?");
                   String after = getInput();
		   driverlist.insertElementAt(after, num-1);
		   setDriverList(driverlist);
       	           printDriverList(driverlist);
		   printMsg("The Driver at line "+ num + " has been updated\n");
		}
		else
		   printMsg("The line number you inputed is invalid!");
	   }//else if
           else{
		printMsg("Command " + argv[0] + " not found.");
		DriverlistManagerUsage();
	   }
	}//else 
   }//main

// This method is used to get user input from command line
   public static String getInput()
   {
        String linein = new String();
	try{
	   BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	   linein = input.readLine();
	}//try block
	catch (Exception e){
	   printMsg(e.getMessage());
	}//catch block
        return linein;
   }
}
