//package DatabaseExplorer;

import java.lang.*;
import java.util.*;
import java.sql.*;

public class DatabaseAccess
{
   String errorMsg = new String();
   String URL;
   Properties loginProperties;
   Connection conn;
   ResultSet rs;

// Constractor
   public DatabaseAccess()
   {
	Vector driverlist = DriverlistManager.getDriverList();
	if(driverlist.isEmpty())
        {
	   setErrorMessage("Driver list is empty," + 
		" please contact the system administrator to add driver name.");
	} //if block
	else
   	{
	   for(int i=0; i< driverlist.size(); i++)
	   {
		try{
		   Class.forName((String)driverlist.elementAt(i));
		   printMsg("Driver " + (String)driverlist.elementAt(i) + " loaded");
		} //try block
		catch (Exception e){
		   setErrorMessage("Driver loading error! ");
		} //catch block
	   } //for loop
	}//else block
   }//DatabaseAccess

// This method is used to get login properties.
   public synchronized DataTable getLoginProperties()
   {
	Vector[] props = new Vector[3];
        String headings[] = {"Login Properties ", "Values "};
        String labels[] = {"Database URL:", "User ID:", "Password:"};
	for(int i=0; i<3; i++)
        {
	   props[i] = new Vector();
	   props[i].addElement(labels[i]);
	} //for loop
	props[0].addElement(URL);
	props[1].addElement(loginProperties.getProperty("user"));
	props[2].addElement("********");

	DataTable dt = new DataTable(props, headings);
	printMsg("Login Properties: " + props);
	return dt;
   } //getLoginProperties

// This method is used to set login properties.
   private void setLoginProperties(String url, String user, String password)
   {
	loginProperties = new Properties();
	URL = url;
        loginProperties.put("user",user);
        loginProperties.put("passwd", password);
   } //setLoginProperties

// This method returns a DataTable object which has information related to RDBMS product.
   public synchronized DataTable getRDBMSinfo()
   {
	Vector[] dbmsinfo = new Vector[3];
        String labels[] = {"DataBase Product Name", "Version Number", "DataBase URL"};
	String headings[] = {"DataBase Information ", "Value "};
	
	for(int i=0; i<3; i++)
	{
	   dbmsinfo[i] = new Vector();
	   dbmsinfo[i].addElement(labels[i]);
	} //for loop

 	try{
	   DatabaseMetaData dbmd = conn.getMetaData();
	   dbmsinfo[0].addElement(dbmd.getDatabaseProductName());
	   dbmsinfo[1].addElement(dbmd.getDatabaseProductVersion());
	   dbmsinfo[2].addElement(dbmd.getURL());
	} //try block
	catch (SQLException e){
	   setErrorMessage("getRDBMSinfo Error: " + e.getMessage());
	} //catch
	
	DataTable dt = new DataTable(dbmsinfo, headings);
	return dt;

   } //getRDBMSinfo

// This method is used to return information related to driver.
   public synchronized DataTable getDriverInfo()
   {
	Vector[] dbmsinfo = new Vector[2];
	String headings[] = {"Description ", "Value "};
	String labels[] = {"Driver Name", "Version Number"};
	
	for(int i=0; i<2; i++)
	{
	   dbmsinfo[i] = new Vector();
	   dbmsinfo[i].addElement(labels[i]);
	} //for loop

	try{
	   DatabaseMetaData dbmd = conn.getMetaData();
	   dbmsinfo[0].addElement(dbmd.getDriverName());
	   dbmsinfo[1].addElement(dbmd.getDriverVersion());
	} //try block
	catch (SQLException e){
	   setErrorMessage ("getDriverInfo failed: " + e.getMessage());
	}
	DataTable dt = new DataTable(dbmsinfo, headings);

	return dt;
   } //getDriverInfo

// This method is used to get the information about upported SQL level.
   public synchronized DataTable getSQLLevelInfo()
   {
	Vector[] dbmsinfo = new Vector[3];
	String headings[] = {"SQL92 Level supported", " "};
	String labels[] = {"SQL92 Entry Level", "SQL92 Intermediate Level", 
			  "SQL92 Full Level"};
	for (int i=0; i<3; i++)
	{
	   dbmsinfo[i] = new Vector();
	   dbmsinfo[i].addElement(labels[i]);
	} //for block

	try{
	   DatabaseMetaData dbmd = conn.getMetaData();
	   dbmsinfo[0].addElement(new Boolean (dbmd.supportsANSI92EntryLevelSQL()));
	   dbmsinfo[1].addElement(new Boolean (dbmd.supportsANSI92IntermediateSQL()));
	   dbmsinfo[2].addElement(new Boolean (dbmd.supportsANSI92FullSQL()));
	} //try block
	catch (SQLException e){
	   setErrorMessage("getSQLLevel failed: " + e.getMessage());
	}

	DataTable dt = new DataTable(dbmsinfo, headings);

	return dt;
   }// getSQLLevelInfo

// This method is to return a list of all catalogs available in the
// current database.
   public synchronized Vector getCatalogNames()
   {
	Vector catalog = new Vector();
	try{
	   DatabaseMetaData dbmd = conn.getMetaData();
	   if(dbmd.supportsCatalogsInTableDefinitions())
	   {
	      ResultSet catalogrs = dbmd.getCatalogs();
	      while (catalogrs.next())
	      {
		catalog.addElement(catalogrs.getString("TABLE_CAT"));
	      }
	   } //if block
	   else{
	      catalog.addElement("");
	      printMsg("Catalog is not supported.");
	   }
	} //try block
	catch (SQLException e)
	{
	   setErrorMessage("getCatalogNames failed: " + e.getMessage());
	} //catch block
	
	return catalog;

   } //getCatalogNames

// This method returns a list of schemas in the database.
   public synchronized Vector getSchemaNames()
   {
	Vector schema = new Vector();
	try {
	   DatabaseMetaData dbmd = conn.getMetaData();
	   ResultSet schemars = dbmd.getSchemas();
	   while(schemars.next())
	   {
		schema.addElement(schemars.getString("TABLE_SCHEM"));
	   } //while loop
	} //try block
	catch (SQLException e)
	{
	   setErrorMessage("getSchemNames failed: " + e.getMessage());
	} //catch block

	return schema;

   }// getSchemaNames

// This method is used to get a list of tables in a specific catalog and
// schema.
   public synchronized Vector getTableNames(String catalog, String schema,
	String[] tabletypes)
   {
	Vector table = new Vector();
	ResultSet tablers;
	try{
	   DatabaseMetaData dbmd = conn.getMetaData();
   	   if(catalog.equals("None")){
	      tablers = dbmd.getTables(null, schema, "%", tabletypes);
	   }
	   else{
	      tablers = dbmd.getTables(catalog, schema, "%", tabletypes);
	   }
	   while (tablers.next())
	   {
	      table.addElement(tablers.getString("TABLE_NAME"));
	   } //while
	} //try block
	catch (SQLException e)
	{
	   setErrorMessage("getTableNames failed: " + e.getMessage());
	} //catch block

	return table;

   } //getTableNames

// This method is used to get all the table types accepted in the database.
   public synchronized String[] getTableTypes()
   {
	Vector tmp = new Vector();
	int count;
	try{
	   DatabaseMetaData dbmd = conn.getMetaData();
	   ResultSet tabletypes = dbmd.getTableTypes();
	   while(tabletypes.next())
	   {
		tmp.addElement(tabletypes.getString("TABLE_TYPE"));
	   } //while
	} //try
	catch (SQLException e)
	{
	   setErrorMessage("getTableTypes Error: " + e.getMessage());
	} //catch	

	//convert Vector to String[]
	count = tmp.size();
	String[] types = new String[count];
	for(int i = 0; i< count; i++)
	{
	   types[i] = (String) tmp.elementAt(i);
	} //for loop
	
	return types;

   }  //getTableTypes

// This method is used to execute any SQL statement.
   public synchronized DataTable[] exeSQLstatement(String sql)
   {
	DataTable[] datatables;
  	Vector tmp = new Vector();
	boolean flag = true; //flag is used to test whether has more result 
	int count = -1;
	try{
	System.out.println("sql is: " + sql);
	   Statement stmt = conn.createStatement();
	   stmt.execute(sql);
	   count = stmt.getUpdateCount();
	System.out.println("The update count is: " + count);
	   while( (count>=0)||(flag == true))
	   {
	   	if(count !=-1)
		{
		   Vector[] updatecount = new Vector[1];
		   updatecount[0] = new Vector();
		   updatecount[0].addElement(sql);
		   updatecount[0].addElement(new Integer(count));
		   String headings[] = {"Statement executed successfully", 
			"Number of Rows affected"};
		   tmp.addElement(new DataTable(updatecount, headings));
		   flag = stmt.getMoreResults();
		   count = -1;
		} //if block
		else{
		   rs = stmt.getResultSet();
		   tmp.addElement(new DataTable(rs));
		   flag = stmt.getMoreResults();
		   count = stmt.getUpdateCount();
		} //else block
	   } //while loop
	} //try block
	catch (Exception e){
	   setErrorMessage("Execute SQL statement Error: " + e.getMessage());
	} //catch block

	datatables = new DataTable[tmp.size()];
	for(int i=0; i<tmp.size(); i++)
	{
	   datatables[i] = (DataTable)tmp.elementAt(i);
	} //for loop
	System.out.println("exeSQLstatement function is all right!");
	return datatables;

   }// exeSQLstatement

// This method is used to get all the data in a table.
   public synchronized DataTable selectall(String tablename)
   {
   	DataTable[] dt = exeSQLstatement("select * from " + tablename);
	return dt[0];
   } // 

// This method is used to create a connection to the database.
   public synchronized int openSession(String url, String user, String password)
   {
	URL = url;
	try{
	   conn = DriverManager.getConnection(url, user, password);
	   conn.setAutoCommit(false);
	   return 1;
	} //try block
	catch (SQLException e){
	   setErrorMessage("openSession failed: " + e.getMessage());
	   return -1;
	} //catch
   } // openSession

// This method is used to close coonection to the database.
   public synchronized void closeSession()
   {
	try{
	   conn.close();
	} //try
	catch (SQLException e)
	{
	   setErrorMessage("closeSession failed: " + e.getMessage());
	}
   } //closeSession

// This method is used to issuea SQL commit command to the database.
   public synchronized void setCommit()
   {
	try{
	   conn.commit();
	}
	catch (SQLException e)
	{
	   setErrorMessage("Commit failed!");
	}
   } //setCommit

// This method is used to issue SQL rollback command to the database.
   public synchronized void setRollback()
   {
        try{
           conn.rollback();
        }
        catch (SQLException e)
        {
           setErrorMessage("Rollback failed!");
        }
   } //setRollback

// This method is used to print message or information to the sceen.
   public static void printMsg(String message) 
   {
	System.out.println(message);
   } //printMsg

// This methods is used to get error message.
   public synchronized String getErrorMessage()
   {
	return errorMsg;
   }//getErrorMessage

// This method is used to set error message.
   public void setErrorMessage(String message)
   {
	errorMsg = message;
	printMsg(message);
   } //setErrorMessage
} //DatabaseAcces class


