//package DatabaseExplorer;

import java.util.*;
import java.sql.*;

public class DataTable
{
   Vector[] datatable;
   ResultSet rs;
   ResultSetMetaData rsmd;
   String[] columnnames;
   String errorMsg;
   boolean isMetaTable = false;
   int numOfColumns;
   int numOfRows;
   int maxColumnSize = 50;

// Constructor
// The first constructor is used when a ResultSet is to be converted to a DataTable object.
   
   public DataTable(ResultSet rs)
   {
	this.rs = rs;
	try{
	   rsmd = rs.getMetaData();
	   Vector temp = new Vector();
	   Vector row;
	   Object data = null;
	   numOfColumns = rsmd.getColumnCount();
	   while (rs.next())
	   {
		row = new Vector();
	        for(int i=1; i<=numOfColumns; i++)
		{
		   switch(rsmd.getColumnType(i))
		   {
			case java.sql.Types.BINARY:
			    data = "Binary data truncated";
			    row.addElement(data);
			    break;
			case java.sql.Types.LONGVARBINARY:
			    data = "Long Binary data truncated";
			    row.addElement(data);
			    break;
			default:
			    row.addElement(rs.getObject(i));
		   } //switch
		} //for loop
		temp.addElement(row);
	   } //while loop
	   
	   numOfRows = temp.size();
	   datatable = new Vector[numOfRows];
	   for(int j=0; j< numOfRows; j++)
	   {
		datatable[j] = new Vector();
		for (int k=0; k<((Vector)temp.elementAt(j)).size(); k++)
		   datatable[j].addElement(((Vector)(temp.elementAt(j))).elementAt(k));
	   } //for loop	   
	} //try
	catch (SQLException e)
	{
	   setErrorMessage(e.getMessage());
	} //catch block
   } //DataTable(ResultSet rs)

// The Second constructor is used when data not contained in the ResultSet is used to create the DataTable.
   public DataTable(Vector[] metatable, String[] column)
   {
	datatable = metatable;
	columnnames = column;
	numOfColumns = metatable[0].size();
	numOfRows = metatable.length;
	rs = null;
	isMetaTable = true;
	System.out.println("In DataTable, the numofColumn is " +
		numOfColumns + " The numofrow is " + numOfRows);	
   } //DataTable( , )

// This method is used to get the column title for the column with specified index.
   public synchronized String getColumnTitle(int index)
   {
        String title = new String();
	if(isMetaTable)
           title = columnnames[index-1];
        else{
	   try{
		if (rsmd.getColumnLabel(index) != null)
		   title = rsmd.getColumnLabel(index);
		else if(rsmd.getColumnName(index) != null)
		   title = rsmd.getColumnName(index);
		else
		   title = " ";
	   } //try
	   catch (SQLException e)
	   {
		setErrorMessage("getColumnTitle failed: " + e.getMessage());
	   } //catch
	} //else

	return title;
   } //getColumnTitle

// This method will return an array containing titles for all of the columns.
   public synchronized String[] getColumnTitles()
   {
	String[] titles = new String[numOfColumns];
	if(isMetaTable)
	   titles = columnnames;
	else{
	   for(int i=0; i<numOfColumns; i++)
		titles[i] = getColumnTitle(i+1);
	} //else
	return titles;
   } //getColumnTitles()

// This method returns the data type of the specified column.
   public synchronized int getColumnType( int index)
   {
	int type = Types.CHAR;
	if(!isMetaTable){
	   try{
		type = rsmd.getColumnType(index);
	   } //try
	   catch (SQLException e)
	   {
		setErrorMessage("getColumnType Error: " + e.getMessage());
	   } //catch
	} //if
	return type;
   } //getColumnType   

// This method returns number of columns
   public synchronized int getNumOfColumns()
   {
	return numOfColumns;
   } //getNumOfColumns

// This method returns number of rows.
   public synchronized int getNumOfRows()
   {
	return numOfRows;
   } //getNumOfRows

// This method returns a row in the dataTable.
   public synchronized Vector getRow(int index)
   {
	return datatable[index-1];
   } //getRow

// This method is used to get a column in the dataTable.
   public synchronized Object[] getColumn(int index)
   {
	Object column[] = new Object[numOfRows];
	for(int i=0; i<numOfRows; i++)
	   column[i] = datatable[i].elementAt(index-1);
	return column;
   } //getColumn

// This method returns an individual data cell specified by the row and
// column.
   public synchronized Object getDataAt(int row, int column)
   {
	return datatable[row-1].elementAt(column-1);
   } //getDataAt

// This method is used to print information.
   public static void printMsg(String message)
   {
	System.out.println(message);
   } //printMsg

// Thsi method returns error message.
   public synchronized String getDataTableError()
   {
	return errorMsg;
   } //getDataTableError

// This method is used to set the error message.
   public void setErrorMessage(String message)
   {
     	errorMsg = message;
	printMsg(message);  
   }//setErrorMessage
} //DataTable
