//package DatabaseExplorer;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.util.Enumeration;
import java.sql.*;
import java.rmi.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import javax.swing.table.*;
import javax.swing.border.*;

public class Client 
{
   public static int width = 720;
   public static int height = 600;
   int sID;
   int tID;
   int maxTabs = 12;
   DBAccessInterface dbai = null;
   
   JTabbedPane tabbedPane = new JTabbedPane();
   JPanel mainPanel;
   String username = new String();
   loginWin login;
   MainScreen mainw;

// Constructor of Client.
   public Client()
   {
//  	System.setSecurityManager(new RMISecurityManager());
	login = new loginWin();
	mainw = new MainScreen();
   } //Client constructor

// main method 
   public static void main (String args[]){
	new Client();
   } //main


// This method is used to connect to the RMI server and obtain the reference to the remote
// objects.
   protected int getSessionID(String url, String user, String password)
   {
	int sID = -1;
	try{
/*	   dbai =(DBAccessInterface)Naming.lookup(
		"//sheffield.cslab.uky.edu/remoteServer");
*/	   dbai =(DBAccessInterface)Naming.lookup(
		"//localhost/remoteServer");
	   printMsg("Connect to registry.");
	} //try
	catch (Exception e)
	{
	   printMsg("Can not connect to the registry!");
	   return -1;
	} //catch

	try{
	   sID = dbai.openSession(url,user,password);
	   if(sID == -1)
	   {
		printMsg("Ran out of session ID!");
	   } //if
	   else if (sID == -2)
		printMsg("Login failed!");
	   else;		
	} //try
	catch (Exception e)
	{
	   printMsg("Error in getSessionID: " + e.getMessage());
	   return -1;
	} //catch
	System.out.println("The SID is " + sID);	
	return sID;
   } // getSessionID

// This method is used to set the remote session id for this instance.
   protected void setSessionID(int id)
   {
	sID = id;
   } //setSessionID

// This method is used to print out the message and information.
   public static void printMsg(String message)
   {
	System.out.println(message);
   } 

// The loginWin class is the inner class of Client class. It provides the GUI front end 
// to the getSessionID methods.

   class loginWin extends Frame implements ActionListener
   {
	int sID;
	Dialog dialog;
	TextField userField, passwdField, connField;
	Label status;

   // Constructor for loginWin
 	public loginWin()
	{
	     Frame f = new Frame();
	     f.setFont(new Font("dialog_font",Font.PLAIN, 14));
	     dialog = new Dialog(f, "Login Window", true);  //dialog is modular
	     dialog.setLayout(new BorderLayout());
	    
	     Panel loginPanel = new Panel();
	     Panel buttonPanel = new Panel();
	     GridBagLayout logingb = new GridBagLayout();
	     GridBagConstraints logingbc = new GridBagConstraints();
	     loginPanel.setLayout(logingb);

	     logingbc.gridwidth = 1;
	     logingbc.gridheight = 1;
	     logingbc.gridx = 0;
	     logingbc.gridy = 0;
	     logingbc.anchor = GridBagConstraints.WEST;
	     logingbc.fill = GridBagConstraints.NONE;
	     String labelNames[] = {"Database URL:", 
		"User Name:", "Password:"};
	     Label label[] = new Label[3];
	     for (int i=0; i<3; i++)
		label[i] = new Label(labelNames[i]);
	     loginPanel.add(label[0], logingbc);
	     
	     logingbc.gridx = 1;
	     connField = new TextField(35);
	     loginPanel.add(connField, logingbc);
	
	     logingbc.gridx = 0;
	     logingbc.gridy ++;
	     loginPanel.add(label[1], logingbc);
	
	     logingbc.gridx = 1;
	     userField = new TextField(35);
	     loginPanel.add(userField, logingbc);

	     logingbc.gridx = 0;
	     logingbc.gridy ++;
	     loginPanel.add(label[2],logingbc);
	
	     logingbc.gridx = 1;
	     passwdField = new TextField(35);
	     passwdField.setEchoChar("*".charAt(0));
	     loginPanel.add(passwdField, logingbc);
	
	     logingbc.gridx = 0;
	     logingbc.gridy ++;
	     logingbc.gridwidth = 2;
	     String buttonNames[] = {"Connect", "Clear", "Exit"};
	     Button loginButtons[] = new Button[3];
	     for (int i=0; i<3; i++)
	     {
	        loginButtons[i] = new Button(buttonNames[i]);
		loginButtons[i].setSize(80, 40);
		buttonPanel.add(loginButtons[i]);
		loginButtons[i].addActionListener(this);
	     } //for	     
	     Panel tempPane = new Panel(new BorderLayout());
	     tempPane.setSize(550, 40);
	     tempPane.add("Center", buttonPanel);
	     loginPanel.add(tempPane, logingbc);
	     dialog.add("Center", loginPanel);	
	
	     status = new Label("   ", Label.CENTER);

	     Label header = new Label("Please Enter The Login Information");
	     header.setFont(new Font("header_font",Font.BOLD, 16));
	     Panel headerPanel = new Panel();
	     headerPanel.add(header);
	
	     dialog.add("North", headerPanel);
	     dialog.add("South", status);
	
	     dialog.setSize(550, 250);
	     dialog.setVisible(true);
	} //loginWin() Constructor

        // Event handles for all buttons in the login window.
 	public void actionPerformed(ActionEvent e)
	{
	     if (e.getActionCommand() == "Connect")
	     {
		username = userField.getText().trim();
		sID = getSessionID(connField.getText().trim(), username,
			passwdField.getText().trim());
		if(sID == -1 || sID == -2){
		    setStatus("Login Failed: please try again !");
		    connField.setText("");  
                    userField.setText("");  
                    passwdField.setText("");
		} //if
		else
		{
		    setSessionID(sID);
		    dialog.setVisible(false);
		    dialog.dispose();
		} //else
	     } // if
	     else if(e.getActionCommand() == "Clear")
	     {
		connField.setText("");
		userField.setText("");
		passwdField.setText("");
	     } //else if
	     else if (e.getActionCommand() == "Exit")
	     {
		dialog.setVisible(false);
		dialog.dispose();
		System.exit(0);
	     } // else if
	     else;
	} //actionPerformed

        // This method is used to set the status line.
   	public void setStatus(String message)
	{
	     status.setText(message);
	} //setStatus
   } //loginWin

   // This class is the main screen of the database explorer. It is also
   // a inner class of Client.
   class MainScreen extends JFrame
   {	
	JTree tree;
	JPanel treePanel, toolbarPanel;	
	JMenuBar jmenuBar;
	
	JLabel status;
	public Font defaultFont = new Font("defaultFont", 
		Font.PLAIN,12);
	public Font font1 = new Font("font_1", Font.PLAIN,16);
	Vector tableNames = new Vector();	
	String sql = new String();
        String sql_type[] = {"INTEGER","BIGINT",
	   "SMALLINT", "TINYINT",
	   "CHAR", "VARCHAR", "BINARY", 
	   "FLOAT", "REAL", "NUMERIC",
	   "DATE", "TIME", "TIMESTAMP"};
	DefaultMutableTreeNode[] catalogNodes;
	DefaultMutableTreeNode[] schemaNodes;
	DefaultMutableTreeNode root = null;
	DefaultTreeModel treeModel;
	JButton[] toolbarButtons;

	//constructor of the MainScreen
	public MainScreen()
	{
	   super("Database Explorer");
	   Container c = getContentPane();
	   c.setLayout(new BorderLayout());

	   jmenuBar = createMenu();
	   toolbarPanel = buildToolBar();
	   mainPanel = new JPanel();
	   GridBagLayout gb = new GridBagLayout();
	   GridBagConstraints gc = new GridBagConstraints();
	   mainPanel.setLayout(gb);
	   gc.gridx = 0;
	   gc.gridy = 0;
	   gc.weightx = 1;
	   gc.weighty = 1;
	   gc.fill = GridBagConstraints.BOTH;
	   gc.anchor = GridBagConstraints.WEST;
		
	   treePanel = buildTree();
	   mainPanel.add(treePanel);
	   JLabel welcome = new JLabel(
		new ImageIcon("welcome1_.gif"));
	   welcome.setFont(font1);
	   addTabTo("Welcome", welcome);
	   tabbedPane.setSelectedIndex(0);
	
	   gc.gridx = 1;
	   gc.gridy = 0;
	   gc.weightx = 4;
	   gc.weighty = 1;
	   gb.setConstraints(tabbedPane, gc);
	   mainPanel.add(tabbedPane);

	   setJMenuBar(jmenuBar);
	   c.add("North", toolbarPanel);
	   c.add("Center", mainPanel);
	   status = new JLabel("", JLabel.LEFT);
	   c.add("South", status);
	   setStatus(status, "Login is successful!");

	   setSize(width, height);
	   setVisible(true);
	} // MainScreen

	// This method is used to create the menu bar
	public JMenuBar createMenu()
	{
	   JMenuBar menuBar = new JMenuBar();
	   MenuItemListener menulis = new MenuItemListener();
	   JMenu file = new JMenu("Windows   ");
	   menuBar.add(file);
	   JMenuItem login = new JMenuItem("Login");
	   file.add(login);
	   login.addActionListener(menulis);	   
	   JMenuItem logout = new JMenuItem("Logout");
	   file.add(logout);
	   logout.addActionListener(menulis);
	   file.addSeparator();
	   JMenuItem exit = new JMenuItem("Exit");
           file.add(exit);
           exit.addActionListener(menulis);
	
	   JMenu view = new JMenu("View   ");
           menuBar.add(view);
           JMenuItem db = new JMenuItem("Database Info");
           view.add(db);
           db.addActionListener(menulis);
           JMenuItem driver = new JMenuItem("Driver Info");
           view.add(driver);
           driver.addActionListener(menulis);
           JMenuItem sqlinfo = new JMenuItem("SQL Info");
           view.add(sqlinfo);
           sqlinfo.addActionListener(menulis);

	   JMenu edit = new JMenu("Options   ");
	   menuBar.add(edit);
	   JMenuItem sqlDirect = new JMenuItem("Submit SQL");
	   edit.add(sqlDirect);
	   sqlDirect.addActionListener(menulis);
	   JMenu dml = new JMenu("Data Manipulation");
	   edit.add(dml);
	   JMenuItem query = new JMenuItem("Query");
           dml.add(query);
           query.addActionListener(menulis);
	   JMenuItem insert = new JMenuItem("Insert a row");
	   dml.add(insert);
	   insert.addActionListener(menulis);
	   JMenuItem delete = new JMenuItem("Delete a row");
	   dml.add(delete);
	   delete.addActionListener(menulis);
 	   JMenuItem update = new JMenuItem("Update the data");
           dml.add(update);
           update.addActionListener(menulis);

	   JMenu ddl = new JMenu("Data Definition");
	   edit.add(ddl);
	   JMenuItem create = new JMenuItem("Create new table");
	   ddl.add(create);
	   create.addActionListener(menulis);
	   JMenuItem drop = new JMenuItem("Drop a table");
	   ddl.add(drop);
	   drop.addActionListener(menulis);
	   JMenuItem edit_schema = new JMenuItem("Modify table schema");
           ddl.add(edit_schema);
           edit_schema.addActionListener(menulis);  

	   return menuBar;
	} // createMenu   

	// This class implements the actionListener for the menu bar selections
	class MenuItemListener implements ActionListener
	{
	   public void actionPerformed(ActionEvent e)
	   {
	   	if(e.getActionCommand() == "Login" 
		   || e.getSource() == toolbarButtons[0])
	    	{
//		    dispose();
		    new Client();
		} //if	
		else if (e.getActionCommand() == "Logout" 
		   || e.getSource() == toolbarButtons[1])
		{
		    try{
			dbai.closeSession(sID);
			setSessionID(-1);
			setStatus(status,
			 "Logout Complete! Click 'Exit' to exit.");
		    } //try
		    catch(RemoteException ex)
		    {
			setStatus(status,"Logout failed!");
		    } //catch
		} //else if
		else if (e.getActionCommand() == "Exit" 
		   || e.getSource() == toolbarButtons[2])
		{
		    System.exit(0);
		} //else if
		else if (e.getActionCommand() == "Database Info")
		{
		    DBTable();
		} //else if
		else if (e.getActionCommand() == "Driver Info")
		{
		    DriverTable();
		} //else if
                else if (e.getActionCommand() == "SQL Info")
                {
                    SQLInfoTable();
                } //else if
		else if (e.getActionCommand() == "Submit SQL" 
		   || e.getSource() == toolbarButtons[3])
		{

		    String sqlstat = JOptionPane.showInputDialog(mainw,
                      "Enter the SQL statement below and press 'Return' for execution",
                      "Input", JOptionPane.INFORMATION_MESSAGE);
		    if(!sqlstat.trim().equals(""))
		    {
			   System.out.println(sqlstat);
		           SQLexecute("Customized View"+(int) (200*Math.random()),
			   	sqlstat.trim());
		    } //if
		} //else if
		else if (e.getActionCommand() == "Query" 
		   || e.getSource() == toolbarButtons[4])
		{
		    new searchWin();
		} //else if
		else if (e.getActionCommand() == "Insert a row" 
		   || e.getSource() == toolbarButtons[5])
		{
		    insert();
		} //else if
                else if (e.getActionCommand() == "Save" 
		   || e.getSource() == toolbarButtons[6])
                {
		    saveChange();
                } //else if
		else if (e.getActionCommand() == "Delete a row" 
		   || e.getSource() == toolbarButtons[7])
		{
		    delete();
		} //else if
		else if (e.getActionCommand() == "Update the data" 
		   || e.getSource() == toolbarButtons[8])
		{
		    JOptionPane.showMessageDialog(mainw,
                        "Open a table first and double click the cell \n" 
			+"containing the data you want to update. Then \n"
			+"input the value and click 'Return' on your \n"
			+"keyboard.",
                        "Information", JOptionPane.INFORMATION_MESSAGE);

		} //else if
		else if (e.getActionCommand() == "Create new table" 
		   || e.getSource() == toolbarButtons[9])
		{
		    new createTableWin();
		} //else if
		else if (e.getActionCommand() == "Drop a table" 
		   || e.getSource() == toolbarButtons[10])
		{
		    new dropTableWin();
		} //else if
		else if (e.getActionCommand() == "Modify table schema" 
		   || e.getSource() == toolbarButtons[11])
		{
		    new editSchemaWin();
		} //else if
		else ;
	   } //actionPerformed
	} //MenuItemListener

	// This method is used to build a toolBar with toolTips.
	public JPanel buildToolBar()
	{
	   JPanel toolBarPane = new JPanel();
	   toolBarPane.setLayout(new FlowLayout());
	   JToolBar toolbar = new JToolBar();
	   String[] toolbarNames = {"login_.gif","logout_.gif",
		"exit_.gif", "SQL_.gif", "search1_.gif", 
		"insert1_.gif", "save2_.gif","delete_.gif",
		"update_gif", "create_.gif", "drop_.gif", 
		"delete1_.gif", "help1_.gif"};
	   toolbarButtons = new JButton[toolbarNames.length];
 	   MenuItemListener menulis = new MenuItemListener();
	   String[] toolTips = {"Login", "Logout", "Exit", 
		"Write your own SQL statement",
		"Search the database", "Insert a new row", 
		"Save change", "Delete a row", 
		"Update the data", "Create new table", 
		"Delete a table", "Modify table schema", 
		"Help information"};	

	   for (int i=0; i< toolbarNames.length; i++)
	   {
		toolbarButtons[i] = new JButton(
			new ImageIcon(toolbarNames[i]));
		toolbar.add(toolbarButtons[i]);
		toolbarButtons[i].setToolTipText(toolTips[i]);
		toolbarButtons[i].addActionListener(menulis);
	   } //for

	   toolBarPane.add(toolbar);
	   return toolBarPane;

	} //buildToolBar

	// This method is used to build the catalog, schema and table tree.
	public JPanel buildTree()
	{
	   Vector catalogs = null;
	   Vector schemas = null;
	   Vector tables = null;
	 
	   String[] tableTypes = {"TABLE", "VIEW"};
	   
	   try{
		catalogs = dbai.getCatalog(sID);
		int num_catalog = catalogs.size();
		catalogNodes = new DefaultMutableTreeNode[num_catalog];

		schemas = dbai.getSchema(sID);
                int num_schema = schemas.size();
                schemaNodes = new DefaultMutableTreeNode[num_schema];

		root = new DefaultMutableTreeNode("Database Tree");
		if ( ((String) catalogs.elementAt(0)).equals(""))
		{
		    catalogNodes[0] = new DefaultMutableTreeNode("Catalog");
		    root.add(catalogNodes[0]);
		    num_catalog = 1;
		    if (num_schema>0)
                    {
                       for (int j=0; j<num_schema; j++)
                       {
                           schemaNodes[j] = new DefaultMutableTreeNode(
				(String)schemas.elementAt(j));
                           catalogNodes[0].add(schemaNodes[j]);
                           tables = dbai.getTables("None",
                                   (String)schemas.elementAt(j), tableTypes, sID);
			
                           for(int k=0; k<tables.size(); k++)
                           {
                              DefaultMutableTreeNode table = new
                                  DefaultMutableTreeNode((String)(tables.elementAt(k)));
                              schemaNodes[j].add(table);
			      tableNames.addElement((String)(schemas.elementAt(j))+ "." 
				+ (String)(tables.elementAt(k)));
                           } //for k
                        } //for j
                     } //inner if
		} //if 
		else 
		{
		    for(int i=0; i<num_catalog; i++)
		    {
			catalogNodes[i] = new DefaultMutableTreeNode(
				(String)catalogs.elementAt(i));
			root.add(catalogNodes[i]);
		        if (num_schema>0)
		        {
			   for (int j=0; j<num_schema; j++)
			   {
			       schemaNodes[j] = new DefaultMutableTreeNode(
				(String)schemas.elementAt(j));
			       catalogNodes[i].add(schemaNodes[j]);
			       tables = dbai.getTables((String)catalogs.elementAt(i),
					(String)schemas.elementAt(j), tableTypes, sID);
			       for(int k=0; k<tables.size(); k++)
			       {
				  DefaultMutableTreeNode table = new
				      DefaultMutableTreeNode((String)(tables.elementAt(k)));
				  schemaNodes[j].add(table);
				  tableNames.addElement((String)(schemas.elementAt(j)) + "."
                                	+ (String)(tables.elementAt(k)));
			       } //for k
			   } //for j
		        } //if
		    } // for i    
		} //else
	   } //try
	   catch(RemoteException ex)
	   {	
		setStatus(status, "Error in building the tree structure."); 
	   }
	
	   treeModel = new DefaultTreeModel(root);
	   tree = new JTree(treeModel);
	   tree.setEditable(true);
	   tree.getSelectionModel().setSelectionMode(
		TreeSelectionModel.SINGLE_TREE_SELECTION);
	   tree.setShowsRootHandles(true);
	   tree.putClientProperty("JTree.lineStyle", "Angled");

	   JPanel treePanel = new JPanel();
	   treePanel.setLayout(new BorderLayout());
	   treePanel.setSize(width/4,height*4);
	   JScrollPane scroll = new JScrollPane(tree);
	   scroll.setMinimumSize(new Dimension(width/4, height));
	   treePanel.add(scroll);
           TreeSelectionListener ts = new treeSelection();
	   TreeExpansionListener te = new treeExpansion();
	   tree.addTreeSelectionListener(ts);
	   tree.addTreeExpansionListener(te);
	   treePanel.validate();

	   return treePanel;
	} //buildTree

	// This method returns the node being selected.
	public DefaultMutableTreeNode getSelectedNode()
	{
	   TreePath path = tree.getSelectionPath();
	   if(path !=null)
		return (DefaultMutableTreeNode)path.getLastPathComponent();
	   return null;
	} //getSelectedNode

        // This method is used to remove a specified tree node.
        public void removeNode(DefaultMutableTreeNode aNode) 
	{
                treeModel.removeNodeFromParent(aNode);
                return;
        } 

        // This method is used to add a node to a specified parent node.
        public void addObject(DefaultMutableTreeNode
		parent, Object child, boolean shouldBeVisible) 
	{
            DefaultMutableTreeNode childNode = 
                new DefaultMutableTreeNode(child);

            if (parent == null) {
                parent = root;
            }

            treeModel.insertNodeInto(childNode, parent, 
                                 parent.getChildCount());

            // Make sure the user can see the new node.
            if (shouldBeVisible) {
               tree.scrollPathToVisible(new TreePath(childNode.getPath()));
            }
        }

	// This class is used to implement the TreeSelectionListener
	class treeSelection implements TreeSelectionListener
	{
	   public void valueChanged(TreeSelectionEvent e)
	   {
		DefaultMutableTreeNode selItem = getSelectedNode();
		if (selItem != null)
		{
		    if(selItem.isLeaf() && selItem.getLevel() == 3)
		    {
			setStatus(status, selItem + "Table Selected");
			DefaultMutableTreeNode parent=
			    (DefaultMutableTreeNode)selItem.getParent();
			String tablename = parent+ "." +selItem;
			try{
			    tID = dbai.selectAll(tablename, sID);
			    setStatus(status, "Opening Table: " + tablename);
			    addTabTo(tablename, new buildTable(tablename,null,0, tID));
		  	} //try 
			catch(Exception ex)
			{
			    JOptionPane.showMessageDialog(mainw,
	                        "You do not have privilege to access this account! ",
        	                "Error", JOptionPane.ERROR_MESSAGE);
			} //catch

		    } //if 
		    else if (selItem.isLeaf() && selItem.getLevel() == 2)
		    {
		       JOptionPane.showMessageDialog(mainw, 
			"You do not have privilege to access this account! ", 
			"Error", JOptionPane.ERROR_MESSAGE); 
		    } //else if	
		} //if
	   } // valueChanged
	} //treeSelection

	// This class is to implement the TreeExpansionListener
	class treeExpansion implements TreeExpansionListener
	{
	    public void treeExpanded(TreeExpansionEvent e)
	    {
		validate();
	    } //treeExpanded
	    public void treeCollapsed(TreeExpansionEvent e)
	    {
		validate();
	    } //treeCollapsed
	} // TreeExapnsionListener

	// This method is ussed to add a component to a tabbed folder and
	// then add the folder to the tabbed pane.
	public void addTabTo(String title, Component com)  //may add tips
	{
	    int index = tabbedPane.indexOfTab(title);
            if(index == (-1)){
 	       tabbedPane.setFont(defaultFont);
	       tabbedPane.addTab(title, com);
	       tabbedPane.setSelectedIndex(tabbedPane.getTabCount()-1);
            } //if  
	    else{
               tabbedPane.setSelectedIndex(index);
	    }
	} //addTabTo 

	// This methods is used to  build a table from the DBMSInfo on the
	// remote server.
	public void DBTable()
	{
	    try{
		tID = dbai.getDBMSInfo(sID);
		addTabTo("Database Info", new buildTable("DatabaseInfo",
			null, 0, tID));
	    } //try
	    catch(RemoteException ex)
	    {
		setStatus(status, "Error on getting Database Info");
	    } //catch
	} //DBTable 

	// This method is similar to the previous method. It is used to
	// build a table from DriverInfo on the remote server.
	public void DriverTable()
	{
	    try{
		tID = dbai.getDriverInfo(sID);
		addTabTo("Driver Info", new buildTable("DriverInfo",
			null, 0, tID));
	    } //try
	    catch(RemoteException ex)
	    {
		setStatus(status, "Error in getting Driver Info");
	    } //catch
	} //DriverTable

	// This method is similar to the previous method. It is used to
	// build a table from SQLInfo on the remote server.
	public void SQLInfoTable()
	{
            try{
                tID = dbai.getSQLInfo(sID);
                addTabTo("SQL Level Info", new buildTable("SQLInfo",
                        null, 0, tID));
            } //try
            catch(RemoteException ex)
            {   
                setStatus(status, "Error in getting SQL Info");
            } //catch
	} //SQLInfoTable

	// This method is to execute the SQL statemnent that the user submit.
	public void SQLexecute(String tabName, String sqlstat)
        {
            int[] tableIDs= new int[1];
	    int tbID = -1;
            try{
                tableIDs = dbai.exeSQLstatement(sqlstat, sID);
                tbID = tableIDs[0];
                setStatus(status, "SQL statement is sucessful!");
            } //try
            catch(Exception ex)
            {
                JOptionPane.showMessageDialog(mainw,
                    "The SQL statement you submit to the database is wrong! ",
                    "Error", JOptionPane.ERROR_MESSAGE);
                return;
            } //catch
            
	    if(sqlstat.toLowerCase().startsWith("select")){
		tID = tbID;
                addTabTo(tabName, new buildTable(tabName,null,0,tID));
	    } //if
	    else{
		try{
		    dbai.setCommit(sID);
		    dbai.closeTable(tbID);
		}//try
		catch(RemoteException ex)
                {
                    System.out.println("Errors in closeTable(). ");
		    return;
                } //catch

		setStatus(status, "The SQL statement has been executed sucessfully!");
	    } //else
        } //query
 
	// This method is used to do the query operation and show the result as a
	// table format.
	public void query(String tabName, String sqlstat)
	{
	    int[] tIDs= new int[10];
	    try{
               	tIDs = dbai.exeSQLstatement(sqlstat, sID);
		tID = tIDs[0];
                setStatus(status, "SQL statement is sucessful!");
            } //try
            catch(Exception ex)
            {
		JOptionPane.showMessageDialog(mainw,
                    "The SQL statement you submit to the database is wrong! ",
                    "Error", JOptionPane.ERROR_MESSAGE);
		return;
            } //catch
   
            addTabTo(tabName, new buildTable(tabName,null,0,tID));
	} //query

	// This method is used to insert the data into the database.
	public void insert()
        {       
	
	    Vector[] rawData = ((buildTable)tabbedPane.getSelectedComponent()).getData();
	    int rowCount = rawData.length;
	    int colCount;     
	    if(rowCount != 0){
	    	colCount = rawData[0].size();
	    }//if
	    else {
		colCount = ((buildTable)tabbedPane.getSelectedComponent()).getTable().getColumnCount();
	    } //else
	    Vector newRow = new Vector();
	    for (int i = 0; i< colCount; i++)
	    {
		newRow.addElement("");
	    } // for
	    Vector[] modified = new Vector[rowCount+1];
	    if (rawData != null){
		for(int i=0; i<rowCount; i++)
		    modified[i] = rawData[i];
	    } //if
	    modified[rowCount] = newRow;
	    String name = ((buildTable)tabbedPane.getSelectedComponent()).getTableName();
	    int index = tabbedPane.getSelectedIndex();
	    tabbedPane.setComponentAt(index, new buildTable(name,modified,1,tID));
	    tabbedPane.setSelectedIndex(index);	    
	System.out.println("The insert is completed!");
        } //insert

	// This method is used to save rows users newly inserted into the table.
	public void saveChange()
	{
	    buildTable bt = (buildTable)tabbedPane.getSelectedComponent();
	    JTable table = bt.getTable();
	    int row = bt.getOriginalRowCount();
	    int rowAfter = table.getRowCount();
	    String check;
	    if (rowAfter > row)
	    {
		String table_name = bt.getTableName();
		String insertsql = "insert into " + table_name + " values(";
		for(int j=0; j< (rowAfter-row); j++)
		{
		    check = new String();
		    for(int i = 0; i<table.getColumnCount(); i++) {
			check = check + dbTojava(i, table.getValueAt(row+j, i));      
                        insertsql = insertsql + dbTojava(i, table.getValueAt(row+j, i));
                        if (i != (table.getColumnCount()-1)) {
                            insertsql = insertsql + ", ";
                        } //if
		    } //for
		    insertsql = insertsql + ")";
                        System.out.println(insertsql);
		    if (!check.trim().equals("")){
                        try {
                            int[] tableIDs= new int[1];
                            tableIDs = dbai.exeSQLstatement(insertsql, sID);
                            int tbID = tableIDs[0];
                            setStatus(status, "The new row has been inserted!");
                            dbai.closeTable(tbID);
			    dbai.setCommit(sID);
                    	} //try
                    	catch(Exception ex)
                    	{
        		    JOptionPane.showMessageDialog(mainw,
                        	"The data you just insert can not be saved \n"
				+"in the database. The reason is because \n"
				+"some fields are invalid. For example, you \n"
				+"can not enter a string if the data type is \n"
				+"integer.",
                        	"Error", JOptionPane.ERROR_MESSAGE);         
			    return;
                    	} //catch
		    } //if
		    else{
			JOptionPane.showMessageDialog(mainw,
                        "The line " + (row+j+1) + " is empty.\n" + 
			"It can not be inserted into the"
                        +"database.\nSo it will be ignored! \n",
                        "Information", JOptionPane.INFORMATION_MESSAGE);
		    } //else
		} //for
	    } //if new row is inserted 
	} //saveChange

	// This method is used to delete a row from the database.
	public void delete()
	{
	    buildTable bt = (buildTable)tabbedPane.getSelectedComponent();
	    JTable table = bt.getTable();
	    String table_name = bt.getTableName();
	    int selectedRow = table.getSelectedRow();
	    String check = new String();
	    String deletesql = "delete from " + table_name + " where ";
	    for(int i = 0; i<table.getColumnCount(); i++) {
                String colName = table.getColumnName(i);
                if (colName.equals("")||table.getValueAt(selectedRow, i).equals(" ")) 
                   continue;
                deletesql = deletesql + colName +" = "+
                   dbTojava(i, table.getValueAt(selectedRow, i));
		check = check + table.getValueAt(selectedRow, i);
                if (i != (table.getColumnCount()-1)) 
                     	deletesql = deletesql + " and ";
            } //for
	  if (!check.trim().equals("")){
	    if (deletesql.endsWith("and "))
		deletesql = deletesql.substring(0, deletesql.length()-4);
                        System.out.println(deletesql);
            try {
               	int[] tableIDs= new int[1];
                tableIDs = dbai.exeSQLstatement(deletesql, sID);
                int tbID = tableIDs[0];
                setStatus(status, "The row has been deleted!");
                dbai.closeTable(tbID);
		dbai.setCommit(sID);
            } //try
            catch(Exception ex)
            {
		JOptionPane.showMessageDialog(mainw,
                        "Error in execute 'Delete' operation ",
                        "Error", JOptionPane.ERROR_MESSAGE);
                System.out.println("Error in exeSQLStatement");
		return;
            } //catch
	  }// if
            Vector[] rawData = ((buildTable)tabbedPane.getSelectedComponent()).getData();
            int rowCount = rawData.length;
            System.out.println("The rowCount is "+rowCount);
            Vector[] newData = new Vector[rowCount-1];
	    if (selectedRow == 0)
	    {
		for(int i=0; i<rowCount-1; i++)
		{
		    newData[i] = rawData[i+1];
		} //for
	    } //if the first row is deleted
	    else if(selectedRow == rowCount)
	    {
		for(int i=0; i<rowCount-1; i++)
		{
		    newData[i] = rawData[i];
		} //for
	    } //else if the last row is deleted
	    else{
            	for(int i=0; i<selectedRow; i++)
            	{
                    newData[i] = rawData[i];
            	} //for
	    	for(int i=selectedRow+1; i<rowCount; i++)
	    	{
		    newData[i-1] = rawData[i];
	    	} //for
	    } //else the row in the middle is deleted.
            String name = ((buildTable)tabbedPane.getSelectedComponent()).getTableName();
            int index = tabbedPane.getSelectedIndex();
            tabbedPane.setComponentAt(index, new buildTable(name,newData,2,tID));
            tabbedPane.setSelectedIndex(index);
        System.out.println("The delete is completed!");
	} //delete

	// This method is used to create a new table into the database.
	public void create_table(String name, String sqlstat)
        {
            int[] tableIDs= new int[1];
            try{
                tableIDs = dbai.exeSQLstatement(sqlstat, sID);
                int tbID = tableIDs[0];
                setStatus(status, "SQL statement is sucessful! ");
		dbai.closeTable(tbID);
		dbai.setCommit(sID);
            } //try
            catch(Exception ex)
            {
		JOptionPane.showMessageDialog(mainw,
                        "Error in 'Create Table' operation!",
                        "Error", JOptionPane.ERROR_MESSAGE);     
		return;
            } //catch
	    int length = schemaNodes.length;
	    int j = 0;
	    for (int i=0; i<length; i++)
	    {
		if (schemaNodes[i].toString().equalsIgnoreCase(username))
		{
		    j = i;
		    break;
		} // if	
	    } //for 
	    tableNames.addElement(username + "." + name);

	    addObject(schemaNodes[j], name, false);
        } //create_table

	// This method is used to build the table when a table node is
	// selected.
	class buildTable extends JPanel
	{
	    Vector[] data = null;
	    String[] titles = null;
	    int num_col = 0;
	    int num_row = 0;
	    int tableID;
	    String table_name = new String();
	    JTable table;
	    int flag = 0; //flag is to see whether num_row need to be modified
	    // flag value is used to know whether the insert or delete operation is issued
	    // flag = 0 normal openTable operation
	    // flag = 1 insert operation
	    // flag = 2 delete operation		 

	    // Contructor of buildTable
	    public buildTable(String tableName, Vector[] raw, int setflag, int taID)
	    {
		super(true);
		tableID = taID;
		table_name = tableName;
		TableColumn new_col = null;
		flag = setflag;
		tableDataModel dataModel = new tableDataModel();
		if(raw == null)
		{
		// Cache all data into a vector to be used as a data cache
		try{
		    num_row = dbai.getNumOfRows(tableID);
		    data = new Vector[num_row];
		    for(int i=0; i< num_row; i++)
		    {
			data[i] = dbai.getRow(i+1, tableID);
		    } //for 	
		} //try
		catch(RemoteException ex)
		{
		    setStatus(status, "Errors in getRow(). ");
		} //catch
		setStatus(status, "Retrieve " + num_row + " rows.");
		} //end of if(raw == null)
		else {	
		    if (flag == 1){
		        num_row = raw.length-1;
		        data = raw;
		    } //this is a insert operation
		    else if (flag == 2)
		    {
			num_row = raw.length+1;
			data = raw;
		    } //else. This is a delete operation
		System.out.println("I am into the raw block!!!");
		} //else
		try{
		    num_col = dbai.getNumOfColumns(tableID);
		    titles = new String[num_col];
		    for(int i=0; i<num_col; i++)
		    {
			titles[i] = (String)dbai.getColumnTitle(
				i+1, tableID);
		    } //for
		} //try
		catch(RemoteException ex)
		{
		System.out.println("Error in getting the column titles");
		    setStatus(status, "Error in getting column titles");
		} //catch

		table = new JTable(dataModel);
	        JScrollPane pane = new JScrollPane(table);
		setLayout(new BorderLayout());
		add("Center", pane);
		validate();
	    } //buildTable constructor
	
	    // This method is used to return the table component in buildTable Panel.
	    public JTable getTable()
	    {
		return table;
	    } //getTable

	    // This method is used to get the tableNames.
	    public String getTableName()
	    {
		return table_name;
	    } //getTableName

	    // This method is to get the data in the table.
	    public Vector[] getData()
	    {
		    return data;
 	    } //getData
	
	    // This method is used to get the original row count.
	    public int getOriginalRowCount()
	    {
		return num_row;
	    } //getOriginalRowCount

	    // This class is to implement the methods in the model AbstractTableModel
	    class tableDataModel extends AbstractTableModel
	    {
	        public int getColumnCount()
	        {
		   try{
                       return dbai.getNumOfColumns(tableID);
                   } //try
                   catch (RemoteException ex)
                   {
                       System.out.println("Error in getColumnCount");
                   } //catch   
                   return -1;  
	        } // getColumnCount

	        public int getRowCount()
	        {
		   try{
	 	        if(flag == 0) 
			     num_row = dbai.getNumOfRows(tableID);
		      	if(flag == 1)
			     return num_row+1;
			if(flag == 2)
			     return num_row-1;  
		       	return num_row;
		   } //try
		   catch (RemoteException ex)
		   {
		       System.out.println("Error in getRowCount");
		   } //catch
		   return -1;
	        } // getRowCount

	        public Object getValueAt(int row, int col)
	        {
		   Object temp = (data[row].elementAt(col));
		   if(temp!=null)
		       return temp;
		   else
		       return (" ");
    	        } //getValueAt 

		public String getColumnName(int col) {
		   return titles[col];
		} //getColumnName

		public Class getColumnClass(int col)
		{
		   int type = Types.CHAR;
		   try{
			type = dbai.getColumnType(col+1, tID);
		   } //try
		   catch(RemoteException ex)
		   {
			System.out.println("Get column type error!");
		   } //catch
		
		   switch(type){
			case Types.CHAR:
		        case Types.VARCHAR:
		            return String.class;
            
        		case Types.BIT:
            		    return Boolean.class;
            
        		case Types.TINYINT:
        		case Types.SMALLINT:
        		case Types.INTEGER:
            		    return Integer.class;  
         
        		case Types.BIGINT:
            		    return Long.class;
            
        		case Types.FLOAT:
        		case Types.DOUBLE:
            		    return Double.class;
            
        		case Types.DATE:
           		    return java.sql.Date.class;

		        default:
            		    return Object.class;
 
		   } //switch
		} //getColumnClass

	        public boolean isCellEditable(int row, int col)
                { 
		   return true; 
	        } //isCellEditable
		
		// This method is to help to do the delete operation
		public void setNum_row(int rows)
		{
		   num_row = rows;
		} //setNum_row

                public void setValueAt(Object value, int row, int col) 
	        {
		    if((flag==0)||((flag==1) && row < num_row)){
	            	if (table_name == null) {
                	    System.out.println("Table name returned null.");
            		}
            	        String columnName = getColumnName(col);
            	        String query = "update " + table_name + " set " + columnName + 
			    " = " + dbTojava(col, value) + " where ";
               	        // Since I don't know the primary keys or which columns to
			// lock on, I'll just lock on everything.
            	        for(int i = 0; i<getColumnCount(); i++) {
                	    String colName = getColumnName(i);
                	    if (colName.equals("")||getValueAt(row, i).equals(" ")) {
                    	   	continue;
                    	    } //if
                	    query = query + colName +" = "+
                    	    dbTojava(i, getValueAt(row, i));
                	    if (i != (getColumnCount()-1)) {
                    	   	query = query + " and ";
                	    } //if
            	    	} //for
		     	if (query.endsWith("and "))
			    query = query.substring(0, query.length()-4);
            		System.out.println(query);
		    try {
		    	int[] tableIDs= new int[1];
                    	tableIDs = dbai.exeSQLstatement(query, sID);
                    	int tbID = tableIDs[0];
                    	setStatus(status, "The data has been updated!");
                    	dbai.closeTable(tbID);
			dbai.setCommit(sID);
                    } //try
                    catch(RemoteException ex)
                    {
                        System.out.println("Error in exeSQLStatement");
                    } //catch
                    data[row].setElementAt(value,col);
                    fireTableCellUpdated(row, col);
		  } //if
		  else
		  {
		     data[row].setElementAt(value,col);
                     fireTableCellUpdated(row, col);
		  } //else 
                } //setValueAt

 	     } //tableDataModeler
	}//buildTable Class

	// This method is used to convert the data from database 
	// to the proper format of java.
	public String dbTojava(int col, Object value) 
	{
	    int type;
	    if (value == null)
		return "";
	    try {
		type = dbai.getColumnType(col+1, tID);
	    } //try
	    catch (RemoteException ex)
            {
                System.out.println("Get column type error in dbTojava!");
                ex.printStackTrace();
		return value.toString();
            } //catch
		
	    switch(type) {
		case 2:
        	case Types.INTEGER:
        	case Types.DOUBLE:
        	case Types.FLOAT:
            	    return value.toString();
        	case Types.BIT:
            	    return ((Boolean)value).booleanValue() ? "1" : "0"; 
        	case Types.DATE:
            	    return value.toString(); // This will need some conversion.
        	default:
            	    return "'"+value.toString()+"'";
            } // switch
	} // dbTojava


        // This class is the inner-class of MainScreen and is used to
        // construct the correct SQL statement for search.
        class searchWin extends JFrame implements ActionListener, ItemListener
        {
	     JDialog search;
	     JComboBox tables, attributes, operators, logical_ops;
	     JList columns;
	     JLabel[] labels = new JLabel[8];
             JTextField input;
	     JTextArea text;
	     JButton[] buttons = new JButton[3];
	     JButton construct;
             JLabel header, search_status;
	     String[] att_titles;
	     StringBuffer buffer = new StringBuffer();
	     int num_col;
	     String sel_table = new String();

	     // Constructor for searchWin
             public searchWin()
             {
		JFrame fr = new JFrame();
                fr.getContentPane().setFont(new Font(
			"dialog_font",Font.PLAIN, 14));
                search = new JDialog(fr, "Search", true);  //dialog is modular
		Container c = search.getContentPane();
                c.setLayout(new BorderLayout());
                JPanel infoPanel = new JPanel();
                JPanel buttonPanel = new JPanel();
                GridBagLayout infogb = new GridBagLayout();
                GridBagConstraints infogbc = new GridBagConstraints();
                infoPanel.setLayout(infogb);
                infogbc.gridwidth = 1;
                infogbc.gridheight = 1;
                infogbc.gridx = 0;
                infogbc.gridy = 0;
                infogbc.anchor = GridBagConstraints.WEST;
                infogbc.fill = GridBagConstraints.NONE;
                String labelNames[] = {"From Table:",
			"Keep Columns:", "Search Condition", "Attributes",
			"Operators", "Value", "Logical Operators",
			"The SQL statement is:"}; 
                for (int i=0; i<8; i++)
                   labels[i] = new JLabel(labelNames[i]);
                infoPanel.add(labels[0], infogbc);
        
	 	infogbc.gridwidth = 2;
		tables = new JComboBox(tableNames);
		tables.setEditable(false);	
		tables.setSelectedIndex(0);
		tables.setMaximumSize(new Dimension(300, 30));
		tables.setMinimumSize(new Dimension(300, 30));
		tables.setMaximumRowCount(6);
	        tables.addItemListener(this);  
                infogbc.gridx = 1;
                infoPanel.add(tables, infogbc);
             
                infogbc.gridx = 0;
                infogbc.gridy ++;
		infogbc.gridwidth = 1;
                infoPanel.add(labels[1], infogbc);
		
		infogbc.gridheight = 3;
		infogbc.gridwidth = 2;
                infogbc.gridx = 1;
		columns = new JList();
		columns.setVisibleRowCount(5);
	        JScrollPane pane = new JScrollPane(columns);
		pane.setMinimumSize(new Dimension(200, 100));
		infoPanel.add(pane, infogbc);
		           
		infogbc.gridheight = 1;
		infogbc.gridwidth = 1;
                infogbc.gridx = 0;
                infogbc.gridy = 4;
		infogbc.fill = GridBagConstraints.NONE;
                infoPanel.add(labels[2],infogbc);
                infogbc.gridy ++;
		for(int i=0; i<4; i++)
		{
		    infoPanel.add(labels[i+3],infogbc);
		    infogbc.gridx ++;
		} //for

                infogbc.gridx = 0;
                infogbc.gridy ++;
		attributes = new JComboBox();
		attributes.setMinimumSize(new Dimension(135, 30));
		attributes.setMaximumSize(new Dimension(135, 30));
		attributes.addItemListener(this);
		infoPanel.add(attributes, infogbc);

		infogbc.gridx ++;
		infogbc.gridwidth = 1;
		String[] opp_names = {"", "=", ">=", "<=", "<>", ">", "<", "like"};
		operators = new JComboBox(opp_names);
		operators.setMinimumSize(new Dimension(135, 30));
		operators.addItemListener(this);
		operators.setEditable(true);
		operators.setSelectedIndex(0);
		infoPanel.add(operators, infogbc);
		
		infogbc.gridx ++;
		infogbc.gridwidth = 1;
		input = new JTextField(30);
		input.setMinimumSize(new Dimension(120, 30));
		infoPanel.add(input, infogbc);
		
		infogbc.gridx ++;
		infogbc.fill = GridBagConstraints.NONE;
                String[] log_names = {"", "and", "or", "not", "End"};
                logical_ops = new JComboBox(log_names);
		logical_ops.setMinimumSize(new Dimension(135, 30));
		logical_ops.addItemListener(this);
                logical_ops.setEditable(true);
                logical_ops.setSelectedIndex(0);
                infoPanel.add(logical_ops, infogbc);
		
		infogbc.gridx = 1;
		infogbc.gridy ++;
		infogbc.gridwidth = 2;
		construct = new JButton("   Construct SQL Statement  ");
		construct.setBorder(new CompoundBorder(new MatteBorder(20, 20, 20, 20, 
			getBackground()), new SoftBevelBorder(SoftBevelBorder.RAISED)));
		construct.addActionListener(this);
		infoPanel.add(construct, infogbc);
		
		infogbc.gridx = 0;
		infogbc.gridy ++;
		infogbc.gridwidth = 1;
		infoPanel.add(labels[7], infogbc);

		infogbc.gridy ++;
		infogbc.gridwidth = 4;
		infogbc.gridheight = 5;
		text = new JTextArea("", 5, 80);
		JScrollPane textPane = new JScrollPane(text);
		textPane.setMinimumSize(new Dimension(600, 120));
		infoPanel.add(textPane,infogbc);

		infogbc.gridx = 1;
		infogbc.gridy += 5;
		infogbc.gridheight = 1;
		infogbc.fill = GridBagConstraints.NONE;
	        String buttonNames[] = {"Submit", "Clear", "Cancel"};
                for (int i=0; i<3; i++)
                {
                    buttons[i] = new JButton(buttonNames[i]);
                    buttons[i].setMinimumSize(new Dimension(80, 40));
		    buttons[i].setBorder(new SoftBevelBorder(SoftBevelBorder.RAISED));
                    buttonPanel.add(buttons[i]);
                    buttons[i].addActionListener(this);
                } //for
                infoPanel.add(buttonPanel, infogbc);
                c.add("Center", infoPanel);
             
                search_status = new JLabel("   ", JLabel.CENTER);
                header = new JLabel("   Search the database");
 		header.setFont(new Font("header_font",Font.BOLD, 18));
             
                c.add("North", header);
                c.add("South", search_status);
                search.setSize(800, 600);
                search.setVisible(true);
            } //searchWin() Constructor
             
	    // Event handles for the JComboBox
	    public void itemStateChanged(ItemEvent e)
	    {
	       	if(e.getSource() == tables)
	    	{
	     	    String tablename = new String();
             	    if (e.getStateChange() == ItemEvent.SELECTED) {
	            tablename = (String)tables.getSelectedItem();
 
	            try{
           	        tID = dbai.selectAll(tablename, sID);
                        setStatus(search_status, "Opening Table: " + tablename);
                   } //try
                    catch(RemoteException ex)
                    {
                        System.out.println("Error in opening table");
                    } //catch
	
	            try{
                   	num_col = dbai.getNumOfColumns(tID);
                   	att_titles = new String[num_col];
	           	att_titles = (String[])dbai.getColumnTitles(tID);
		   	dbai.closeTable(tID);
                    } //try
                    catch(RemoteException ex)
                    {
                   	System.out.println("Error in getting the column titles");
                   	setStatus(search_status, "Error in getting column titles");
                    } //catch

                    columns.setListData(att_titles);
		    columns.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	            attributes.removeAllItems();
		    attributes.addItem("");
	            for(int i=1; i<num_col+1; i++)
	            {	
		   	attributes.addItem(att_titles[i-1]);
	            }
	            attributes.setSelectedIndex(0);
	            attributes.setMaximumRowCount(6);	     
	            attributes.setEditable(false);
		
                    input.setText("");
		    buffer = new StringBuffer();
	          } //if SELECTED
	        } //if
	   	else if (e.getSource() == attributes ||
			e.getSource() == operators || e.getSource() == logical_ops)
	   	{
		    if (e.getStateChange() == ItemEvent.SELECTED) {
		      	if(e.getSource() == logical_ops)
		    	{
			    if (!operators.getSelectedItem().toString().equals("like"))
			    {
			    	buffer.append("'" + input.getText().trim() + "'");
			   	text.append("'" + input.getText().trim()+ "'");
			    } //if
			    else 
			    {
			    	buffer.append("'%" + input.getText().trim() + "%'");
                           	text.append("'%" + input.getText().trim()+ "%'");
			    } //else
		            operators.setSelectedIndex(0);			
		        } //if
		        if (!((JComboBox)e.getSource()).getSelectedItem().toString().equals("End"))
		        {
		       	    buffer.append(((JComboBox)e.getSource()).getSelectedItem().toString()+ " ");
		            text.append(((JComboBox)e.getSource()).getSelectedItem().toString()+ " ");
		    	}
		    } //if
	   	} //else if
	    } //itemStateChanged

            // Event handles for all buttons in the search window.
            public void actionPerformed(ActionEvent e)
            {
                if (e.getSource() == construct)
             	{
		    sel_table = (String)tables.getSelectedItem();
		    int count = (columns.getSelectedValues()).length;
		    Object[] sel_item = new Object[count];
		    sel_item = columns.getSelectedValues();
		    StringBuffer keep_col = new StringBuffer();
		    for(int i=0; i<count; i++)
		    {
	            	keep_col.append((sel_item[i].toString()).trim());
		    	if(i != (count-1))  
		           keep_col.append(",");
		    } //for
		    sql = "select " + keep_col.toString() + " from " + sel_table
		   	+ " where " + buffer.toString();
		    text.setText(sql);
	  	System.out.println(sql);
               	} // if
	     	else if(e.getActionCommand() == "Submit")
	     	{
		    String tabname = sel_table + ".View" + (int) (50*Math.random());
                    query(tabname, sql);
                    search.setVisible(false);
                    search.dispose();
	     	} //else if	
             	else if(e.getActionCommand() == "Clear")
             	{
                    input.setText("");   
                    text.setText("");
             	} //else if
             	else if (e.getActionCommand() == "Cancel")
             	{
                    search.setVisible(false);
                    search.dispose();
             	} // else if
             	else;
            } //actionPerformed
                        
       	} //searchWin

	// This class is used to create a new table into the database, which will
	// be put into the schema with the same name with the login name.
	class createTableWin extends JFrame implements ActionListener
	{
	    JDialog createTable;
	    JLabel[] labels = new JLabel[17];
	    JTextField table_name, attribute_name, char_length, precision,
		candidate_key, primary_key, foreign_key, reference, check_condition;
	    JComboBox data_type, null_value;
	    JButton[] buttons = new JButton[6];
	    JTextArea text;
	    JLabel header, create_status;
            GridBagLayout infogb;
            GridBagConstraints infogbc;
            JPanel infoPanel;
	    StringBuffer buffer = new StringBuffer();
	    String newTableName = new String();

	    // constructor for createTableWin.
	    public createTableWin()
	    {
		JFrame fr = new JFrame();
		fr.getContentPane().setFont(new Font("dialog_font",Font.PLAIN, 14));
                createTable = new JDialog(fr, "Create Table", true);  //dialog is modular
                Container c = createTable.getContentPane();
                c.setLayout(new BorderLayout());
                infoPanel = new JPanel();
                infogb = new GridBagLayout();
                infogbc = new GridBagConstraints();
                infoPanel.setLayout(infogb);
                infogbc.fill = GridBagConstraints.BOTH;
                infogbc.anchor = GridBagConstraints.WEST;
                String labelNames[] = {"Table Name", "Table Content",
                    "Attributes", "Name", "Data Type",
		    "If you select 'CHAR' or 'VARCHAR', you need to enter the length below.",
		    "If you select 'NUMERIC', you can specify the precision (Optional) below.",
                    "Char Length", "Precision(#,#)", "Constraints",
                    "Specify whether the attribute allow 'null' value",
                    "Candidate Key", "Primary Key", "Foreign Key", "References",
	  	    "Check Condition", "Result" };
                for (int i=0; i<17; i++){
                   labels[i] = new JLabel(labelNames[i]);
		   labels[i].setBorder(new MatteBorder(5,5,5,5, getBackground()));
		} //for
		String buttonNames[] = {"   Add   ", "  Clear  ", "Construct", 
		   " Submit ", "Clear All", " Cancel "};
		for (int i=0; i<6; i++){
		   buttons[i] = new JButton(buttonNames[i]);
		   buttons[i].setBorder(new CompoundBorder(
			new MatteBorder(5,5,5,5,getBackground()),
			new SoftBevelBorder(SoftBevelBorder.RAISED)));
		   buttons[i].setMinimumSize(new Dimension(80, 50));
		   buttons[i].addActionListener(this);
		} 

                addComponent(infoPanel, infogbc, labels[0], 0, 0, 1, 1);
		table_name = new JTextField(30);
		table_name.setBorder(new MatteBorder(5,5,5,5, getBackground()));
		addComponent(infoPanel, infogbc, table_name, 0, 1, 2, 1);
		
		addComponent(infoPanel, infogbc, labels[1], 1, 0, 1, 1);
		addComponent(infoPanel, infogbc, labels[2], 2, 0, 1, 1);
		addComponent(infoPanel, infogbc, labels[3], 2, 1, 1, 1);
		attribute_name = new JTextField(20);
		attribute_name.setBorder(new MatteBorder(5,5,5,5, getBackground()));
		addComponent(infoPanel, infogbc, attribute_name, 2, 2, 1, 1);
		addComponent(infoPanel, infogbc, labels[4], 2, 3, 1, 1);

		data_type = new JComboBox(sql_type);
		data_type.setSelectedIndex(0);
		data_type.setMaximumRowCount(6);
		data_type.setEditable(true);
		addComponent(infoPanel, infogbc, data_type, 2, 4, 1, 1);

		addComponent(infoPanel, infogbc, labels[5], 3, 1, 4, 1);
		addComponent(infoPanel, infogbc, labels[6], 4, 1, 4, 1);
		addComponent(infoPanel, infogbc, labels[7], 5, 1, 1, 1);
		char_length = new JTextField(20);
		char_length.setBorder(new MatteBorder(5,5,5,5, getBackground()));
		addComponent(infoPanel, infogbc, char_length, 5, 2, 1, 1);
		addComponent(infoPanel, infogbc, labels[8], 5, 3, 1, 1);
		precision = new JTextField(20);
		precision.setBorder(new MatteBorder(5,5,5,5, getBackground()));
		addComponent(infoPanel, infogbc, precision, 5, 4, 1, 1);

		addComponent(infoPanel, infogbc, labels[9], 6, 0, 1, 1);
		addComponent(infoPanel, infogbc, labels[10], 7, 1, 3, 1);
		String null_val[] = {"", "not null"};
		null_value = new JComboBox(null_val);
		null_value.setBorder(new MatteBorder(5,5,5,5, getBackground()));
		null_value.setSelectedIndex(0);
		null_value.setEditable(false);
		addComponent(infoPanel, infogbc, null_value, 7, 4, 1, 1);

		addComponent(infoPanel, infogbc, labels[11], 8, 1, 1, 1);
		candidate_key = new JTextField(20);
		candidate_key.setBorder(new MatteBorder(5,5,5,5, getBackground()));
		addComponent(infoPanel, infogbc, candidate_key, 8, 2, 1, 1);
		addComponent(infoPanel, infogbc, labels[12], 8, 3, 1, 1);
		primary_key = new JTextField(20);
		primary_key.setBorder(new MatteBorder(5,5,5,5, getBackground()));
		addComponent(infoPanel, infogbc, primary_key, 8, 4, 1, 1);

		addComponent(infoPanel, infogbc, labels[13], 9, 1, 1, 1);
		foreign_key = new JTextField(20);
		foreign_key.setBorder(new MatteBorder(5,5,5,5, getBackground()));
		addComponent(infoPanel, infogbc, foreign_key, 9, 2, 1, 1);
		addComponent(infoPanel, infogbc, labels[14], 9, 3, 1, 1);
		reference = new JTextField(20);
		reference.setBorder(new MatteBorder(5,5,5,5, getBackground()));
		addComponent(infoPanel, infogbc, reference, 9, 4, 1, 1);
		addComponent(infoPanel, infogbc, labels[15], 10, 1, 1, 1);
		check_condition = new JTextField(60);
		check_condition.setBorder(new MatteBorder(5,5,5,5, getBackground()));
		addComponent(infoPanel, infogbc, check_condition, 10, 2, 3, 1);

		addComponent(infoPanel, infogbc, labels[16], 11, 0, 1, 1);
		text = new JTextArea("", 20, 80);
		text.setEditable(true);
		JScrollPane textPane = new JScrollPane(text);
		textPane.setMinimumSize(new Dimension(350, 60));
		addComponent(infoPanel, infogbc, textPane, 12, 1, 3, 3);				
                infogbc.anchor = GridBagConstraints.CENTER;
		addComponent(infoPanel, infogbc, buttons[0], 12, 4, 1, 1);
		addComponent(infoPanel, infogbc, buttons[1], 13, 4, 1, 1);
		addComponent(infoPanel, infogbc, buttons[2], 14, 4, 1, 1);
                infogbc.anchor = GridBagConstraints.WEST;
		addComponent(infoPanel, infogbc, buttons[3], 15, 1, 1, 1);
                infogbc.anchor = GridBagConstraints.CENTER;
		addComponent(infoPanel, infogbc, buttons[4], 15, 2, 1, 1);
                infogbc.anchor = GridBagConstraints.EAST;
		addComponent(infoPanel, infogbc, buttons[5], 15, 3, 1, 1);

                create_status = new JLabel("   ", JLabel.CENTER);
                header = new JLabel("   Create New Table:");
                header.setFont(new Font("header_font",Font.BOLD, 18));
                
                c.add("North", header);
		c.add("Center", infoPanel);
                c.add("South", create_status);
                createTable.setSize(800, 800);
                createTable.setVisible(true);
	    } //createTableWin constructor

	    // Event handles for all buttons in the creatTable window.
            public void actionPerformed(ActionEvent e)
            {
		String temp = new String();
                if (e.getSource() == buttons[0])
                {
		    String name = new String();
		    name = attribute_name.getText().trim();
		    String type = new String();
		    type = (String)data_type.getSelectedItem();
		    String length = new String();
		    if(name.equals(""))
		    {
			setStatus(create_status, "You must specify the attribute name!");
			clearAll();
		    	return;
		    }
		    else{
			if (type.equals("CHAR") || type.equals("VARCHAR"))
			{
			    length = char_length.getText().trim();
			    if (length.equals("")){
				setStatus(create_status, 
				   "You need to input the Character length!");
			    	return;
			    } //if
			    else
				length = "(" + length + ")";
			} //if
			else if (type.equals("NUMERIC"))
			{
			    temp = precision.getText().trim();
			    if (!temp.equals(""))
				temp = "(" + temp + ")";
			} //else if
			else;
		        buffer.append(name+ " " + type + length + temp + 
			    (String)null_value.getSelectedItem()+ ",\n");
			temp = candidate_key.getText().trim();
			if(!temp.equals(""))
			    temp = "unique(" + temp + "),\n";
			buffer.append(temp);
			temp = primary_key.getText().trim();
			if(!temp.equals(""))
			    temp = "primary key (" + temp + "),\n";
			buffer.append(temp);
			temp = foreign_key.getText().trim();
			if(!temp.equals(""))
			    temp = "foreign key(" + temp + ") ";
			buffer.append(temp);
			temp = reference.getText().trim();
			if(!temp.equals(""))
			    temp = "references " + temp + ",\n";
			buffer.append(temp);
			temp = check_condition.getText().trim();
			if(!temp.equals(""))
			    temp = "check(" + temp + "),\n";
			buffer.append(temp);
		  clearAll();
		  text.setText(buffer.toString());
		  System.out.println(buffer.toString());
		    } //else
                } // if
		else if(e.getSource() == buttons[2])
		{
		    temp = buffer.toString();
		    int index = temp.lastIndexOf(",");
		    temp = temp.substring(0,index);
		    newTableName = table_name.getText().trim();
		    if(newTableName.equals(""))
		    {
			setStatus(create_status, 
			   "Please enter the table name, and then click 'Construct' again");
			return;
		    }
		    sql = "create table " + newTableName + "(" + temp + ")";
		System.out.println(sql);
		    text.setText(sql);
		} //else if
                else if(e.getSource() == buttons[1])
                {
                    text.setText("");
                } //else if
                else if(e.getSource() == buttons[3])
                {
                    create_table(newTableName, sql);
                    createTable.setVisible(false);
                    createTable.dispose();
                } //else if
		else if (e.getSource() == buttons[4])
		{
		    table_name.setText("");
		    clearAll();
		    buffer = new StringBuffer();
		} //else if
                else if (e.getSource() == buttons[5])
                {
                    createTable.setVisible(false);
                    createTable.dispose();
                } // else if
                else;
            } //actionPerformed

	    // This method is used to test whether the textfield has input.
	    private String test_getText(JTextField t)
	    {
		String temp = new String();
	        temp = t.getText().trim();
	        if (!temp.equals(""))
		   temp = "(" + temp + "),";
		return temp;
	    } // test_getText

	    // This method is to clear all the text in the textField and textArea.
	    public void clearAll()
	    {
		attribute_name.setText("");
		char_length.setText("");
		precision.setText("");
		candidate_key.setText("");
		primary_key.setText("");
		foreign_key.setText("");
		reference.setText("");
		check_condition.setText("");
		text.setText("");
	    }
	} // createTableWin

	// This class is used to drop the table from the database. 
	class dropTableWin extends JFrame implements ActionListener
	{
	    JDialog dropTable;
	    JLabel label = new JLabel("Select tables to drop");
	    JList tableList;
	    JButton[] buttons = new JButton[3];
	    JLabel header, drop_status;
	    JPanel infoPanel, buttonPanel;
	    GridBagLayout infogb;
            GridBagConstraints infogbc;
	    int count;

	    // constructor for the dropTableWin.
	    public dropTableWin()
	    {
		getContentPane().setFont(new Font("dialog_font",
			Font.PLAIN, 14));
		dropTable = new JDialog(this, "Drop Table", true);  //dialog is modular
                Container c = dropTable.getContentPane();
                c.setLayout(new BorderLayout());
                infoPanel = new JPanel();
                infogb = new GridBagLayout();
                infogbc = new GridBagConstraints();
                infoPanel.setLayout(infogb);
                infogbc.fill = GridBagConstraints.NONE;
                infogbc.anchor = GridBagConstraints.WEST;

                String buttonNames[] = {"Drop","Cancel"};
                for (int i=0; i<2; i++){
                   buttons[i] = new JButton(buttonNames[i]);
 		   buttons[i].setBorder(new CompoundBorder(
			new MatteBorder(10,10,10,10,getBackground()), 
			new SoftBevelBorder(SoftBevelBorder.RAISED)));
                   buttons[i].setMinimumSize(new Dimension(90, 50));
                   buttons[i].addActionListener(this);
                }

                addComponent(infoPanel, infogbc, label, 0, 0, 1, 1);
		tableList = new JList(tableNames);
		tableList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);		   
		tableList.setVisibleRowCount(6);
                JScrollPane pane = new JScrollPane(tableList);
                pane.setMinimumSize(new Dimension(200, 120));
                addComponent(infoPanel, infogbc, pane, 1, 0, 1, 1);
		buttonPanel = new JPanel();
		buttonPanel.setLayout(new BorderLayout());
		buttonPanel.setSize(200, 60);
		buttonPanel.add("West", buttons[0]);
		buttonPanel.add("East", buttons[1]);
                addComponent(infoPanel, infogbc, buttonPanel, 2, 0, 1, 1);
                c.add("Center", infoPanel);
                
                drop_status = new JLabel("   ", JLabel.LEFT);
                header = new JLabel("  Drop Tables from the Database");
                header.setFont(new Font("header_font",Font.BOLD, 16));
                
                c.add("North", header);
                c.add("South", drop_status);
                dropTable.setSize(330, 300);
                dropTable.setVisible(true);

	    } //dropTableWin constructor

	    // Event handles for all buttons in the dropTable window.   
            public void actionPerformed(ActionEvent e)
            {
		Object[] selected = tableList.getSelectedValues();
		count = selected.length;
		int[] indice = tableList.getSelectedIndices();
		if (e.getSource() == buttons[0])
		{
		    String tem = ((boolean)(count>1))? "tables":"table"; 
		    int selected_option = JOptionPane.showConfirmDialog(dropTable, 
                    "Are you sure to delete the "+ count + " " + tem + "?", 
		    "Confirmation", javax.swing.JOptionPane.YES_NO_CANCEL_OPTION);
		    if (selected_option == javax.swing.JOptionPane.YES_OPTION){
		       String temp = new String();
                        int length = schemaNodes.length;
            		int j = -1;
            		for (int i=0; i<length; i++)
            		{   
                	    if (schemaNodes[i].toString().equalsIgnoreCase(username))
                	    {
                    		j = i;
                    		break;
                	    } // if   
            		} //for

			Enumeration enum;

		       	for (int i=0; i<count; i++)	
		       	{
			   temp = (String) selected[i];
			   temp = "drop table " + temp;
			   System.out.println(temp);
			   int[] tableIDs= new int[1];
            		   try{
                	      tableIDs = dbai.exeSQLstatement(temp, sID);
                	      int tbID = tableIDs[0];
                	      setStatus(drop_status, "The tables have been dropped!");
			      dbai.closeTable(tbID);
            		   } //try
            		   catch(Exception ex)
            		   {
			      JOptionPane.showMessageDialog(mainw,
                        	"Error in 'Drop Table' operation!",
                        	"Error", JOptionPane.ERROR_MESSAGE);               
			      return;
            		   } //catch
            
			   tableNames.removeElement(selected[i]);
			   for (enum = schemaNodes[j].children();
				enum.hasMoreElements() ;)
			   {
			        DefaultMutableTreeNode dt =
					(DefaultMutableTreeNode) enum.nextElement();
				if(((String)selected[i]).toLowerCase().endsWith(
				    dt.toString().toLowerCase())){
				   System.out.println(dt.toString());  
				   removeNode(dt);
				}
			   } //for
		       } //for
		    } // if
		    dropTable.setVisible(false);
                    dropTable.dispose();
		} //if
		else if(e.getSource() == buttons[1])
		{
		    dropTable.setVisible(false);
                    dropTable.dispose();
		} //else if
/*		else if(e.getSource() == buttons[2])
		{
		    try{
			dbai.setRollback(sID);
		    }
		    catch (RemoteException ex){
			setStatus (status, "Cannot undo!");
		    }

		    for (int i = 0; i< count; i++)
			tableNames.insertElementAt(selected[i], indice[i]);
		} //else if
*/		else;
	    } //actionPerformed

	} //dropTableWin

	// This class is used to edit a table's schema.
	class editSchemaWin extends JFrame implements ActionListener, ItemListener
        {
            JDialog editSchema;
            JLabel[] labels;
	    JComboBox tables, datatypes;
            JList columnList;
	    JTextField column_name, char_length, precision;
            JButton[] buttons;
            JLabel header, edit_status;
            JPanel infoPanel, buttonPanel;
            GridBagLayout infogb;
            GridBagConstraints infogbc;
	    StringBuffer buffer;
	    Vector column_left;
	    String[] att_titles;
	    int num_col;
           
            // constructor for the dropTableWin.
            public editSchemaWin()
            {
                getContentPane().setFont(new Font("dialog_font",
			Font.PLAIN, 14));
                editSchema = new JDialog(this, "Edit Table Schema", true);  //dialog is modular
                Container c = editSchema.getContentPane();
                c.setLayout(new BorderLayout());
                infoPanel = new JPanel();
                infogb = new GridBagLayout();
                infogbc = new GridBagConstraints();
                infoPanel.setLayout(infogb);
                infogbc.fill = GridBagConstraints.NONE;
                infogbc.anchor = GridBagConstraints.WEST;
                String labelNames[] = {"         Select a table for editing:",
                        "Add a column:", "Delete a column:", "New column name",
                        "Select columns to delete", "Data type", "Char length",
                        "(for 'CHAR' and 'VARCHAR')", "Precision",
                        "(for 'NUMERIC', optional)" };
		labels = new JLabel[labelNames.length];
                for (int i=0; i<labelNames.length; i++)
                   labels[i] = new JLabel(labelNames[i]);

                addComponent(infoPanel, infogbc, labels[0], 0, 0, 2, 1);
                tables = new JComboBox(tableNames);
                tables.setMaximumRowCount(8);
		tables.setMinimumSize(new Dimension(200, 30));
		tables.setMaximumSize(new Dimension(200, 30));
		tables.setSelectedIndex(0);
		tables.addItemListener(this);
                addComponent(infoPanel, infogbc, tables, 0, 2, 1, 1);

                addComponent(infoPanel, infogbc, labels[1], 1, 0, 1, 1);
                addComponent(infoPanel, infogbc, labels[2], 1, 2, 1, 1);
                addComponent(infoPanel, infogbc, labels[3], 2, 0, 1, 1);
		column_name = new JTextField(20);
		column_name.setBorder(new MatteBorder(10, 10, 10, 10, getBackground()));
		column_name.setMinimumSize(new Dimension(180, 50));
                addComponent(infoPanel, infogbc, column_name, 2, 1, 1, 1);
                addComponent(infoPanel, infogbc, labels[4], 2, 2, 1, 1);
                addComponent(infoPanel, infogbc, labels[5], 3, 0, 1, 1);
		datatypes = new JComboBox(sql_type);
		datatypes.setBorder(new MatteBorder(10, 10, 10, 10, getBackground()));
                datatypes.setMaximumRowCount(8);
                datatypes.setSelectedIndex(0);
                addComponent(infoPanel, infogbc, datatypes, 3, 1, 1, 1);

                addComponent(infoPanel, infogbc, labels[6], 4, 0, 1, 1);
		char_length = new JTextField(20);
		char_length.setBorder(new MatteBorder(10, 10, 10, 10, getBackground()));
                char_length.setMinimumSize(new Dimension(150, 50));
                addComponent(infoPanel, infogbc, char_length, 4, 1, 1, 1);
                addComponent(infoPanel, infogbc, labels[7], 5, 0, 2, 1);
                addComponent(infoPanel, infogbc, labels[8], 6, 0, 1, 1);

		precision = new JTextField(20);
       		precision.setBorder(new MatteBorder(10, 10, 10, 10, getBackground()));
                precision.setMinimumSize(new Dimension(150, 50));
                addComponent(infoPanel, infogbc, precision, 6, 1, 1, 1);
                addComponent(infoPanel, infogbc, labels[9], 7, 0, 2, 1);

                columnList = new JList();
                columnList.setSelectionMode(
			ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
                JScrollPane pane = new JScrollPane(columnList);
        	pane.setBorder(new MatteBorder(0, 10, 10, 10, getBackground()));
                pane.setMinimumSize(new Dimension(200, 150));
                addComponent(infoPanel, infogbc, pane, 3, 2, 1, 5);

                buttonPanel = new JPanel();
                buttonPanel.setLayout(new FlowLayout());
                String buttonNames[] = {"Add","Clear","Delete","Close"};
		buttons = new JButton[buttonNames.length];
                for (int i=0; i<buttonNames.length; i++){
                   buttons[i] = new JButton(buttonNames[i]);
		   buttons[i].setBorder(new SoftBevelBorder(SoftBevelBorder.RAISED));
                   buttons[i].addActionListener(this);
                   buttonPanel.add(buttons[i]);
                }
                addComponent(infoPanel, infogbc, buttonPanel, 8, 1, 2, 1);
                c.add("Center", infoPanel);
           
                edit_status = new JLabel("   ", JLabel.LEFT);
                header = new JLabel("   Edit the table schema");
                header.setFont(new Font("header_font",Font.BOLD, 18));
                
                c.add("North", header);
                c.add("South", edit_status);
                editSchema.setSize(700, 550);
                editSchema.setVisible(true);
                
            } //editSchemaWin constructor
                
		// Event handles for the JComboBox
            public void itemStateChanged(ItemEvent e)
            {
                String tablename = new String();
		column_left = new Vector();
		int tbID = -1;
                if (e.getStateChange() == ItemEvent.SELECTED) {
                    tablename = (String)tables.getSelectedItem();
        
                    try{
                        tbID = dbai.selectAll(tablename, sID);
                        setStatus(edit_status, "Opening Table: " + tablename);
                    } //try
                    catch(RemoteException ex)
                    {
                        System.out.println("Error in opening table");
                    } //catch  
            
                    try{
                        num_col = dbai.getNumOfColumns(tbID);
                        att_titles = new String[num_col];
                        att_titles = (String[])dbai.getColumnTitles(tbID);
                        dbai.closeTable(tbID);
                    } //try
                    catch(RemoteException ex)
                    {         
                        System.out.println("Error in getting the column titles");
                        setStatus(edit_status, "Error in getting column titles");
                    } //catch
		    
		    for(int i=0; i<num_col; i++)
                    {
                         column_left.addElement(att_titles[i]);
                    } //for
		    
                    columnList.setListData(column_left);
		}
	    } //itemStateChanged

            // Event handles for all buttons in the dropTable window.
            public void actionPerformed(ActionEvent e)   
            {   
                String temp = new String();
		String temp1 = new String();
                if (e.getSource() == buttons[0])
                {
		    int selected_option = JOptionPane.showConfirmDialog(editSchema,
                    	"Are you sure to add this column?",
                    	"Confirmation", javax.swing.JOptionPane.YES_NO_CANCEL_OPTION);
                    if (selected_option == javax.swing.JOptionPane.YES_OPTION){
		       buffer = new StringBuffer();
		       if (tables.getSelectedItem() != null && 
		          !column_name.getText().trim().equals("") &&
		          datatypes.getSelectedItem() != null){
			  temp = (String)datatypes.getSelectedItem();		
                          buffer.append("alter table " + (String)tables.getSelectedItem() 
			   + " add " + column_name.getText() + " " + temp);
			  if(temp.equals("CHAR")||temp.equals("VARCHAR"))
			  {
			    temp1 = char_length.getText().trim();
			    if(temp1.equals("")){
				setStatus(edit_status, "You must specify the char length!");
				return;
			    } //if
			    buffer.append("(" + temp1 + ")");
			  } //if
			  if(temp.equals("NUMERIC"))
			  {
			    temp1 = precision.getText().trim();
			    if(!temp1.equals(""))
				buffer.append("(" + temp1 + ")");
			  } //if
                          System.out.println(buffer.toString());
                          int[] tableIDs= new int[1];
                          try{
                            tableIDs = dbai.exeSQLstatement(buffer.toString(), sID);
                            int tbID = tableIDs[0];
                            setStatus(edit_status, "New column has been added!");
			    dbai.closeTable(tbID);
			    column_left.addElement(column_name.getText().trim());
			    columnList.setListData(column_left);
                          } //try
                          catch(Exception ex)
                          {
			     JOptionPane.showMessageDialog(mainw,
                        	"Error in 'Add Column' to the table! \n",
                        	"Error", JOptionPane.ERROR_MESSAGE);                       
			     return;
                          } //catch
		       } //if
		       else{
			setStatus(edit_status, 
			"The table name,column name and data type can not be blank");
		       } //else
		     }//if
		    } //if
		    else if(e.getSource() == buttons[1])
		    {
			column_name.setText("");
			char_length.setText("");
			precision.setText("");
		    } //else if
		    else if(e.getSource() == buttons[2])
		    {
			int selected_option = JOptionPane.showConfirmDialog(editSchema,
	                    "Are you sure to delete this column?",
        	            "Confirmation", javax.swing.JOptionPane.YES_NO_CANCEL_OPTION);
                	if (selected_option == javax.swing.JOptionPane.YES_OPTION){
			   buffer = new StringBuffer();
			   Vector v = new Vector();
			   for(int i=0; i<column_left.size(); i++)
			   {	
			      if(!columnList.isSelectedIndex(i))
			      {
				 v.addElement(column_left.elementAt(i));
			      } //if
			   } //for
			   int size = v.size();
			   for (int i=0; i<size; i++)
			   {
			      if (i<size-1)
				buffer.append((String)v.elementAt(i) + ", ");
			      else
				buffer.append((String)v.elementAt(i));	
			   } 			
			   temp1 = (String)tables.getSelectedItem();			
			   temp = "create table temporary as select " + buffer.toString()
				+ " from " + temp1;
			   int[] tableIDs= new int[1];
                           try{
			      dbai.setCommit(sID);
                              tableIDs = dbai.exeSQLstatement(temp, sID);
                              dbai.closeTable(tableIDs[0]);
			      tableIDs = dbai.exeSQLstatement("drop table " + temp1,sID);
                              dbai.closeTable(tableIDs[0]);
			      tableIDs = dbai.exeSQLstatement("create table " + temp1
				+ " as select * from temporary", sID);
                              dbai.closeTable(tableIDs[0]);
			      tableIDs = dbai.exeSQLstatement("drop table temporary ",sID);
                              dbai.closeTable(tableIDs[0]);
			      column_left = v;
			      columnList.setListData(column_left);
                              setStatus(edit_status, "The columns has been deleted!");
                           } //try
                           catch(Exception ex)
                           {
			      JOptionPane.showMessageDialog(mainw,
                        	"You can not delete this column! \n"
				+"It will violate the referntial \n"
				+"integrity or data integrity if \n"
				+"this column is deleted.",
                        	"Error", JOptionPane.ERROR_MESSAGE);                   
			      return;
                           } //catch
			} //if
		    } //else if
                    else if(e.getSource() == buttons[3])
                    {
                        editSchema.setVisible(false);
                        editSchema.dispose();
                    } //else if
                    else;
            	} //actionPerformed
                
        } //editSchemaWin

	// This method is helper function to easily layout the components.
	public void addComponent(JPanel pa, GridBagConstraints gbc, Component c,
	    int row, int column, int width, int height)
	{
	    //set gridx and gridy
	    gbc.gridx = column;
	    gbc.gridy = row;
		
	    //set gridwidth and gridheight
	    gbc.gridwidth = width;
	    gbc.gridheight = height;
		
	    //set constraints
	    pa.add(c, gbc);
	} // addComponent

	// This method is used to update the status line at the bottom 
	// of the screen.
	public void setStatus(JLabel lab, String message)
	{
	   lab.setText(message);
	} //setStatus

   } // MainScreen

} //Client
