using System;
using System.IO;
using System.Collections;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;


public class NonceDetails
{
	public const String NONCE_FILE_NAME = "E:\\inetpub\\wwwroot\\CSAHWS\\work\\nonces";

	public bool verifyClientNonce(int nonce)
	{
		logTimeStamp("verify client nonce ");
		Hashtable table = readNonces();
		printTable(table);
		String nonceStr = ""+nonce;

		//If nonce in table, remove from table
		//and return true
		if (table.ContainsKey(nonceStr))
		{
			table.Remove(nonceStr);
			writeNonces(table);
			return true;
		//	return "ok";
		}
		else 
		{
			return false;
		}

	}


	

	private Hashtable readNonces()
	{
		Hashtable nonceTable = new Hashtable();
		try {

			if (File.Exists(NONCE_FILE_NAME) == true)
			{

				FileStream fs = File.Open(NONCE_FILE_NAME, FileMode.Open);									
				BinaryFormatter format = new BinaryFormatter();
				nonceTable = (Hashtable)format.Deserialize(fs);
				fs.Close();	
				return nonceTable;
			}
			else
			{
				return null;
			}
		}
		catch(Exception e)
		{
			logTimeStamp("Nonce details: "+e.ToString());			
			return readNonces();
		}
	}

	private void writeNonces(Hashtable table)
	{
		try {
			FileStream fs = File.Open(NONCE_FILE_NAME, FileMode.OpenOrCreate);
			BinaryFormatter format = new BinaryFormatter();
			format.Serialize(fs, table);
			fs.Close();
		}
		catch(Exception e)
		{
			logTimeStamp(e.ToString());
			writeNonces(table);
		}
	}
	
	public int generateAndStoreNonce(String nonceIdentity)
	{
		logTimeStamp("in generate and store nonce ");
		Random clientNonce = new Random();
		int nonce = clientNonce.Next();
		Hashtable outstandingNonces = readNonces();

		// Means nonce file does not exist 
		if (outstandingNonces == null)
		{
			outstandingNonces = new Hashtable();
		}		
		if (!(outstandingNonces.ContainsValue(nonceIdentity)))
		{ 
			logTimeStamp("before adding");
			outstandingNonces.Add(nonce+"", nonceIdentity);
			logTimeStamp("after adding");
		}
	
		

		//store the nonce in nonce file
		writeNonces(outstandingNonces);
		printTable(outstandingNonces);
		logTimeStamp("return ing " + nonce);
		return nonce;
	}

	public static void Main(String[] args)
	{
		NonceDetails n = new NonceDetails();
		n.generateAndStoreNonce(""+563755712);
		Console.WriteLine(n.verifyClientNonce(563755712));
	}

	private void printTable(Hashtable hash)
	{
		IDictionaryEnumerator myEnumerator = hash.GetEnumerator();
		while ( myEnumerator.MoveNext() )
         		logTimeStamp("" + myEnumerator.Key + " " + myEnumerator.Value);	}


	private void logTimeStamp(String msg)
	{
		try{

		StreamWriter sr;
		if (File.Exists("e:\\logfile.txt") == false) {
			sr = File.CreateText("e:\\logfile.txt");

			sr.WriteLine(msg);
			//sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();
		
		}
		else {
			
			sr = File.AppendText("e:\\logfile.txt");
			sr.WriteLine(msg);
		//	sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();
		
		}
	        
		}
		catch (Exception e)
		{
		//fail silently
		}
	}



}






