using System;
using System.Collections;

public class CommObjectFunctions
{
	private Hashtable probTable;
	private ArrayList defaultValues = null;
	private String displayStr = "";

	private const int START_PROB     = 0;
	private const int NO_OF_PROBS    = 1;

	public CommObjectFunctions()
	{
		initHashtable();
	}
	
	/*
	* Set default values on the KeyValueObject
	*/
	private void setDefaultArrayList()
	{
		defaultValues = new ArrayList();
		KeyValueObject keyValue = new KeyValueObject();

		keyValue.keyObject = "nonce";
		keyValue.valueObject = "-1";
		defaultValues.Add(keyValue);	

		keyValue = new KeyValueObject();
		keyValue.keyObject = "cpuLoad";
		keyValue.valueObject = -1;
		defaultValues.Add(keyValue);	

		keyValue = new KeyValueObject();
		ArrayList defaultProblem = new ArrayList();
		defaultProblem.Insert(START_PROB, 0);
		defaultProblem.Insert(NO_OF_PROBS, 10);
		keyValue.keyObject ="problemList";
		keyValue.valueObject = defaultProblem;
		defaultValues.Add(keyValue);	

		keyValue = new KeyValueObject();
		keyValue.keyObject ="serArr";
		keyValue.valueObject = null;
		defaultValues.Add(keyValue);	

		keyValue = new KeyValueObject();
		keyValue.keyObject ="errMsg";
		keyValue.valueObject = "";
		defaultValues.Add(keyValue);	

		keyValue = new KeyValueObject();
		keyValue.keyObject ="appName";
		keyValue.valueObject = "";
		defaultValues.Add(keyValue);	
	}
	
	/*
	* Get the length of the default ArrayList.
	*/
	private int getLength()
	{
		return defaultValues.Count;
	}

	/*
	* Initialize values on the default ArrayList.
	*/
	private void initHashtable()
	{
		setDefaultArrayList();
		probTable = new Hashtable();
		for (int i = 0; i <getLength(); i++)
		{
			KeyValueObject obj = (KeyValueObject)defaultValues[i];
			addElement(obj.keyObject, obj.valueObject);
		}
	}

	/*
	* Populate the Problem Table with values from the list.
	*/
	public void setHashtable(ArrayList list)
	{
		System.Collections.IEnumerator myEnumerator = list.GetEnumerator();
		while ( myEnumerator.MoveNext() )
		{
			KeyValueObject keyValue = (KeyValueObject)myEnumerator.Current;
			addElement(keyValue.keyObject, keyValue.valueObject);
		}
	}

	/*
	* Populate the Problem Table with values from the objectArray.
	*/
	public void setHashtable(Object[] objectArray)
	{
		ArrayList list = new ArrayList();
		for(int i=0; i<objectArray.Length; i++)
		{
			list.Add(objectArray[i]);	
		}
		setHashtable(list);
	}

	public Hashtable getHashtable()
	{
		return probTable;
	}

	/*
	* Populate an ArrayList from the problemTable values and return it.
	*/
	public ArrayList getArrayList()
	{
		ArrayList list = new ArrayList();
		IDictionaryEnumerator myEnumerator = probTable.GetEnumerator();
		while ( myEnumerator.MoveNext() )
		{
			KeyValueObject keyValue = new KeyValueObject();
			keyValue.keyObject = myEnumerator.Key;
			keyValue.valueObject = myEnumerator.Value;
			list.Add(keyValue);
		}
		return list;
	}

	/*
	* Populate an objectArrayList with values from the problem table.
	*/
	public Object[] getObjectArrayList()
	{
		Object[] objectArray = new Object[probTable.Count];
		int i = 0;
		IDictionaryEnumerator myEnumerator = probTable.GetEnumerator();
		while ( myEnumerator.MoveNext() )
		{
			KeyValueObject keyValue = new KeyValueObject();
			keyValue.keyObject = myEnumerator.Key;
			keyValue.valueObject = myEnumerator.Value;
			objectArray[i++] = keyValue;
		}
		return objectArray;
	}

	/*
	* Return the object corresponding to the key in the problem table.
	*/
	public Object getElement(Object keyObj)
	{
		Object obj = null;
		if (probTable.ContainsKey(keyObj))
		{
			obj = probTable[keyObj];	
		}
		return obj;
	}

	/*
	* Add the given key-value pair to the problem table.
	*/
	public void addElement(Object keyObj, Object valueObj)
	{
		if (hasKey(keyObj))
		{
			removeElement(keyObj);
		}
		probTable.Add(keyObj, valueObj);
	}

	/*
	* Return a boolean value indicating if the key is present in the problem table.
	*/
	public bool hasKey(Object keyObj)
	{
		return probTable.Contains(keyObj);
	}
	
	/*
	* Remove the entry with the given key in the problem table.
	*/
	public void removeElement(Object keyObj)
	{
		if (probTable.ContainsKey(keyObj))
		{
			probTable.Remove(keyObj);
		}
	}

	public String toString()
	{
			displayStr += getElement("nonce");
			displayStr += " 	cpuLoad";
			displayStr += getElement("cpuLoad");
			displayStr += "startProb and noofprobs : ";
			ArrayList prob = (ArrayList)getElement("problemList");
			System.Collections.IEnumerator myEnumerator = prob.GetEnumerator();
		      	while ( myEnumerator.MoveNext() )
		      	{
		      		displayStr += "" + myEnumerator.Current;
			}
			displayStr += " 	serArr:";
			displayStr += getElement("serArr");
			displayStr += " 	errMsg:";
			displayStr += getElement("errMsg");
			displayStr += " 	appName:";
			displayStr += getElement("appName");
			return displayStr;
	}

  	public static void Main(String[] args)
	{

	}

}
