using System;
using System.IO;
using System.Reflection;
using System.Collections;
using System.Text.RegularExpressions;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;

public class ClientManager
{
	private const int START_PROB     = 0;
	private const int NO_OF_PROBS    = 1;

	/*
	* Method to deserialize the filestream read from the given file to an Object.
	*/
	public Object getObjectFromFile(String fileNameWithPath)
	{
		try
		{
			FileStream fs = File.Open(fileNameWithPath, FileMode.Open);		
			fs.Position = 0;
			BinaryFormatter formatter = new BinaryFormatter();
			Object objectFromFile =(Object)formatter.Deserialize(fs);
			fs.Close();
			return objectFromFile;
		}
		catch(System.IO.IOException e)
		{
			logTimeStamp("*****************Exception: " + fileNameWithPath);
			logTimeStamp(e.ToString());
			return null;
		}
	}

	private void logTimeStamp(String msg)
	{
		try{

		StreamWriter sr;
		if (File.Exists("e:\\logfile.txt") == false) {
			sr = File.CreateText("e:\\logfile.txt");

			sr.WriteLine(msg);
			//sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();
		
		}
		else {
			
			sr = File.AppendText("e:\\logfile.txt");
			sr.WriteLine(msg);
		//	sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();
		
		}
	        
		}
		catch (Exception e)
		{
		//fail silently
		Console.WriteLine(e.ToString());
		}
	}


	/*
	* Method to deserialize the given ByteArray to an Object.
	*/
	public Object getObjectFromArray(Byte[] byteArray)
	{
		Stream stream = new MemoryStream(byteArray);
		stream.Position = 0;
		BinaryFormatter b=new BinaryFormatter();
		Object obj =(Object)b.Deserialize(stream);
		stream.Close();
		return obj;
	}

	/*
	* Serialize the given object to a file.
	*/
	public String putObjectInFile(Object obj, String fileNameWithPath)
	{
		try 
		{
			FileStream fileStream;
			if (File.Exists(fileNameWithPath)) 
			{
				fileStream = File.Open(fileNameWithPath, FileMode.Truncate);
			}
			else 
			{
				fileStream = File.Create(fileNameWithPath);				
			}
			BinaryFormatter formatter = new BinaryFormatter();
			formatter.Serialize(fileStream, obj);
			fileStream.Close();
			return "";
		}
		catch (Exception e)
		{
			logTimeStamp(e.ToString());
			return "Exception in putObjectInFile() in class ClientManager"+fileNameWithPath;
		}
	}

	/*
	* Dynamically call a method with the given signature on the given object.
	*/
	public ArrayList invokeMethod(Object sourceObject, Object[] argObject, Type type, String methodName, String retType)
	{ 	
		ArrayList retList = new ArrayList();
		//-999 value is ignored
		try
		{
			logTimeStamp("clientmanager : invokemethod : "+type);
			MethodInfo method = type.GetMethod(methodName);
			logTimeStamp("clientmanager : invokemethod : after getting method :"+method);
			if (retType.Equals("void"))
				retList.Add(-999);
			else if (retType.Equals("int"))
			{
				retList.Add( (int)method.Invoke(sourceObject, argObject) );
			}
			else if (retType.Equals("int[]"))
			{
				int[] intArr = (int[])method.Invoke(sourceObject, argObject);
				retList.Add(intArr[0]);
				retList.Add(intArr[1]);
			}
			else if (retType.Equals("object"))
			{
				//Problem m = new Problem();
				//retList.Add(m);
				ArrayList probObj = (ArrayList)method.Invoke(sourceObject, argObject);				
				retList.Add(probObj);
			}
			else
				retList.Add ( -999);
		}
		catch(Exception e)
		{
			logTimeStamp("Server: ClientManager(): "+e.ToString());
			retList = null;
			throw new Exception("InvokeMethod : type = " + type + "***************" +e.ToString());
		}
		return retList;
	}

	/*
	* Move DLL and status files to the finished directory.
	*/
	private String cleanUpWorkDirectory(String statusFileWithPath)
	{
			StreamWriter sr;
			if (File.Exists("e:\\logfileend.txt") == false)
				sr = File.CreateText("e:\\logfileend.txt");
			else
				sr = File.AppendText("e:\\logfileend.txt");
			sr.WriteLine("workover:");
			sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();

		String retStr = "";
		try {
			//fs.Close();
			
			String DLLFileWithPath = Regex.Replace(statusFileWithPath, "status", "dll");
			String statusFinishedWithPath = Regex.Replace(statusFileWithPath, "unfinished", "finished"); 
			String DLLFinishedWithPath = Regex.Replace(DLLFileWithPath, "unfinished", "finished"); 
	

			if (File.Exists(DLLFileWithPath)) 
			{
				try
				{
					Console.WriteLine( DLLFileWithPath + " TO " + DLLFinishedWithPath);	
					File.Move(DLLFileWithPath, DLLFinishedWithPath);
					retStr += "DLL File Moved";
				}
				catch (System.IO.IOException e)
				{
					Console.Write("ClientManager: "+e.ToString());
					retStr += e.ToString();
				}
			}
			if (File.Exists(statusFileWithPath))
			{
				try
				{
					Console.WriteLine (statusFileWithPath + " TO " + statusFinishedWithPath);	
					File.Move(statusFileWithPath, statusFinishedWithPath);
					retStr += "status file moved.";
				}
				catch (System.IO.IOException e)
				{
					Console.Write("ClientManager: "+e.ToString());
					retStr += e.ToString();
				}
			}
			
		}
		catch (Exception ex)
		{
			retStr += "CleanUp : " + ex.ToString();
		}
		retStr += "ok";
		return retStr;
	}

	/*
	* Get the DLL name from the given full name with path.
	*/
	public String getDLLName(String DLLFileNameWithPath)
	{
		Regex r = new Regex("(/)");
		string[] parts = r.Split(DLLFileNameWithPath);
		return parts[parts.Length - 1];
	}
	
	/*
	* Get the class type from the dll file name
	*/
	private String getClassType(String DLLNameWithPath)
	{
		return Regex.Replace(getDLLName(DLLNameWithPath), ".dll", "");
	}

	private object getArrayItem(ArrayList list, int index)
	{
		object[] objarr = list.ToArray();
		return objarr[index];
	}

	/*
	* Calls the generateProblem method of the DLL.
	*/
	public CommObjectFunctions generateWork(CommObjectFunctions functions, String localPath)
	{
		Object objectFromFile = null;
		Object objectFromAssembly = null;
		bool createStatus = true;
		//
		// localPath = "c:\\...", appName is a http path.
		//
		String DLLFileNameWithPath  = (String)functions.getElement("appName");
		String statusFileNameWithPath = Regex.Replace(DLLFileNameWithPath, "dll", "status");
		try {
			if (File.Exists(localPath + getDLLName(statusFileNameWithPath)) == true) {
		  		String localDLL = localPath + getDLLName(statusFileNameWithPath);
				objectFromFile = getObjectFromFile(localDLL);	
				if (objectFromFile != null)
				{
					
					//if prob = -1, move status file to finished dir
					Type type = objectFromFile.GetType();	
					logTimeStamp("clientmanager - generatework : type = " + type);
					Object[] argObject = new Object[2];
			
					argObject[0] = (int)functions.getElement("cpuLoad");

					ArrayList probList = (ArrayList)functions.getElement("problemList");
					argObject[1] = (int)(getArrayItem(probList, NO_OF_PROBS));

					probList = invokeMethod(objectFromFile,  argObject, type, "generateProblem", "object");
					
					if (probList != null)
					{
						logTimeStamp("problist is not null");
						ArrayList newProb = (ArrayList)probList[0];
						logTimeStamp("after getting new prob");
						functions.addElement("problemList", newProb);

						if (newProb == null)
						{
							logTimeStamp("new prob is null");
							logTimeStamp(""+DLLFileNameWithPath);
							ArrayList list = Scheduler.getSchedulerInstance().getDatabaseManager().getNextProblem(DLLFileNameWithPath);
							if(list == null)
							{
								logTimeStamp("list is null");
								logTimeStamp("cleaning up " + localDLL);
								functions.addElement("cleanup", localDLL);
								cleanUpWorkDirectory(localDLL);
								Scheduler.getSchedulerInstance().getDatabaseManager().setStatus(getDLLName(DLLFileNameWithPath));	
								createStatus = false;
							}
							else
							{
								logTimeStamp("list is not null");
								functions.addElement("problemList",list);
								int probNo = (int)list[0];
								Scheduler.getSchedulerInstance().getDatabaseManager().updateCounter(DLLFileNameWithPath,probNo);
							}
						}
						else
						{
							logTimeStamp("new prob is not null");
							logTimeStamp("DLLFileNameWithPath = " + DLLFileNameWithPath);
							logTimeStamp("getArrayItem(newProb, START_PROB) = " + getArrayItem(newProb, START_PROB));
							
							Scheduler.getSchedulerInstance().getDatabaseManager().AddToOutStandingWork(DLLFileNameWithPath, (int)getArrayItem(newProb, START_PROB),newProb);
							functions.addElement("appName", DLLFileNameWithPath);
						}
					}
					else
					{
						logTimeStamp("problist is null");
						functions.addElement("errMsg", "invokeMethod prob no returned null.");
					}
				}
				else 
				{
					Console.WriteLine("object null");
					functions.addElement("errMsg", "Error in Server: class ClientManager getObjectFromFile()");
					objectFromFile = null;
					createStatus = false;
				}

			}
			else {
				Console.Write("status does not exist");
				try 
				{
					//Assembly Assem = Assembly.LoadFrom(DLLFileNameWithPath);
					//String DLLClassType = getClassType(DLLFileNameWithPath);
					String tmp = localPath + getDLLName(DLLFileNameWithPath);

					Assembly Assem = Assembly.LoadFrom(tmp);
					foreach(Type t in Assem.GetTypes())
					{
						Type [] Interfaces = t.GetInterfaces();       
			
						if (Interfaces.Length != 0) 
						{
							foreach (Type NextInterface in Interfaces)     
							{       
								logTimeStamp(t.FullName);
								if (NextInterface.FullName == "IAppInterface")
								{
									logTimeStamp("I am the one!!!");
								}
							}
						}
					}
					functions.addElement("assembly loaded", Assem.ToString());	
					String DLLClassType = getClassType(DLLFileNameWithPath);
					Type type = Assem.GetType(DLLClassType, true);
					logTimeStamp("The type i use: " + type.FullName);
					objectFromAssembly = Activator.CreateInstance(type);
					logTimeStamp("after createinstance ");
					Object[] argObject = new Object[2];
					
					ArrayList tempProbList = new ArrayList();
					argObject[0] = functions.getElement("cpuLoad");
					tempProbList = (ArrayList)functions.getElement("problemList");
					argObject[1] = getArrayItem(tempProbList, NO_OF_PROBS);
					logTimeStamp("new before invoke");
					ArrayList invokeRetList = invokeMethod(objectFromAssembly, argObject, type, "generateProblem", "object");
					logTimeStamp("new after invoke");
					ArrayList probList = (ArrayList)invokeRetList[0];
					functions.addElement("problemList", probList);						
					
					if (probList == null)
					{
						functions.addElement("errMsg", "Work finished");
						createStatus = false;
					}
					functions.addElement("appName", DLLFileNameWithPath);
		
				}
				catch(FileNotFoundException fileEx)
				{
					createStatus = false;
					Console.Write("ClientManager: " + fileEx.ToString());
				}
				catch(FileLoadException fileEx)
				{
					functions.addElement("errMsg2", 
					"Error in SERVER - ClientManager.generateWork()- FileLoadException\n\n"+fileEx.ToString());
					createStatus = false;
					Console.Write("ClientManager: " + fileEx.ToString());
				}
				catch(Exception fileEx)
				{
					functions.addElement("errMsg3", 
						"Error in SERVER - class ClientManager.generateWork()-Exception\n\n"+fileEx
						+"*****"+DLLFileNameWithPath+"**"
						+ getClassType(DLLFileNameWithPath));
					createStatus = false;
					Console.Write("ClientManager: " + fileEx.ToString());
					functions.addElement("tmp", localPath + getDLLName(DLLFileNameWithPath));
				}
			}
			
			//
			//now write the object to the status file so that the next
			//ClientManager picks the next problem no and not this one.
			//
			if (createStatus)
			{
				if (objectFromFile == null)
				{
					if (objectFromAssembly != null)
					{
						Console.WriteLine("puttin object in file");
						String savePath = localPath + getDLLName(statusFileNameWithPath);
						String errMsg = putObjectInFile(objectFromAssembly, savePath);
						if (errMsg.Length != 0)
							functions.addElement("errMsg", errMsg);
					}
				}
				else if (objectFromAssembly == null)
				{
					if (objectFromFile != null)
					{
						String savePath = localPath + getDLLName(statusFileNameWithPath);
						String errMsg = putObjectInFile(objectFromFile, savePath);
						if (errMsg.Length != 0)
							functions.addElement("errMsg", errMsg);
					}
				}
				else
				{
					//rt.errMsg += "Object null in Server - class ClientManager";
					functions.addElement("errMsg", "Object null in Server - class ClientManager");
				}
			}
		}
		catch(Exception e) {
			logTimeStamp("exception" + e.Message);
			Console.Write("ClientManager: "+e.ToString());
			functions.addElement("errMsg", "Error in SERVER - class ClientManager.generateWork()-  \n"+e.ToString());
		}
		return functions;
	}

	public static void Main(String[] args)
	{
		ClientManager c = new ClientManager();
		c.cleanUpWorkDirectory("e:\\inetpub\\wwwroot\\CSAHWS\\work\\unfinished\\primenos.status");
	}
}

