using System;
using System.IO;
using System.Runtime.Serialization;
using System.Reflection;
using System.Threading;
using System.Collections;

[Serializable]
public class primenos: IAppInterface  
{
	private const int START_PROB     = 0;
	private const int NO_OF_PROBS    = 1;

	private int myResult 			= -1;
	private bool done			= false;
	private int problemsGenerated 		= -1;
	
	//Current problem number
	public int currProblemNumber = -1;

	

	private const long LARGE_PRIME	= 7031741;
	//private const long LARGE_PRIME	=  47535749;
	//
	// TOTAL_PROBLEMS is square root of LARGE_PRIME
	//
	private int TOTAL_PROBLEMS;
	private const int MORE_PROBLEMS 	= 2;
	private const int LESS_PROBLEMS   	= 0;
	private const int SAME_PROBLEMS 	= 1;
	private const int INC 			= 1;
	private const int TOLERABLE_LOAD 	= 50;
	private int INITIAL_PROBLEMS            = 10;

	public primenos()
	{
		TOTAL_PROBLEMS = (int)Math.Sqrt((double)LARGE_PRIME);
		Console.WriteLine("tot probs = " +TOTAL_PROBLEMS);
		INITIAL_PROBLEMS = (TOTAL_PROBLEMS < 10)?TOTAL_PROBLEMS:10;
		Console.WriteLine("it is "+INITIAL_PROBLEMS);
		problemsGenerated = -1;
	}



	//
	// Generate the next problem number and the number of
	// problems to be given to the client based on client's
	// cpu load.
	//
	public ArrayList generateProblem(int cpuLoad, int pastProblems) 
	{
		if(done == true || problemsGenerated > TOTAL_PROBLEMS) return null;
		
		int noOfProblems = -1;

		ArrayList primeProblem = new ArrayList();

		if (pastProblems <= 0) pastProblems = INITIAL_PROBLEMS;

		
		if (cpuLoad == MORE_PROBLEMS)
		{
			noOfProblems = pastProblems + INC;			
		}
		else if (cpuLoad == LESS_PROBLEMS)
		{
			noOfProblems = pastProblems - INC;
		}
		else if (cpuLoad == SAME_PROBLEMS)
		{
			noOfProblems = pastProblems;
			//Console.Write("same problems "+noOfProblems);
		}
		else if ((cpuLoad <= 0))
		{
			noOfProblems = INITIAL_PROBLEMS;
		}
			

		primeProblem.Add(problemsGenerated + 1);
		primeProblem.Add(noOfProblems);
		
		problemsGenerated += noOfProblems;
		return primeProblem;
	}

	//set the current problemNumber value which will be used in calculate()
	//problem arraylist can be ignored.
	public int setProblem(ArrayList problem, int currprobno)
	{
		this.currProblemNumber = currprobno;
		return this.currProblemNumber;
	}

	public int acceptResult(Object Child) 
	{	
		if(done == false)
		{	
			if (((primenos) Child).done)
			{
				done = true;
				myResult = ((primenos) Child).myResult;
			}
		}
		return myResult;
		
	}

	public String showResult() 
	{
		String arrayStr = "";

		if (!done)
			arrayStr +=  "Have not found the factors yet.";
		else
		{
			arrayStr += "Found the factors: "+myResult;
			arrayStr += " and " + LARGE_PRIME/myResult;	
		}
		return arrayStr;
	}


	public String startUp() 
	{
		return "in startUp: " + calculate();
	}
	
	//use currProblemNumber to calculate results.
	public int calculate() 
	{
		int retInt = -1;
		Console.WriteLine("inside calculate "+currProblemNumber);
		//
		// If the previous time, done was true, ignore this problemNumber
		//
		if (done)
		{
			retInt = 0;
			Console.WriteLine("done");
		}
		else 
		{
			if (currProblemNumber > 1)
			{
				done = ( (LARGE_PRIME % currProblemNumber) == 0);
				
				if (done)
				{
					Console.WriteLine(" in calc: done is true"+currProblemNumber);
					myResult = currProblemNumber;					
					retInt = 0;
				}				
				
			}
		}
		
		return retInt;
	}

	

	public static void Main(String[] args)
	{
		primenos x = new primenos();
		while(true)
		{
			ArrayList list = x.generateProblem(1,10);
			if(null == list) break;
			Console.WriteLine(list[0] + " " + list[1]);	
			int start = (int)list[0];
			int no = (int)list[1];
			primenos y = new primenos();
			for(int c = start; c < start + no; ++c)
			{
				y.setProblem(list,c);
				y.startUp();
			}
			x.acceptResult(y);
	
		}
			Console.WriteLine(x.showResult());
		
	}

}





