using System;
using System.Diagnostics;
using System.Threading;

/* 
 * This is a simple CPU load measurement program. It gets 
 * the current load as float (between 0.0 and 100.0) from the
 * PerformanceCounter class in the System.Diagnostic name space.
 */

public class CpuLoadInfo {

  // auxiliary print methods 
  private static void Say ( string txt ) {
    Console.WriteLine(txt);
  }

  // auxiliary print methods 
  private static void Say() {
    Say("");
  }

  // The main method. Command line arguments are ignored.
  public static void Main() {
    Say("$Id: CpuLoadInfo.cs,v 1.2 2002/08/17 17:45:48 rz65 Exp $");
    Say();

    Say("Attempt to create a PerformanceCounter instance:");
    Say("Category name = " + CategoryName);
    Say("Counter name  = " + CounterName);
    Say("Instance name = " + InstanceName);
    PerformanceCounter pc
      = new PerformanceCounter(CategoryName,CounterName,InstanceName);
    Say("Performance counter was created.");
    Say("Property CounterType: " + pc.CounterType);
    Say();

    Say("Property CounterHelp: " + pc.CounterHelp);
    Say();
    Say("Entering measurement loop.");

    while (true) {
      Thread.Sleep(1000); // wait for 1 second
      float cpuLoad = pc.NextValue();
      Say("CPU load = " + cpuLoad + " %.");
    }
  }    

  // constants used to select the performance counter.
  private const string CategoryName = "Process";
 // private const string CounterName  = "% Processor Time";
 private const string CounterName  = "Elapsed Time";
  private const string InstanceName = "_Total";
}





